/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import org.lwjgl.input.Keyboard;

public class GameSettings {
    private static final String[] RENDER_DISTANCES = new String[]{"FAR", "NORMAL", "SHORT", "TINY"};
    private static final String[] DIFFICULTY_LEVELS = new String[]{"Peaceful", "Easy", "Normal", "Hard"};
    public float musicVolume = 1.0f;
    public float soundVolume = 1.0f;
    public float mouseSensitivity = 0.5f;
    public boolean invertMouse = false;
    public int renderDistance = 0;
    public boolean viewBobbing = true;
    public boolean anaglyph = false;
    public boolean limitFramerate = false;
    public boolean fancyGraphics = true;
    public KeyBinding keyBindForward = new KeyBinding("Forward", 17);
    public KeyBinding keyBindLeft = new KeyBinding("Left", 30);
    public KeyBinding keyBindBack = new KeyBinding("Back", 31);
    public KeyBinding keyBindRight = new KeyBinding("Right", 32);
    public KeyBinding keyBindJump = new KeyBinding("Jump", 57);
    public KeyBinding keyBindInventory = new KeyBinding("Inventory", 18);
    public KeyBinding keyBindDrop = new KeyBinding("Drop", 16);
    public KeyBinding keyBindChat = new KeyBinding("Chat", 20);
    public KeyBinding keyBindToggleFog = new KeyBinding("Toggle fog", 33);
    public KeyBinding keyBindSneak = new KeyBinding("Sneak", 42);
    public KeyBinding[] keyBindings = new KeyBinding[]{this.keyBindForward, this.keyBindLeft, this.keyBindBack, this.keyBindRight, this.keyBindJump, this.keyBindSneak, this.keyBindDrop, this.keyBindInventory, this.keyBindChat, this.keyBindToggleFog};
    protected Minecraft mc;
    private File optionsFile;
    public int numberOfOptions = 10;
    public int difficulty = 2;
    public boolean thirdPersonView = false;
    public boolean fog = true;

    public GameSettings(Minecraft minecraft, File file) {
        this.mc = minecraft;
        this.optionsFile = new File(file, "options.txt");
        this.func_1044_a();
    }

    public GameSettings() {
    }

    public String func_1043_a(int i2) {
        return this.keyBindings[i2].keyDescription + ": " + Keyboard.getKeyName((int)this.keyBindings[i2].keyCode);
    }

    public void func_1042_a(int i2, int j2) {
        this.keyBindings[i2].keyCode = j2;
        this.func_1041_b();
    }

    public void func_1048_a(int i2, float f2) {
        if (i2 == 0) {
            this.musicVolume = f2;
            this.mc.field_158_A.func_335_a();
        }
        if (i2 == 1) {
            this.soundVolume = f2;
            this.mc.field_158_A.func_335_a();
        }
        if (i2 == 3) {
            this.mouseSensitivity = f2;
        }
    }

    public void func_1045_b(int i2, int j2) {
        if (i2 == 2) {
            boolean bl2 = this.invertMouse = !this.invertMouse;
        }
        if (i2 == 4) {
            this.renderDistance += j2;
            if (this.renderDistance > 3) {
                this.renderDistance = 0;
            }
        }
        if (i2 == 5) {
            boolean bl3 = this.viewBobbing = !this.viewBobbing;
        }
        if (i2 == 6) {
            this.anaglyph = !this.anaglyph;
            this.mc.field_171_n.func_1065_b();
        }
        if (i2 == 7) {
            boolean bl4 = this.limitFramerate = !this.limitFramerate;
        }
        if (i2 == 8) {
            this.difficulty = this.difficulty + j2 & 3;
        }
        if (i2 == 9) {
            this.fancyGraphics = !this.fancyGraphics;
            this.mc.field_179_f.func_958_a();
        }
        if (i2 == 100) {
            this.fog = !this.fog;
        }
        this.func_1041_b();
    }

    public int func_1046_b(int i2) {
        if (i2 == 0) {
            return 1;
        }
        if (i2 == 1) {
            return 1;
        }
        return i2 != 3 ? 0 : 1;
    }

    public float func_1049_c(int i2) {
        if (i2 == 0) {
            return this.musicVolume;
        }
        if (i2 == 1) {
            return this.soundVolume;
        }
        if (i2 == 3) {
            return this.mouseSensitivity;
        }
        return 0.0f;
    }

    public String getOptionValue(int i2) {
        if (i2 == 0) {
            return "Music: " + (this.musicVolume <= 0.0f ? "OFF" : (int)(this.musicVolume * 100.0f) + "%");
        }
        if (i2 == 1) {
            return "Sound: " + (this.soundVolume <= 0.0f ? "OFF" : (int)(this.soundVolume * 100.0f) + "%");
        }
        if (i2 == 2) {
            return "Invert mouse: " + (this.invertMouse ? "ON" : "OFF");
        }
        if (i2 == 3) {
            if (this.mouseSensitivity == 0.0f) {
                return "Sensitivity: *yawn*";
            }
            if (this.mouseSensitivity == 1.0f) {
                return "Sensitivity: HYPERSPEED!!!";
            }
            return "Sensitivity: " + (int)(this.mouseSensitivity * 200.0f) + "%";
        }
        if (i2 == 4 && this.renderDistance != -1) {
            return "Render distance: " + RENDER_DISTANCES[this.renderDistance];
        }
        if (i2 == 5) {
            return "View bobbing: " + (this.viewBobbing ? "ON" : "OFF");
        }
        if (i2 == 6) {
            return "3d anaglyph: " + (this.anaglyph ? "ON" : "OFF");
        }
        if (i2 == 7) {
            return "Limit framerate: " + (this.limitFramerate ? "ON" : "OFF");
        }
        if (i2 == 8) {
            return "Difficulty: " + DIFFICULTY_LEVELS[this.difficulty];
        }
        if (i2 == 100) {
            return "Fog: " + (this.fog ? "ON" : "OFF");
        }
        if (i2 == 9) {
            return "Graphics: " + (this.fancyGraphics ? "FANCY" : "FAST");
        }
        return "";
    }

    public void func_1044_a() {
        try {
            if (!this.optionsFile.exists()) {
                return;
            }
            BufferedReader bufferedreader = new BufferedReader(new FileReader(this.optionsFile));
            String s2 = "";
            while ((s2 = bufferedreader.readLine()) != null) {
                String[] as2 = s2.split(":");
                if (as2[0].equals("music")) {
                    this.musicVolume = this.func_1050_a(as2[1]);
                }
                if (as2[0].equals("sound")) {
                    this.soundVolume = this.func_1050_a(as2[1]);
                }
                if (as2[0].equals("mouseSensitivity")) {
                    this.mouseSensitivity = this.func_1050_a(as2[1]);
                }
                if (as2[0].equals("invertYMouse")) {
                    this.invertMouse = as2[1].equals("true");
                }
                if (as2[0].equals("viewDistance")) {
                    this.renderDistance = Integer.parseInt(as2[1]);
                }
                if (as2[0].equals("bobView")) {
                    this.viewBobbing = as2[1].equals("true");
                }
                if (as2[0].equals("anaglyph3d")) {
                    this.anaglyph = as2[1].equals("true");
                }
                if (as2[0].equals("limitFramerate")) {
                    this.limitFramerate = as2[1].equals("true");
                }
                if (as2[0].equals("difficulty")) {
                    this.difficulty = Integer.parseInt(as2[1]);
                }
                if (as2[0].equals("fancyGraphics")) {
                    this.fancyGraphics = as2[1].equals("true");
                }
                if (as2[0].equals("fog")) {
                    this.fog = as2[1].equals("true");
                }
                int i2 = 0;
                while (i2 < this.keyBindings.length) {
                    if (as2[0].equals("key_" + this.keyBindings[i2].keyDescription)) {
                        this.keyBindings[i2].keyCode = Integer.parseInt(as2[1]);
                    }
                    ++i2;
                }
            }
            bufferedreader.close();
        }
        catch (Exception exception) {
            System.out.println("Failed to load options");
            exception.printStackTrace();
        }
    }

    private float func_1050_a(String s2) {
        if (s2.equals("true")) {
            return 1.0f;
        }
        if (s2.equals("false")) {
            return 0.0f;
        }
        return Float.parseFloat(s2);
    }

    public void func_1041_b() {
        try {
            PrintWriter printwriter = new PrintWriter(new FileWriter(this.optionsFile));
            printwriter.println("music:" + this.musicVolume);
            printwriter.println("sound:" + this.soundVolume);
            printwriter.println("invertYMouse:" + this.invertMouse);
            printwriter.println("mouseSensitivity:" + this.mouseSensitivity);
            printwriter.println("viewDistance:" + this.renderDistance);
            printwriter.println("bobView:" + this.viewBobbing);
            printwriter.println("anaglyph3d:" + this.anaglyph);
            printwriter.println("limitFramerate:" + this.limitFramerate);
            printwriter.println("difficulty:" + this.difficulty);
            printwriter.println("fancyGraphics:" + this.fancyGraphics);
            printwriter.println("fog:" + this.fog);
            int i2 = 0;
            while (i2 < this.keyBindings.length) {
                printwriter.println("key_" + this.keyBindings[i2].keyDescription + ":" + this.keyBindings[i2].keyCode);
                ++i2;
            }
            printwriter.close();
        }
        catch (Exception exception) {
            System.out.println("Failed to save options");
            exception.printStackTrace();
        }
    }
}

