/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class NBTTagCompound
extends NBTBase {
    private Map<String, NBTBase> tagMap = new HashMap<String, NBTBase>();

    @Override
    void func_735_a(DataOutput dataoutput) throws IOException {
        for (NBTBase nbtbase : this.tagMap.values()) {
            NBTBase.func_738_a(nbtbase, dataoutput);
        }
        dataoutput.writeByte(0);
    }

    @Override
    void func_736_a(DataInput datainput) throws IOException {
        NBTBase nbtbase;
        this.tagMap.clear();
        while ((nbtbase = NBTBase.func_734_b(datainput)).func_733_a() != 0) {
            this.tagMap.put(nbtbase.func_737_b(), nbtbase);
        }
    }

    @Override
    public byte func_733_a() {
        return 10;
    }

    public void func_762_a(String s2, NBTBase nbtbase) {
        this.tagMap.put(s2, nbtbase.func_732_a(s2));
    }

    public void setByte(String s2, byte byte0) {
        this.tagMap.put(s2, new NBTTagByte(byte0).func_732_a(s2));
    }

    public void func_749_a(String s2, short word0) {
        this.tagMap.put(s2, new NBTTagShort(word0).func_732_a(s2));
    }

    public void setInteger(String s2, int i2) {
        this.tagMap.put(s2, new NBTTagInt(i2).func_732_a(s2));
    }

    public void setLong(String s2, long l2) {
        this.tagMap.put(s2, new NBTTagLong(l2).func_732_a(s2));
    }

    public void setFloat(String s2, float f2) {
        this.tagMap.put(s2, new NBTTagFloat(f2).func_732_a(s2));
    }

    public void setDouble(String s2, double d2) {
        this.tagMap.put(s2, new NBTTagDouble(d2).func_732_a(s2));
    }

    public void setString(String s2, String s1) {
        this.tagMap.put(s2, new NBTTagString(s1).func_732_a(s2));
    }

    public void func_747_a(String s2, byte[] abyte0) {
        this.tagMap.put(s2, new NBTTagByteArray(abyte0).func_732_a(s2));
    }

    public void func_763_a(String s2, NBTTagCompound nbttagcompound) {
        this.tagMap.put(s2, nbttagcompound.func_732_a(s2));
    }

    public void setBool(String s2, boolean flag) {
        this.setByte(s2, (byte)(flag ? 1 : 0));
    }

    public boolean func_751_b(String s2) {
        return this.tagMap.containsKey(s2);
    }

    public byte func_746_c(String s2) {
        if (!this.tagMap.containsKey(s2)) {
            return 0;
        }
        return ((NBTTagByte)this.tagMap.get((Object)s2)).byteValue;
    }

    public short func_745_d(String s2) {
        if (!this.tagMap.containsKey(s2)) {
            return 0;
        }
        return ((NBTTagShort)this.tagMap.get((Object)s2)).shortValue;
    }

    public int func_756_e(String s2) {
        if (!this.tagMap.containsKey(s2)) {
            return 0;
        }
        return ((NBTTagInt)this.tagMap.get((Object)s2)).intValue;
    }

    public long func_764_f(String s2) {
        if (!this.tagMap.containsKey(s2)) {
            return 0L;
        }
        return ((NBTTagLong)this.tagMap.get((Object)s2)).longValue;
    }

    public float func_752_g(String s2) {
        if (!this.tagMap.containsKey(s2)) {
            return 0.0f;
        }
        return ((NBTTagFloat)this.tagMap.get((Object)s2)).floatValue;
    }

    public double func_757_h(String s2) {
        if (!this.tagMap.containsKey(s2)) {
            return 0.0;
        }
        return ((NBTTagDouble)this.tagMap.get((Object)s2)).doubleValue;
    }

    public String func_755_i(String s2) {
        if (!this.tagMap.containsKey(s2)) {
            return "";
        }
        return ((NBTTagString)this.tagMap.get((Object)s2)).stringValue;
    }

    public byte[] func_759_j(String s2) {
        if (!this.tagMap.containsKey(s2)) {
            return new byte[0];
        }
        return ((NBTTagByteArray)this.tagMap.get((Object)s2)).byteArray;
    }

    public NBTTagCompound func_743_k(String s2) {
        if (!this.tagMap.containsKey(s2)) {
            return new NBTTagCompound();
        }
        return (NBTTagCompound)this.tagMap.get(s2);
    }

    public NBTTagList func_753_l(String s2) {
        if (!this.tagMap.containsKey(s2)) {
            return new NBTTagList();
        }
        return (NBTTagList)this.tagMap.get(s2);
    }

    public boolean tag(String s2) {
        return this.func_746_c(s2) != 0;
    }

    public String toString() {
        return "" + this.tagMap.size() + " entries";
    }
}

