/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class ChunkLoader
implements IChunkLoader {
    private File basePath;

    public ChunkLoader(File file, boolean flag) {
        this.basePath = file;
    }

    private File getChunkFile(int i2, int j2) {
        String s2 = "c." + Integer.toString(i2, 36) + "." + Integer.toString(j2, 36) + ".dat";
        String s1 = Integer.toString(i2 & 0x3F, 36);
        String s22 = Integer.toString(j2 & 0x3F, 36);
        File file = new File(this.basePath, s1);
        file = new File(file, s22);
        file = new File(file, s2);
        return file;
    }

    public Chunk func_813_a(World world, int x2, int z2) throws IOException {
        NBTTagCompound nbt;
        DataInputStream regionChunkInputStream = RegionFileCache.getChunkDataInputStream(this.basePath, x2, z2);
        File chunkFile = this.getChunkFile(x2, z2);
        if (regionChunkInputStream != null) {
            nbt = CompressedStreamTools.func_1138_a(regionChunkInputStream);
        } else if (chunkFile.exists()) {
            try {
                FileInputStream inputStream = new FileInputStream(chunkFile);
                nbt = CompressedStreamTools.func_1138_a(inputStream);
            }
            catch (Exception e2) {
                e2.printStackTrace();
                return null;
            }
        } else {
            return null;
        }
        if (!nbt.func_751_b("Level")) {
            System.out.println("Chunk file at " + x2 + "," + z2 + " is missing level data, skipping");
            return null;
        }
        if (!nbt.func_743_k("Level").func_751_b("Blocks")) {
            System.out.println("Chunk file at " + x2 + "," + z2 + " is missing block data, skipping");
            return null;
        }
        Chunk var7 = ChunkLoader.func_816_a(world, nbt.func_743_k("Level"));
        if (!var7.func_1017_a(x2, z2)) {
            System.out.println("Chunk file at " + x2 + "," + z2 + " is in the wrong location; relocating. (Expected " + x2 + ", " + z2 + ", got " + var7.xPos + ", " + var7.zPos + ")");
            nbt.setInteger("xPos", x2);
            nbt.setInteger("zPos", z2);
            var7 = ChunkLoader.func_816_a(world, nbt.func_743_k("Level"));
        }
        try {
            if (regionChunkInputStream != null) {
                regionChunkInputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return var7;
    }

    public void func_812_a(World world, Chunk chunk) throws IOException {
        world.func_663_l();
        DataOutputStream output = RegionFileCache.getChunkDataOutputStream(this.basePath, chunk.xPos, chunk.zPos);
        NBTTagCompound var6 = new NBTTagCompound();
        NBTTagCompound var7 = new NBTTagCompound();
        var6.func_762_a("Level", var7);
        this.func_818_a(chunk, world, var7);
        CompressedStreamTools.func_1143_a(var6, output);
        try {
            output.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        world.sizeOnDisk += (long)RegionFileCache.getSizeDelta(this.basePath, chunk.xPos, chunk.zPos);
    }

    public void func_818_a(Chunk chunk, World world, NBTTagCompound nbttagcompound) {
        world.func_663_l();
        nbttagcompound.setInteger("xPos", chunk.xPos);
        nbttagcompound.setInteger("zPos", chunk.zPos);
        nbttagcompound.setLong("LastUpdate", world.worldTime);
        nbttagcompound.func_747_a("Blocks", chunk.blocks);
        nbttagcompound.func_747_a("Data", chunk.data.data);
        nbttagcompound.func_747_a("SkyLight", chunk.skylightMap.data);
        nbttagcompound.func_747_a("BlockLight", chunk.blocklightMap.data);
        nbttagcompound.func_747_a("HeightMap", chunk.heightMap);
        nbttagcompound.setBool("TerrainPopulated", chunk.isTerrainPopulated);
        chunk.field_1523_r = false;
        NBTTagList nbttaglist = new NBTTagList();
        int i2 = 0;
        while (i2 < chunk.field_1528_m.length) {
            for (Entity entity : chunk.field_1528_m[i2]) {
                chunk.field_1523_r = true;
                NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                if (!entity.func_358_c(nbttagcompound1)) continue;
                nbttaglist.func_742_a(nbttagcompound1);
            }
            ++i2;
        }
        nbttagcompound.func_762_a("Entities", nbttaglist);
        NBTTagList nbttaglist1 = new NBTTagList();
        for (TileEntity tileentity : chunk.field_1529_l.values()) {
            NBTTagCompound nbttagcompound2 = new NBTTagCompound();
            tileentity.func_481_b(nbttagcompound2);
            nbttaglist1.func_742_a(nbttagcompound2);
        }
        nbttagcompound.func_762_a("TileEntities", nbttaglist1);
    }

    public static Chunk func_816_a(World world, NBTTagCompound nbttagcompound) {
        NBTTagList nbttaglist1;
        NBTTagList nbttaglist;
        int i2 = nbttagcompound.func_756_e("xPos");
        int j2 = nbttagcompound.func_756_e("zPos");
        Chunk chunk = new Chunk(world, i2, j2);
        chunk.blocks = nbttagcompound.func_759_j("Blocks");
        chunk.data = new NibbleArray(nbttagcompound.func_759_j("Data"));
        chunk.skylightMap = new NibbleArray(nbttagcompound.func_759_j("SkyLight"));
        chunk.blocklightMap = new NibbleArray(nbttagcompound.func_759_j("BlockLight"));
        chunk.heightMap = nbttagcompound.func_759_j("HeightMap");
        chunk.isTerrainPopulated = nbttagcompound.tag("TerrainPopulated");
        if (!chunk.data.func_769_a()) {
            chunk.data = new NibbleArray(chunk.blocks.length);
        }
        if (chunk.heightMap == null || !chunk.skylightMap.func_769_a()) {
            chunk.heightMap = new byte[256];
            chunk.skylightMap = new NibbleArray(chunk.blocks.length);
            chunk.func_1024_c();
        }
        if (!chunk.blocklightMap.func_769_a()) {
            chunk.blocklightMap = new NibbleArray(chunk.blocks.length);
            chunk.func_1014_a();
        }
        if ((nbttaglist = nbttagcompound.func_753_l("Entities")) != null) {
            int k2 = 0;
            while (k2 < nbttaglist.func_740_c()) {
                NBTTagCompound nbttagcompound1 = (NBTTagCompound)nbttaglist.func_741_a(k2);
                Entity entity = EntityList.func_1081_a(nbttagcompound1, world);
                chunk.field_1523_r = true;
                if (entity != null) {
                    chunk.func_1000_a(entity);
                }
                ++k2;
            }
        }
        if ((nbttaglist1 = nbttagcompound.func_753_l("TileEntities")) != null) {
            int l2 = 0;
            while (l2 < nbttaglist1.func_740_c()) {
                NBTTagCompound nbttagcompound2 = (NBTTagCompound)nbttaglist1.func_741_a(l2);
                TileEntity tileentity = TileEntity.func_477_c(nbttagcompound2);
                if (tileentity != null) {
                    chunk.func_1001_a(tileentity);
                }
                ++l2;
            }
        }
        return chunk;
    }

    public void func_814_a() {
    }

    public void func_811_b() {
    }

    public void func_815_b(World world, Chunk chunk) {
    }
}

