/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import org.lwjgl.input.Keyboard;

public class GameSettings {
    private static final String[] RENDER_DISTANCES = new String[]{"FAR", "NORMAL", "SHORT", "TINY"};
    private static final String[] DIFFICULTY_LEVELS = new String[]{"Peaceful", "Easy", "Normal", "Hard"};
    public String lastServer;
    public float musicVolume = 1.0f;
    public float soundVolume = 1.0f;
    public float mouseSensitivity = 0.5f;
    public boolean invertMouse = false;
    public int renderDistance = 0;
    public boolean viewBobbing = true;
    public boolean anaglyph = false;
    public boolean limitFramerate = false;
    public boolean fancyGraphics = true;
    public KeyBinding keyBindForward;
    public KeyBinding keyBindLeft;
    public KeyBinding keyBindBack;
    public KeyBinding keyBindRight;
    public KeyBinding keyBindJump;
    public KeyBinding keyBindInventory;
    public KeyBinding keyBindDrop;
    public KeyBinding keyBindChat;
    public KeyBinding keyBindToggleFog;
    public KeyBinding keyBindSneak;
    public KeyBinding keyBindRun;
    public KeyBinding keyBindSaveLocation;
    public KeyBinding keyBindLoadLocation;
    public KeyBinding[] keyBindings;
    protected Minecraft mc;
    private File optionsFile;
    public int numberOfOptions;
    public int difficulty;
    public int BigTreePercentage;
    public boolean thirdPersonView;
    public boolean fog = true;
    public boolean clouds = true;
    public boolean fastRender = true;

    public GameSettings(Minecraft minecraft, File file) {
        this.lastServer = "";
        this.keyBindForward = new KeyBinding("Forward", 17);
        this.keyBindLeft = new KeyBinding("Left", 30);
        this.keyBindBack = new KeyBinding("Back", 31);
        this.keyBindRight = new KeyBinding("Right", 32);
        this.keyBindJump = new KeyBinding("Jump", 57);
        this.keyBindInventory = new KeyBinding("Inventory", 18);
        this.keyBindDrop = new KeyBinding("Drop", 16);
        this.keyBindChat = new KeyBinding("Chat", 20);
        this.keyBindToggleFog = new KeyBinding("Toggle fog", 33);
        this.keyBindSneak = new KeyBinding("Sneak", 42);
        this.keyBindRun = new KeyBinding("Run", 29);
        this.keyBindSaveLocation = new KeyBinding("Save Location", 28);
        this.keyBindLoadLocation = new KeyBinding("Load Location", 19);
        this.keyBindings = new KeyBinding[]{this.keyBindForward, this.keyBindLeft, this.keyBindBack, this.keyBindRight, this.keyBindJump, this.keyBindSneak, this.keyBindDrop, this.keyBindInventory, this.keyBindChat, this.keyBindToggleFog, this.keyBindRun, this.keyBindSaveLocation, this.keyBindLoadLocation};
        this.numberOfOptions = 10;
        this.difficulty = 2;
        this.thirdPersonView = false;
        this.mc = minecraft;
        this.optionsFile = new File(file, "optionsNSSS.txt");
        this.readOptions();
    }

    public GameSettings() {
        this.keyBindForward = new KeyBinding("Forward", 17);
        this.keyBindLeft = new KeyBinding("Left", 30);
        this.keyBindBack = new KeyBinding("Back", 31);
        this.keyBindRight = new KeyBinding("Right", 32);
        this.keyBindJump = new KeyBinding("Jump", 57);
        this.keyBindInventory = new KeyBinding("Inventory", 18);
        this.keyBindDrop = new KeyBinding("Drop", 16);
        this.keyBindChat = new KeyBinding("Chat", 20);
        this.keyBindToggleFog = new KeyBinding("Toggle fog", 33);
        this.keyBindSneak = new KeyBinding("Sneak", 42);
        this.keyBindRun = new KeyBinding("Run", 29);
        this.keyBindSaveLocation = new KeyBinding("Save Location", 28);
        this.keyBindLoadLocation = new KeyBinding("Load Location", 19);
        this.keyBindings = new KeyBinding[]{this.keyBindForward, this.keyBindLeft, this.keyBindBack, this.keyBindRight, this.keyBindJump, this.keyBindSneak, this.keyBindDrop, this.keyBindInventory, this.keyBindChat, this.keyBindToggleFog, this.keyBindRun, this.keyBindSaveLocation, this.keyBindLoadLocation};
        this.numberOfOptions = 10;
        this.difficulty = 2;
        this.thirdPersonView = false;
    }

    public String func_1043_a(int i2) {
        return this.keyBindings[i2].keyDescription + ": " + Keyboard.getKeyName((int)this.keyBindings[i2].keyCode);
    }

    public void func_1042_a(int i2, int j2) {
        this.keyBindings[i2].keyCode = j2;
        this.save();
    }

    public void func_1048_a(int i2, float f2) {
        if (i2 == 0) {
            this.musicVolume = f2;
            this.mc.field_158_A.func_335_a();
        }
        if (i2 == 1) {
            this.soundVolume = f2;
            this.mc.field_158_A.func_335_a();
        }
        if (i2 == 3) {
            this.mouseSensitivity = f2;
        }
    }

    public void func_1045_b(int i2, int j2) {
        if (i2 == 2) {
            boolean bl2 = this.invertMouse = !this.invertMouse;
        }
        if (i2 == 4) {
            this.renderDistance += j2;
            if (this.renderDistance > 3) {
                this.renderDistance = 0;
            } else if (this.renderDistance < 0) {
                this.renderDistance = 3;
            }
        }
        if (i2 == 5) {
            boolean bl3 = this.viewBobbing = !this.viewBobbing;
        }
        if (i2 == 6) {
            this.anaglyph = !this.anaglyph;
            this.mc.field_171_n.func_1065_b();
        }
        if (i2 == 7) {
            boolean bl4 = this.limitFramerate = !this.limitFramerate;
        }
        if (i2 == 8) {
            this.difficulty = this.difficulty + j2 & 3;
        }
        if (i2 == 9) {
            this.fancyGraphics = !this.fancyGraphics;
            this.mc.field_179_f.func_958_a();
        }
        if (i2 == 101) {
            boolean bl5 = this.clouds = !this.clouds;
        }
        if (i2 == 100) {
            this.fog = !this.fog;
        }
        this.save();
    }

    public int func_1046_b(int i2) {
        if (i2 == 0) {
            return 1;
        }
        if (i2 == 1) {
            return 1;
        }
        return i2 != 3 ? 0 : 1;
    }

    public float sliderType(int i2) {
        if (i2 == 0) {
            return this.musicVolume;
        }
        if (i2 == 1) {
            return this.soundVolume;
        }
        if (i2 == 3) {
            return this.mouseSensitivity;
        }
        if (i2 == 5) {
            return this.BigTreePercentage;
        }
        return 0.0f;
    }

    public String getOptionValue(int i2) {
        if (i2 == 0) {
            return "Music: " + (this.musicVolume <= 0.0f ? "OFF" : (int)(this.musicVolume * 100.0f) + "%");
        }
        if (i2 == 1) {
            return "Sound: " + (this.soundVolume <= 0.0f ? "OFF" : (int)(this.soundVolume * 100.0f) + "%");
        }
        if (i2 == 2) {
            return "Invert mouse: " + (this.invertMouse ? "ON" : "OFF");
        }
        if (i2 == 3) {
            if (this.mouseSensitivity == 0.0f) {
                return "Sensitivity: *yawn*";
            }
            if (this.mouseSensitivity == 1.0f) {
                return "Sensitivity: HYPERSPEED!!!";
            }
            return "Sensitivity: " + (int)(this.mouseSensitivity * 200.0f) + "%";
        }
        if (i2 == 4) {
            if (this.renderDistance >= 0 && this.renderDistance <= 4) {
                return "Render distance: " + RENDER_DISTANCES[this.renderDistance];
            }
            this.renderDistance = 1;
            return "Render distance: " + RENDER_DISTANCES[this.renderDistance];
        }
        if (i2 == 5) {
            return "View bobbing: " + (this.viewBobbing ? "ON" : "OFF");
        }
        if (i2 == 6) {
            return "3d anaglyph: " + (this.anaglyph ? "ON" : "OFF");
        }
        if (i2 == 7) {
            return "Limit framerate: " + (this.limitFramerate ? "ON" : "OFF");
        }
        if (i2 == 8) {
            return "Difficulty: " + DIFFICULTY_LEVELS[this.difficulty];
        }
        if (i2 == 10) {
            return "BigTree Percentage: " + this.BigTreePercentage;
        }
        if (i2 == 100) {
            return "Fog: " + (this.fog ? "ON" : "OFF");
        }
        if (i2 == 101) {
            return "Clouds: " + (this.clouds ? "ON" : "OFF");
        }
        if (i2 == 102) {
            return "FastRender: " + (this.fastRender ? "ON" : "OFF");
        }
        if (i2 == 9) {
            return "Graphics: " + (this.fancyGraphics ? "FANCY" : "FAST");
        }
        return "";
    }

    public void readOptions() {
        try {
            if (!this.optionsFile.exists()) {
                return;
            }
            BufferedReader bufferedreader = new BufferedReader(new FileReader(this.optionsFile));
            String s2 = "";
            while ((s2 = bufferedreader.readLine()) != null) {
                String[] as2 = s2.split(":");
                if (as2[0].equals("music")) {
                    this.musicVolume = this.func_1050_a(as2[1]);
                }
                if (as2[0].equals("sound")) {
                    this.soundVolume = this.func_1050_a(as2[1]);
                }
                if (as2[0].equals("mouseSensitivity")) {
                    this.mouseSensitivity = this.func_1050_a(as2[1]);
                }
                if (as2[0].equals("invertYMouse")) {
                    this.invertMouse = as2[1].equals("true");
                }
                if (as2[0].equals("viewDistance")) {
                    this.renderDistance = Integer.parseInt(as2[1]);
                }
                if (as2[0].equals("bobView")) {
                    this.viewBobbing = as2[1].equals("true");
                }
                if (as2[0].equals("anaglyph3d")) {
                    this.anaglyph = as2[1].equals("true");
                }
                if (as2[0].equals("limitFramerate")) {
                    this.limitFramerate = as2[1].equals("true");
                }
                if (as2[0].equals("difficulty")) {
                    this.difficulty = Integer.parseInt(as2[1]);
                }
                if (as2[0].equals("fancyGraphics")) {
                    this.fancyGraphics = as2[1].equals("true");
                }
                if (as2[0].equals("lastServer") && as2.length > 1) {
                    this.lastServer = as2[1];
                }
                if (as2[0].equals("fog")) {
                    this.fog = as2[1].equals("true");
                }
                if (as2[0].equals("Clouds")) {
                    this.clouds = as2[1].equals("true");
                }
                if (as2[0].equals("fastRender")) {
                    this.fastRender = as2[1].equals("true");
                }
                int i2 = 0;
                while (i2 < this.keyBindings.length) {
                    if (as2[0].equals("key_" + this.keyBindings[i2].keyDescription)) {
                        this.keyBindings[i2].keyCode = Integer.parseInt(as2[1]);
                    }
                    ++i2;
                }
            }
            bufferedreader.close();
        }
        catch (Exception exception) {
            System.out.println("Failed to load options");
            exception.printStackTrace();
        }
    }

    private float func_1050_a(String s2) {
        if (s2.equals("true")) {
            return 1.0f;
        }
        if (s2.equals("false")) {
            return 0.0f;
        }
        return Float.parseFloat(s2);
    }

    public void save() {
        try {
            PrintWriter printwriter = new PrintWriter(new FileWriter(this.optionsFile));
            printwriter.println("music:" + this.musicVolume);
            printwriter.println("sound:" + this.soundVolume);
            printwriter.println("invertYMouse:" + this.invertMouse);
            printwriter.println("mouseSensitivity:" + this.mouseSensitivity);
            printwriter.println("viewDistance:" + this.renderDistance);
            printwriter.println("bobView:" + this.viewBobbing);
            printwriter.println("anaglyph3d:" + this.anaglyph);
            printwriter.println("limitFramerate:" + this.limitFramerate);
            printwriter.println("difficulty:" + this.difficulty);
            printwriter.println("fancyGraphics:" + this.fancyGraphics);
            printwriter.println(new StringBuilder().append("lastServer:").append(this.lastServer));
            printwriter.println("fog:" + this.fog);
            printwriter.println("Clouds:" + this.clouds);
            printwriter.println("fastRender:" + this.fastRender);
            int i2 = 0;
            while (i2 < this.keyBindings.length) {
                printwriter.println("key_" + this.keyBindings[i2].keyDescription + ":" + this.keyBindings[i2].keyCode);
                ++i2;
            }
            printwriter.close();
        }
        catch (Exception exception) {
            System.out.println("Failed to save options");
            exception.printStackTrace();
        }
    }
}

