/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.util.Iterator;
import org.json.HTTPTokener;
import org.json.JSONException;
import org.json.JSONObject;

public class HTTP {
    public static final String CRLF = "\r\n";

    public static JSONObject toJSONObject(String string) throws JSONException {
        JSONObject jo2 = new JSONObject();
        HTTPTokener x2 = new HTTPTokener(string);
        String token = x2.nextToken();
        if (token.toUpperCase().startsWith("HTTP")) {
            jo2.put("HTTP-Version", (Object)token);
            jo2.put("Status-Code", (Object)x2.nextToken());
            jo2.put("Reason-Phrase", (Object)x2.nextTo('\u0000'));
            x2.next();
        } else {
            jo2.put("Method", (Object)token);
            jo2.put("Request-URI", (Object)x2.nextToken());
            jo2.put("HTTP-Version", (Object)x2.nextToken());
        }
        while (x2.more()) {
            String name = x2.nextTo(':');
            x2.next(':');
            jo2.put(name, (Object)x2.nextTo('\u0000'));
            x2.next();
        }
        return jo2;
    }

    public static String toString(JSONObject jo2) throws JSONException {
        Iterator keys = jo2.keys();
        StringBuffer sb = new StringBuffer();
        if (jo2.has("Status-Code") && jo2.has("Reason-Phrase")) {
            sb.append(jo2.getString("HTTP-Version"));
            sb.append(' ');
            sb.append(jo2.getString("Status-Code"));
            sb.append(' ');
            sb.append(jo2.getString("Reason-Phrase"));
        } else if (jo2.has("Method") && jo2.has("Request-URI")) {
            sb.append(jo2.getString("Method"));
            sb.append(' ');
            sb.append('\"');
            sb.append(jo2.getString("Request-URI"));
            sb.append('\"');
            sb.append(' ');
            sb.append(jo2.getString("HTTP-Version"));
        } else {
            throw new JSONException("Not enough material for an HTTP header.");
        }
        sb.append(CRLF);
        while (keys.hasNext()) {
            String string = keys.next().toString();
            if ("HTTP-Version".equals(string) || "Status-Code".equals(string) || "Reason-Phrase".equals(string) || "Method".equals(string) || "Request-URI".equals(string) || jo2.isNull(string)) continue;
            sb.append(string);
            sb.append(": ");
            sb.append(jo2.getString(string));
            sb.append(CRLF);
        }
        sb.append(CRLF);
        return sb.toString();
    }
}

