/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONString;
import org.json.JSONTokener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class JSONObject {
    private final Map<String, Object> map = new HashMap();
    public static final Object NULL = new Null();

    public JSONObject() {
    }

    public JSONObject(JSONObject jo2, String[] names) {
        this();
        int i2 = 0;
        while (i2 < names.length) {
            try {
                this.putOnce(names[i2], jo2.opt(names[i2]));
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i2;
        }
    }

    public JSONObject(JSONTokener x2) throws JSONException {
        this();
        if (x2.nextClean() != '{') {
            throw x2.syntaxError("A JSONObject text must begin with '{'");
        }
        block8: while (true) {
            char c2 = x2.nextClean();
            switch (c2) {
                case '\u0000': {
                    throw x2.syntaxError("A JSONObject text must end with '}'");
                }
                case '}': {
                    return;
                }
            }
            x2.back();
            String key = x2.nextValue().toString();
            c2 = x2.nextClean();
            if (c2 != ':') {
                throw x2.syntaxError("Expected a ':' after a key");
            }
            this.putOnce(key, x2.nextValue());
            switch (x2.nextClean()) {
                case ',': 
                case ';': {
                    if (x2.nextClean() == '}') {
                        return;
                    }
                    x2.back();
                    continue block8;
                }
                case '}': {
                    return;
                }
            }
            break;
        }
        throw x2.syntaxError("Expected a ',' or '}'");
    }

    public JSONObject(Map<?, ?> map) {
        if (map != null) {
            for (Map.Entry<?, ?> e2 : map.entrySet()) {
                Object value = e2.getValue();
                if (value == null) continue;
                this.map.put((String)e2.getKey(), JSONObject.wrap(value));
            }
        }
    }

    public JSONObject(Object bean) {
        this();
        this.populateMap(bean);
    }

    public JSONObject(Object object, String[] names) {
        this();
        Class<?> c2 = object.getClass();
        int i2 = 0;
        while (i2 < names.length) {
            String name = names[i2];
            try {
                this.putOpt(name, c2.getField(name).get(object));
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i2;
        }
    }

    public JSONObject(String source) throws JSONException {
        this(new JSONTokener(source));
    }

    public JSONObject(String baseName, Locale locale) throws JSONException {
        this();
        ResourceBundle bundle = ResourceBundle.getBundle(baseName, locale, Thread.currentThread().getContextClassLoader());
        Enumeration<String> keys = bundle.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (!(key instanceof String)) continue;
            String[] path = key.split("\\.");
            int last = path.length - 1;
            JSONObject target = this;
            int i2 = 0;
            while (i2 < last) {
                String segment = path[i2];
                JSONObject nextTarget = target.optJSONObject(segment);
                if (nextTarget == null) {
                    nextTarget = new JSONObject();
                    target.put(segment, (Object)nextTarget);
                }
                target = nextTarget;
                ++i2;
            }
            target.put(path[last], (Object)bundle.getString(key));
        }
    }

    public JSONObject accumulate(String key, Object value) throws JSONException {
        JSONObject.testValidity((Object)value);
        Object object = this.opt(key);
        if (object == null) {
            this.put(key, value instanceof JSONArray ? new JSONArray().put(value) : value);
        } else if (object instanceof JSONArray) {
            ((JSONArray)object).put(value);
        } else {
            this.put(key, (Object)new JSONArray().put(object).put(value));
        }
        return this;
    }

    public JSONObject append(String key, Object value) throws JSONException {
        JSONObject.testValidity((Object)value);
        Object object = this.opt(key);
        if (object == null) {
            this.put(key, (Object)new JSONArray().put(value));
        } else if (object instanceof JSONArray) {
            this.put(key, (Object)((JSONArray)object).put(value));
        } else {
            throw new JSONException("JSONObject[" + key + "] is not a JSONArray.");
        }
        return this;
    }

    public static String doubleToString(double d2) {
        if (Double.isInfinite(d2) || Double.isNaN(d2)) {
            return "null";
        }
        String string = Double.toString(d2);
        if (string.indexOf(46) > 0 && string.indexOf(101) < 0 && string.indexOf(69) < 0) {
            while (string.endsWith("0")) {
                string = string.substring(0, string.length() - 1);
            }
            if (string.endsWith(".")) {
                string = string.substring(0, string.length() - 1);
            }
        }
        return string;
    }

    public Object get(String key) throws JSONException {
        if (key == null) {
            throw new JSONException("Null key.");
        }
        Object object = this.opt(key);
        if (object == null) {
            throw new JSONException("JSONObject[" + JSONObject.quote((String)key) + "] not found.");
        }
        return object;
    }

    public boolean getBoolean(String key) throws JSONException {
        Object object = this.get(key);
        if (object.equals(Boolean.FALSE) || object instanceof String && ((String)object).equalsIgnoreCase("false")) {
            return false;
        }
        if (object.equals(Boolean.TRUE) || object instanceof String && ((String)object).equalsIgnoreCase("true")) {
            return true;
        }
        throw new JSONException("JSONObject[" + JSONObject.quote((String)key) + "] is not a Boolean.");
    }

    public double getDouble(String key) throws JSONException {
        Object object = this.get(key);
        try {
            return object instanceof Number ? ((Number)object).doubleValue() : Double.parseDouble((String)object);
        }
        catch (Exception e2) {
            throw new JSONException("JSONObject[" + JSONObject.quote((String)key) + "] is not a number.");
        }
    }

    public int getInt(String key) throws JSONException {
        Object object = this.get(key);
        try {
            return object instanceof Number ? ((Number)object).intValue() : Integer.parseInt((String)object);
        }
        catch (Exception e2) {
            throw new JSONException("JSONObject[" + JSONObject.quote((String)key) + "] is not an int.");
        }
    }

    public JSONArray getJSONArray(String key) throws JSONException {
        Object object = this.get(key);
        if (object instanceof JSONArray) {
            return (JSONArray)object;
        }
        throw new JSONException("JSONObject[" + JSONObject.quote((String)key) + "] is not a JSONArray.");
    }

    public JSONObject getJSONObject(String key) throws JSONException {
        Object object = this.get(key);
        if (object instanceof JSONObject) {
            return (JSONObject)object;
        }
        throw new JSONException("JSONObject[" + JSONObject.quote((String)key) + "] is not a JSONObject.");
    }

    public long getLong(String key) throws JSONException {
        Object object = this.get(key);
        try {
            return object instanceof Number ? ((Number)object).longValue() : Long.parseLong((String)object);
        }
        catch (Exception e2) {
            throw new JSONException("JSONObject[" + JSONObject.quote((String)key) + "] is not a long.");
        }
    }

    public static String[] getNames(JSONObject jo2) {
        int length = jo2.length();
        if (length == 0) {
            return null;
        }
        Iterator iterator = jo2.keys();
        String[] names = new String[length];
        int i2 = 0;
        while (iterator.hasNext()) {
            names[i2] = (String)iterator.next();
            ++i2;
        }
        return names;
    }

    public static String[] getNames(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> klass = object.getClass();
        Field[] fields = klass.getFields();
        int length = fields.length;
        if (length == 0) {
            return null;
        }
        String[] names = new String[length];
        int i2 = 0;
        while (i2 < length) {
            names[i2] = fields[i2].getName();
            ++i2;
        }
        return names;
    }

    public String getString(String key) throws JSONException {
        Object object = this.get(key);
        if (object instanceof String) {
            return (String)object;
        }
        throw new JSONException("JSONObject[" + JSONObject.quote((String)key) + "] not a string.");
    }

    public boolean has(String key) {
        return this.map.containsKey(key);
    }

    public JSONObject increment(String key) throws JSONException {
        Object value = this.opt(key);
        if (value == null) {
            this.put(key, 1);
        } else if (value instanceof Integer) {
            this.put(key, (Integer)value + 1);
        } else if (value instanceof Long) {
            this.put(key, (Long)value + 1L);
        } else if (value instanceof Double) {
            this.put(key, (Double)value + 1.0);
        } else if (value instanceof Float) {
            this.put(key, (double)(((Float)value).floatValue() + 1.0f));
        } else {
            throw new JSONException("Unable to increment [" + JSONObject.quote((String)key) + "].");
        }
        return this;
    }

    public boolean isNull(String key) {
        return NULL.equals(this.opt(key));
    }

    public Iterator<String> keys() {
        return this.keySet().iterator();
    }

    public Set<String> keySet() {
        return this.map.keySet();
    }

    public int length() {
        return this.map.size();
    }

    public JSONArray names() {
        JSONArray ja2 = new JSONArray();
        Iterator keys = this.keys();
        while (keys.hasNext()) {
            ja2.put(keys.next());
        }
        return ja2.length() == 0 ? null : ja2;
    }

    public static String numberToString(Number number) throws JSONException {
        if (number == null) {
            throw new JSONException("Null pointer");
        }
        JSONObject.testValidity((Object)number);
        String string = number.toString();
        if (string.indexOf(46) > 0 && string.indexOf(101) < 0 && string.indexOf(69) < 0) {
            while (string.endsWith("0")) {
                string = string.substring(0, string.length() - 1);
            }
            if (string.endsWith(".")) {
                string = string.substring(0, string.length() - 1);
            }
        }
        return string;
    }

    public Object opt(String key) {
        return key == null ? null : this.map.get(key);
    }

    public boolean optBoolean(String key) {
        return this.optBoolean(key, false);
    }

    public boolean optBoolean(String key, boolean defaultValue) {
        try {
            return this.getBoolean(key);
        }
        catch (Exception e2) {
            return defaultValue;
        }
    }

    public double optDouble(String key) {
        return this.optDouble(key, Double.NaN);
    }

    public double optDouble(String key, double defaultValue) {
        try {
            return this.getDouble(key);
        }
        catch (Exception e2) {
            return defaultValue;
        }
    }

    public int optInt(String key) {
        return this.optInt(key, 0);
    }

    public int optInt(String key, int defaultValue) {
        try {
            return this.getInt(key);
        }
        catch (Exception e2) {
            return defaultValue;
        }
    }

    public JSONArray optJSONArray(String key) {
        Object o2 = this.opt(key);
        return o2 instanceof JSONArray ? (JSONArray)o2 : null;
    }

    public JSONObject optJSONObject(String key) {
        Object object = this.opt(key);
        return object instanceof JSONObject ? (JSONObject)object : null;
    }

    public long optLong(String key) {
        return this.optLong(key, 0L);
    }

    public long optLong(String key, long defaultValue) {
        try {
            return this.getLong(key);
        }
        catch (Exception e2) {
            return defaultValue;
        }
    }

    public String optString(String key) {
        return this.optString(key, "");
    }

    public String optString(String key, String defaultValue) {
        Object object = this.opt(key);
        return NULL.equals(object) ? defaultValue : object.toString();
    }

    private void populateMap(Object bean) {
        Class<?> klass = bean.getClass();
        boolean includeSuperClass = klass.getClassLoader() != null;
        Method[] methods = includeSuperClass ? klass.getMethods() : klass.getDeclaredMethods();
        int i2 = 0;
        while (i2 < methods.length) {
            try {
                Method method = methods[i2];
                if (Modifier.isPublic(method.getModifiers())) {
                    String name = method.getName();
                    String key = "";
                    if (name.startsWith("get")) {
                        key = "getClass".equals(name) || "getDeclaringClass".equals(name) ? "" : name.substring(3);
                    } else if (name.startsWith("is")) {
                        key = name.substring(2);
                    }
                    if (key.length() > 0 && Character.isUpperCase(key.charAt(0)) && method.getParameterTypes().length == 0) {
                        if (key.length() == 1) {
                            key = key.toLowerCase();
                        } else if (!Character.isUpperCase(key.charAt(1))) {
                            key = String.valueOf(key.substring(0, 1).toLowerCase()) + key.substring(1);
                        }
                        Object result = method.invoke(bean, null);
                        if (result != null) {
                            this.map.put(key, JSONObject.wrap((Object)result));
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i2;
        }
    }

    public JSONObject put(String key, boolean value) throws JSONException {
        this.put(key, (Object)(value ? Boolean.TRUE : Boolean.FALSE));
        return this;
    }

    public JSONObject put(String key, Collection<?> value) throws JSONException {
        this.put(key, (Object)new JSONArray(value));
        return this;
    }

    public JSONObject put(String key, double value) throws JSONException {
        this.put(key, (Object)new Double(value));
        return this;
    }

    public JSONObject put(String key, int value) throws JSONException {
        this.put(key, (Object)new Integer(value));
        return this;
    }

    public JSONObject put(String key, long value) throws JSONException {
        this.put(key, (Object)new Long(value));
        return this;
    }

    public JSONObject put(String key, Map<?, ?> value) throws JSONException {
        this.put(key, (Object)new JSONObject(value));
        return this;
    }

    public JSONObject put(String key, Object value) throws JSONException {
        if (key == null) {
            throw new NullPointerException("Null key.");
        }
        if (value != null) {
            JSONObject.testValidity((Object)value);
            this.map.put(key, value);
        } else {
            this.remove(key);
        }
        return this;
    }

    public JSONObject putOnce(String key, Object value) throws JSONException {
        if (key != null && value != null) {
            if (this.opt(key) != null) {
                throw new JSONException("Duplicate key \"" + key + "\"");
            }
            this.put(key, value);
        }
        return this;
    }

    public JSONObject putOpt(String key, Object value) throws JSONException {
        if (key != null && value != null) {
            this.put(key, value);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String quote(String string) {
        StringWriter sw = new StringWriter();
        StringBuffer stringBuffer = sw.getBuffer();
        synchronized (stringBuffer) {
            try {
                return JSONObject.quote((String)string, (Writer)sw).toString();
            }
            catch (IOException ignored) {
                return "";
            }
        }
    }

    public static Writer quote(String string, Writer w2) throws IOException {
        if (string == null || string.length() == 0) {
            w2.write("\"\"");
            return w2;
        }
        char c2 = '\u0000';
        int len = string.length();
        w2.write(34);
        int i2 = 0;
        while (i2 < len) {
            char b2 = c2;
            c2 = string.charAt(i2);
            switch (c2) {
                case '\"': 
                case '\\': {
                    w2.write(92);
                    w2.write(c2);
                    break;
                }
                case '/': {
                    if (b2 == '<') {
                        w2.write(92);
                    }
                    w2.write(c2);
                    break;
                }
                case '\b': {
                    w2.write("\\b");
                    break;
                }
                case '\t': {
                    w2.write("\\t");
                    break;
                }
                case '\n': {
                    w2.write("\\n");
                    break;
                }
                case '\f': {
                    w2.write("\\f");
                    break;
                }
                case '\r': {
                    w2.write("\\r");
                    break;
                }
                default: {
                    if (c2 < ' ' || c2 >= '\u0080' && c2 < '\u00a0' || c2 >= '\u2000' && c2 < '\u2100') {
                        w2.write("\\u");
                        String hhhh = Integer.toHexString(c2);
                        w2.write("0000", 0, 4 - hhhh.length());
                        w2.write(hhhh);
                        break;
                    }
                    w2.write(c2);
                }
            }
            ++i2;
        }
        w2.write(34);
        return w2;
    }

    public Object remove(String key) {
        return this.map.remove(key);
    }

    public static Object stringToValue(String string) {
        if (string.equals("")) {
            return string;
        }
        if (string.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (string.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        if (string.equalsIgnoreCase("null")) {
            return NULL;
        }
        char b2 = string.charAt(0);
        if (b2 >= '0' && b2 <= '9' || b2 == '-') {
            try {
                if (string.indexOf(46) > -1 || string.indexOf(101) > -1 || string.indexOf(69) > -1) {
                    Double d2 = Double.valueOf(string);
                    if (!d2.isInfinite() && !d2.isNaN()) {
                        return d2;
                    }
                } else {
                    Long myLong = new Long(string);
                    if (string.equals(myLong.toString())) {
                        if (myLong == (long)myLong.intValue()) {
                            return new Integer(myLong.intValue());
                        }
                        return myLong;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    public static void testValidity(Object o2) throws JSONException {
        if (o2 != null && (o2 instanceof Double ? ((Double)o2).isInfinite() || ((Double)o2).isNaN() : o2 instanceof Float && (((Float)o2).isInfinite() || ((Float)o2).isNaN()))) {
            throw new JSONException("JSON does not allow non-finite numbers.");
        }
    }

    public JSONArray toJSONArray(JSONArray names) throws JSONException {
        if (names == null || names.length() == 0) {
            return null;
        }
        JSONArray ja2 = new JSONArray();
        int i2 = 0;
        while (i2 < names.length()) {
            ja2.put(this.opt(names.getString(i2)));
            ++i2;
        }
        return ja2;
    }

    public String toString() {
        try {
            return this.toString(0);
        }
        catch (Exception e2) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString(int indentFactor) throws JSONException {
        StringWriter w2 = new StringWriter();
        StringBuffer stringBuffer = w2.getBuffer();
        synchronized (stringBuffer) {
            return this.write((Writer)w2, indentFactor, 0).toString();
        }
    }

    public static String valueToString(Object value) throws JSONException {
        if (value == null || value.equals(null)) {
            return "null";
        }
        if (value instanceof JSONString) {
            String object;
            try {
                object = ((JSONString)value).toJSONString();
            }
            catch (Exception e2) {
                throw new JSONException(e2);
            }
            if (object instanceof String) {
                return object;
            }
            throw new JSONException("Bad value from toJSONString: " + object);
        }
        if (value instanceof Number) {
            return JSONObject.numberToString((Number)((Number)value));
        }
        if (value instanceof Boolean || value instanceof JSONObject || value instanceof JSONArray) {
            return value.toString();
        }
        if (value instanceof Map) {
            return new JSONObject((Map)value).toString();
        }
        if (value instanceof Collection) {
            return new JSONArray((Collection)value).toString();
        }
        if (value.getClass().isArray()) {
            return new JSONArray(value).toString();
        }
        return JSONObject.quote((String)value.toString());
    }

    public static Object wrap(Object object) {
        try {
            String objectPackageName;
            if (object == null) {
                return NULL;
            }
            if (object instanceof JSONObject || object instanceof JSONArray || NULL.equals(object) || object instanceof JSONString || object instanceof Byte || object instanceof Character || object instanceof Short || object instanceof Integer || object instanceof Long || object instanceof Boolean || object instanceof Float || object instanceof Double || object instanceof String) {
                return object;
            }
            if (object instanceof Collection) {
                return new JSONArray((Collection)object);
            }
            if (object.getClass().isArray()) {
                return new JSONArray(object);
            }
            if (object instanceof Map) {
                return new JSONObject((Map)object);
            }
            Package objectPackage = object.getClass().getPackage();
            String string = objectPackageName = objectPackage != null ? objectPackage.getName() : "";
            if (objectPackageName.startsWith("java.") || objectPackageName.startsWith("javax.") || object.getClass().getClassLoader() == null) {
                return object.toString();
            }
            return new JSONObject(object);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Writer write(Writer writer) throws JSONException {
        return this.write(writer, 0, 0);
    }

    static final Writer writeValue(Writer writer, Object value, int indentFactor, int indent) throws JSONException, IOException {
        if (value == null || value.equals(null)) {
            writer.write("null");
        } else if (value instanceof JSONObject) {
            ((JSONObject)value).write(writer, indentFactor, indent);
        } else if (value instanceof JSONArray) {
            ((JSONArray)value).write(writer, indentFactor, indent);
        } else if (value instanceof Map) {
            new JSONObject((Map)value).write(writer, indentFactor, indent);
        } else if (value instanceof Collection) {
            new JSONArray((Collection)value).write(writer, indentFactor, indent);
        } else if (value.getClass().isArray()) {
            new JSONArray(value).write(writer, indentFactor, indent);
        } else if (value instanceof Number) {
            writer.write(JSONObject.numberToString((Number)((Number)value)));
        } else if (value instanceof Boolean) {
            writer.write(value.toString());
        } else if (value instanceof JSONString) {
            String o2;
            try {
                o2 = ((JSONString)value).toJSONString();
            }
            catch (Exception e2) {
                throw new JSONException(e2);
            }
            writer.write(o2 != null ? o2.toString() : JSONObject.quote((String)value.toString()));
        } else {
            JSONObject.quote((String)value.toString(), (Writer)writer);
        }
        return writer;
    }

    static final void indent(Writer writer, int indent) throws IOException {
        int i2 = 0;
        while (i2 < indent) {
            writer.write(32);
            ++i2;
        }
    }

    Writer write(Writer writer, int indentFactor, int indent) throws JSONException {
        try {
            boolean commanate = false;
            int length = this.length();
            Iterator keys = this.keys();
            writer.write(123);
            if (length == 1) {
                Object key = keys.next();
                writer.write(JSONObject.quote((String)key.toString()));
                writer.write(58);
                if (indentFactor > 0) {
                    writer.write(32);
                }
                JSONObject.writeValue((Writer)writer, this.map.get(key), (int)indentFactor, (int)indent);
            } else if (length != 0) {
                int newindent = indent + indentFactor;
                while (keys.hasNext()) {
                    Object key = keys.next();
                    if (commanate) {
                        writer.write(44);
                    }
                    if (indentFactor > 0) {
                        writer.write(10);
                    }
                    JSONObject.indent((Writer)writer, (int)newindent);
                    writer.write(JSONObject.quote((String)key.toString()));
                    writer.write(58);
                    if (indentFactor > 0) {
                        writer.write(32);
                    }
                    JSONObject.writeValue((Writer)writer, this.map.get(key), (int)indentFactor, (int)newindent);
                    commanate = true;
                }
                if (indentFactor > 0) {
                    writer.write(10);
                }
                JSONObject.indent((Writer)writer, (int)indent);
            }
            writer.write(125);
            return writer;
        }
        catch (IOException exception) {
            throw new JSONException(exception);
        }
    }

    private static final class Null {
        private Null() {
        }

        protected final Object clone() {
            return this;
        }

        public boolean equals(Object object) {
            return object == null || object == this;
        }

        public String toString() {
            return "null";
        }
    }
}

