/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity;

import com.mojang.minecraft.entity.EntityItem;
import com.mojang.minecraft.entity.EntityList;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.BlockFluids;
import com.mojang.minecraft.level.tile.StepSound;
import com.mojang.minecraft.level.tile.material.Material;
import com.mojang.minecraft.level.tile.phys.AxisAlignedBB;
import com.mojang.minecraft.nbt.NBTTagCompound;
import com.mojang.minecraft.nbt.NBTTagDouble;
import com.mojang.minecraft.nbt.NBTTagFloat;
import com.mojang.minecraft.nbt.NBTTagList;
import com.mojang.minecraft.render.Vec3D;
import com.mojang.minecraft.util.MathHelper;
import java.util.List;
import java.util.Random;

public abstract class Entity {
    private static int field_655_a = 0;
    public int entityId;
    public double field_619_ac = 1.0;
    public boolean field_618_ad = false;
    public Entity field_617_ae;
    public Entity field_616_af;
    public World worldObj;
    public double field_614_ah;
    public double field_613_ai;
    public double field_612_aj;
    public double posX;
    public double posY;
    public double posZ;
    public double motionX;
    public double motionY;
    public double motionZ;
    public float rotationYaw;
    public float rotationPitch;
    public float headYaw;
    public float headPitch;
    public final AxisAlignedBB boundingBox = AxisAlignedBB.func_1168_a(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public boolean onGround = false;
    public boolean field_599_aw;
    public boolean field_598_ax;
    public boolean field_597_ay = false;
    public boolean field_596_az = true;
    public boolean hasDied = false;
    public float eyeHeight = 0.0f;
    public float width = 0.6f;
    public float height = 1.8f;
    public float field_642_aE = 0.0f;
    public float field_641_aF = 0.0f;
    protected boolean field_640_aG = true;
    protected float fallDistance = 0.0f;
    private int field_653_b = 1;
    public double field_638_aI;
    public double field_637_aJ;
    public double field_636_aK;
    public float headSneakHeight = 0.0f;
    public float field_634_aM = 0.0f;
    public boolean field_633_aN = false;
    public float field_632_aO = 0.0f;
    public boolean field_631_aP = false;
    protected Random rand;
    public int field_629_aR = 0;
    public int field_628_aS = 1;
    public int fire = 0;
    protected int field_626_aU = 300;
    protected boolean hasSplashed = false;
    public int field_624_aW = 0;
    public int air = 300;
    private boolean field_651_c = true;
    public String field_622_aY;
    private double field_649_d;
    private double field_647_e;
    public boolean field_621_aZ = false;
    public int field_657_ba;
    public int field_656_bb;
    public int field_654_bc;
    public int field_652_bd;
    public int field_650_be;
    public int field_648_bf;

    public Entity(World world) {
        this.entityId = field_655_a++;
        this.rand = new Random();
        this.worldObj = world;
        this.func_347_a(0.0, 0.0, 0.0);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Entity) {
            return ((Entity)obj).entityId == this.entityId;
        }
        return false;
    }

    public int hashCode() {
        return this.entityId;
    }

    protected void func_374_q() {
        if (this.worldObj == null) {
            return;
        }
        while (!(this.posY <= 0.0)) {
            this.func_347_a(this.posX, this.posY, this.posZ);
            if (this.worldObj.func_697_a(this, this.boundingBox).size() == 0) break;
            this.posY += 1.0;
        }
        this.motionZ = 0.0;
        this.motionY = 0.0;
        this.motionX = 0.0;
        this.rotationPitch = 0.0f;
    }

    public void func_395_F() {
        this.hasDied = true;
    }

    protected void setBounds(float f, float f1) {
        this.width = f;
        this.height = f1;
    }

    protected void func_376_c(float f, float f1) {
        this.rotationYaw = f;
        this.rotationPitch = f1;
    }

    public void func_347_a(double d, double d1, double d2) {
        this.posX = d;
        this.posY = d1;
        this.posZ = d2;
        float f = this.width / 2.0f;
        float f1 = this.height;
        this.boundingBox.func_1165_c(d - (double)f, d1 - (double)this.eyeHeight + (double)this.headSneakHeight, d2 - (double)f, d + (double)f, d1 - (double)this.eyeHeight + (double)this.headSneakHeight + (double)f1, d2 + (double)f);
    }

    public void func_346_d(float f, float f1) {
        float f2 = this.rotationPitch;
        float f3 = this.rotationYaw;
        this.rotationYaw = (float)((double)this.rotationYaw + (double)f * 0.15);
        this.rotationPitch = (float)((double)this.rotationPitch - (double)f1 * 0.15);
        if (this.rotationPitch < -90.0f) {
            this.rotationPitch = -90.0f;
        }
        if (this.rotationPitch > 90.0f) {
            this.rotationPitch = 90.0f;
        }
        this.headPitch += this.rotationPitch - f2;
        this.headYaw += this.rotationYaw - f3;
    }

    public void enterWater() {
        this.inWater();
    }

    public void inWater() {
        if (this.field_616_af != null && this.field_616_af.hasDied) {
            this.field_616_af = null;
        }
        ++this.field_629_aR;
        this.field_642_aE = this.field_641_aF;
        this.field_614_ah = this.posX;
        this.field_613_ai = this.posY;
        this.field_612_aj = this.posZ;
        this.headPitch = this.rotationPitch;
        this.headYaw = this.rotationYaw;
        if (this.isInWater()) {
            if (!this.hasSplashed && !this.field_651_c) {
                float f = MathHelper.squareRootDoubleToFloat(this.motionX * this.motionX * (double)0.2f + this.motionY * this.motionY + this.motionZ * this.motionZ * (double)0.2f) * 0.2f;
                if (f > 1.0f) {
                    f = 1.0f;
                }
                this.worldObj.func_623_a(this, "random.splash", f, 1.0f + (this.rand.nextFloat() - this.rand.nextFloat()) * 0.4f);
                float f1 = MathHelper.floor_double(this.boundingBox.minY);
                int i = 0;
                while ((float)i < 1.0f + this.width * 20.0f) {
                    float f2 = (this.rand.nextFloat() * 2.0f - 1.0f) * this.width;
                    float f4 = (this.rand.nextFloat() * 2.0f - 1.0f) * this.width;
                    this.worldObj.func_694_a("bubble", this.posX + (double)f2, f1 + 1.0f, this.posZ + (double)f4, this.motionX, this.motionY - (double)(this.rand.nextFloat() * 0.2f), this.motionZ);
                    ++i;
                }
                int j = 0;
                while ((float)j < 1.0f + this.width * 20.0f) {
                    float f3 = (this.rand.nextFloat() * 2.0f - 1.0f) * this.width;
                    float f5 = (this.rand.nextFloat() * 2.0f - 1.0f) * this.width;
                    this.worldObj.func_694_a("splash", this.posX + (double)f3, f1 + 1.0f, this.posZ + (double)f5, this.motionX, this.motionY, this.motionZ);
                    ++j;
                }
            }
            this.fallDistance = 0.0f;
            this.hasSplashed = true;
            this.fire = 0;
        } else {
            this.hasSplashed = false;
        }
        if (this.fire > 0) {
            if (this.fire % 20 == 0) {
                this.attacked(null, 1);
            }
            --this.fire;
        }
        if (this.handleLavaMovement()) {
            this.attacked(null, 10);
            this.fire = 600;
        }
        if (this.posY < -64.0) {
            this.func_369_E();
        }
        this.field_651_c = false;
    }

    protected void func_369_E() {
        this.func_395_F();
    }

    public boolean func_403_b(double d, double d1, double d2) {
        AxisAlignedBB axisalignedbb = this.boundingBox.func_1166_c(d, d1, d2);
        List<AxisAlignedBB> list = this.worldObj.func_697_a(this, axisalignedbb);
        if (list.size() > 0) {
            return false;
        }
        return !this.worldObj.func_662_b(axisalignedbb);
    }

    public void func_349_c(double d, double d1, double d2) {
        boolean flag;
        if (this.field_633_aN) {
            this.boundingBox.func_1174_d(d, d1, d2);
            this.posX = (this.boundingBox.field_1698_a + this.boundingBox.field_1703_d) / 2.0;
            this.posY = this.boundingBox.minY + (double)this.eyeHeight - (double)this.headSneakHeight;
            this.posZ = (this.boundingBox.field_1704_c + this.boundingBox.field_1701_f) / 2.0;
            return;
        }
        double d3 = this.posX;
        double d4 = this.posZ;
        double d5 = d;
        double d6 = d1;
        double d7 = d2;
        AxisAlignedBB axisalignedbb = this.boundingBox.func_1160_c();
        boolean bl = flag = this.onGround && this.func_381_o();
        if (flag) {
            double d8 = 0.05;
            while (d != 0.0 && this.worldObj.func_697_a(this, this.boundingBox.func_1166_c(d, -1.0, 0.0)).size() == 0) {
                d = d < d8 && d >= -d8 ? 0.0 : (d > 0.0 ? (d -= d8) : (d += d8));
                d5 = d;
            }
            while (d2 != 0.0 && this.worldObj.func_697_a(this, this.boundingBox.func_1166_c(0.0, -1.0, d2)).size() == 0) {
                d2 = d2 < d8 && d2 >= -d8 ? 0.0 : (d2 > 0.0 ? (d2 -= d8) : (d2 += d8));
                d7 = d2;
            }
        }
        List<AxisAlignedBB> list = this.worldObj.func_697_a(this, this.boundingBox.func_1170_a(d, d1, d2));
        int i = 0;
        while (i < list.size()) {
            d1 = list.get(i).func_1172_b(this.boundingBox, d1);
            ++i;
        }
        this.boundingBox.func_1174_d(0.0, d1, 0.0);
        if (!this.field_596_az && d6 != d1) {
            d2 = 0.0;
            d1 = 0.0;
            d = 0.0;
        }
        boolean flag1 = this.onGround || d6 != d1 && d6 < 0.0;
        int j = 0;
        while (j < list.size()) {
            d = list.get(j).func_1163_a(this.boundingBox, d);
            ++j;
        }
        this.boundingBox.func_1174_d(d, 0.0, 0.0);
        if (!this.field_596_az && d5 != d) {
            d2 = 0.0;
            d1 = 0.0;
            d = 0.0;
        }
        int k = 0;
        while (k < list.size()) {
            d2 = list.get(k).func_1162_c(this.boundingBox, d2);
            ++k;
        }
        this.boundingBox.func_1174_d(0.0, 0.0, d2);
        if (!this.field_596_az && d7 != d2) {
            d2 = 0.0;
            d1 = 0.0;
            d = 0.0;
        }
        if (this.field_634_aM > 0.0f && flag1 && this.headSneakHeight < 0.05f && (d5 != d || d7 != d2)) {
            double d9 = d;
            double d11 = d1;
            double d13 = d2;
            d = d5;
            d1 = this.field_634_aM;
            d2 = d7;
            AxisAlignedBB axisalignedbb1 = this.boundingBox.func_1160_c();
            this.boundingBox.func_1171_b(axisalignedbb);
            List<AxisAlignedBB> list1 = this.worldObj.func_697_a(this, this.boundingBox.func_1170_a(d, d1, d2));
            int j2 = 0;
            while (j2 < list1.size()) {
                d1 = list1.get(j2).func_1172_b(this.boundingBox, d1);
                ++j2;
            }
            this.boundingBox.func_1174_d(0.0, d1, 0.0);
            if (!this.field_596_az && d6 != d1) {
                d2 = 0.0;
                d1 = 0.0;
                d = 0.0;
            }
            int k2 = 0;
            while (k2 < list1.size()) {
                d = list1.get(k2).func_1163_a(this.boundingBox, d);
                ++k2;
            }
            this.boundingBox.func_1174_d(d, 0.0, 0.0);
            if (!this.field_596_az && d5 != d) {
                d2 = 0.0;
                d1 = 0.0;
                d = 0.0;
            }
            int l2 = 0;
            while (l2 < list1.size()) {
                d2 = list1.get(l2).func_1162_c(this.boundingBox, d2);
                ++l2;
            }
            this.boundingBox.func_1174_d(0.0, 0.0, d2);
            if (!this.field_596_az && d7 != d2) {
                d2 = 0.0;
                d1 = 0.0;
                d = 0.0;
            }
            if (d9 * d9 + d13 * d13 >= d * d + d2 * d2) {
                d = d9;
                d1 = d11;
                d2 = d13;
                this.boundingBox.func_1171_b(axisalignedbb1);
            } else {
                this.headSneakHeight = (float)((double)this.headSneakHeight + 0.5);
            }
        }
        this.posX = (this.boundingBox.field_1698_a + this.boundingBox.field_1703_d) / 2.0;
        this.posY = this.boundingBox.minY + (double)this.eyeHeight - (double)this.headSneakHeight;
        this.posZ = (this.boundingBox.field_1704_c + this.boundingBox.field_1701_f) / 2.0;
        this.field_599_aw = d5 != d || d7 != d2;
        this.field_598_ax = d6 != d1;
        this.onGround = d6 != d1 && d6 < 0.0;
        boolean bl2 = this.field_597_ay = this.field_599_aw || this.field_598_ax;
        if (this.onGround) {
            if (this.fallDistance > 0.0f) {
                this.func_400_c(this.fallDistance);
                this.fallDistance = 0.0f;
            }
        } else if (d1 < 0.0) {
            this.fallDistance = (float)((double)this.fallDistance - d1);
        }
        if (d5 != d) {
            this.motionX = 0.0;
        }
        if (d6 != d1) {
            this.motionY = 0.0;
        }
        if (d7 != d2) {
            this.motionZ = 0.0;
        }
        double d10 = this.posX - d3;
        double d12 = this.posZ - d4;
        this.field_641_aF = (float)((double)this.field_641_aF + (double)MathHelper.squareRootDoubleToFloat(d10 * d10 + d12 * d12) * 0.6);
        if (this.field_640_aG && !flag) {
            int l = MathHelper.floor_double(this.posX);
            int j1 = MathHelper.floor_double(this.posY - (double)0.2f - (double)this.eyeHeight);
            int l1 = MathHelper.floor_double(this.posZ);
            int i3 = this.worldObj.getBlock(l, j1, l1);
            if (this.field_641_aF > (float)this.field_653_b && i3 > 0) {
                ++this.field_653_b;
                StepSound stepsound = Block.allBlocks[i3].stepSound;
                if (this.worldObj.getBlock(l, j1 + 1, l1) == Block.snow.blockID) {
                    stepsound = Block.snow.stepSound;
                    this.worldObj.func_623_a(this, stepsound.func_1145_d(), stepsound.func_1147_b() * 0.15f, stepsound.func_1144_c());
                } else if (!Block.allBlocks[i3].material.func_879_d()) {
                    this.worldObj.func_623_a(this, stepsound.func_1145_d(), stepsound.func_1147_b() * 0.15f, stepsound.func_1144_c());
                }
                Block.allBlocks[i3].func_254_a(this.worldObj, l, j1, l1, this);
            }
        }
        int i1 = MathHelper.floor_double(this.boundingBox.field_1698_a);
        int k1 = MathHelper.floor_double(this.boundingBox.minY);
        int i2 = MathHelper.floor_double(this.boundingBox.field_1704_c);
        int j3 = MathHelper.floor_double(this.boundingBox.field_1703_d);
        int k3 = MathHelper.floor_double(this.boundingBox.field_1702_e);
        int l3 = MathHelper.floor_double(this.boundingBox.field_1701_f);
        int i4 = i1;
        while (i4 <= j3) {
            int j4 = k1;
            while (j4 <= k3) {
                int k4 = i2;
                while (k4 <= l3) {
                    int l4 = this.worldObj.getBlock(i4, j4, k4);
                    if (l4 > 0) {
                        Block.allBlocks[l4].func_236_b(this.worldObj, i4, j4, k4, this);
                    }
                    ++k4;
                }
                ++j4;
            }
            ++i4;
        }
        this.headSneakHeight *= 0.4f;
        boolean flag2 = this.isInWater();
        if (this.worldObj.func_605_c(this.boundingBox)) {
            this.func_355_a(1);
            if (!flag2) {
                ++this.fire;
                if (this.fire == 0) {
                    this.fire = 300;
                }
            }
        } else if (this.fire <= 0) {
            this.fire = -this.field_628_aS;
        }
        if (flag2 && this.fire > 0) {
            this.worldObj.func_623_a(this, "random.fizz", 0.7f, 1.6f + (this.rand.nextFloat() - this.rand.nextFloat()) * 0.4f);
            this.fire = -this.field_628_aS;
        }
    }

    public boolean func_381_o() {
        return false;
    }

    public AxisAlignedBB func_372_f_() {
        return null;
    }

    protected void func_355_a(int i) {
        this.attacked(null, i);
    }

    protected void func_400_c(float f) {
    }

    public boolean isInWater() {
        return this.worldObj.func_682_a(this.boundingBox.func_1177_b(0.0, -0.4f, 0.0), Material.water, this);
    }

    public boolean headSpaceMaterial(Material material) {
        int k;
        int j;
        double d = this.posY + (double)this.func_373_s();
        int i = MathHelper.floor_double(this.posX);
        int l = this.worldObj.getBlock(i, j = MathHelper.func_1110_d(MathHelper.floor_double(d)), k = MathHelper.floor_double(this.posZ));
        if (l != 0 && Block.allBlocks[l].material == material) {
            float f = BlockFluids.getFluidLevel(this.worldObj.getBlockSomethingIDK(i, j, k)) - 0.1111111f;
            float f1 = (float)(j + 1) - f;
            return d < (double)f1;
        }
        return false;
    }

    protected float func_373_s() {
        return 0.0f;
    }

    public boolean handleLavaMovement() {
        return this.worldObj.func_689_a(this.boundingBox.func_1177_b(0.0, -0.4f, 0.0), Material.lava);
    }

    public void func_351_a(float f, float f1, float f2) {
        float f3 = MathHelper.func_1113_c(f * f + f1 * f1);
        if (f3 < 0.01f) {
            return;
        }
        if (f3 < 1.0f) {
            f3 = 1.0f;
        }
        f3 = f2 / f3;
        float f4 = MathHelper.sin(this.rotationYaw * 3.141593f / 180.0f);
        float f5 = MathHelper.cos(this.rotationYaw * 3.141593f / 180.0f);
        this.motionX += (double)((f *= f3) * f5 - (f1 *= f3) * f4);
        this.motionZ += (double)(f1 * f5 + f * f4);
    }

    public float func_382_a(float f) {
        int i = MathHelper.floor_double(this.posX);
        double d = (this.boundingBox.field_1702_e - this.boundingBox.minY) * 0.66;
        int j = MathHelper.floor_double(this.posY - (double)this.eyeHeight + d);
        int k = MathHelper.floor_double(this.posZ);
        return this.worldObj.func_598_c(i, j, k);
    }

    public void setWorld(World world) {
        this.worldObj = world;
    }

    public void func_399_b(double d, double d1, double d2, float f, float f1) {
        this.field_614_ah = this.posX = d;
        this.field_613_ai = this.posY = d1;
        this.field_612_aj = this.posZ = d2;
        this.rotationYaw = f;
        this.rotationPitch = f1;
        this.headSneakHeight = 0.0f;
        double d3 = this.headYaw - f;
        if (d3 < -180.0) {
            this.headYaw += 360.0f;
        }
        if (d3 >= 180.0) {
            this.headYaw -= 360.0f;
        }
        this.func_347_a(this.posX, this.posY, this.posZ);
    }

    public void spawnNewEntity(double d, double d1, double d2, float f, float f1) {
        this.field_614_ah = this.posX = d;
        this.field_613_ai = this.posY = d1 + (double)this.eyeHeight;
        this.field_612_aj = this.posZ = d2;
        this.rotationYaw = f;
        this.rotationPitch = f1;
        this.func_347_a(this.posX, this.posY, this.posZ);
    }

    public float getDistanceToEntity(Entity entity) {
        float f = (float)(this.posX - entity.posX);
        float f1 = (float)(this.posY - entity.posY);
        float f2 = (float)(this.posZ - entity.posZ);
        return MathHelper.func_1113_c(f * f + f1 * f1 + f2 * f2);
    }

    public double func_360_d(double d, double d1, double d2) {
        double d3 = this.posX - d;
        double d4 = this.posY - d1;
        double d5 = this.posZ - d2;
        return d3 * d3 + d4 * d4 + d5 * d5;
    }

    public double func_361_e(double d, double d1, double d2) {
        double d3 = this.posX - d;
        double d4 = this.posY - d1;
        double d5 = this.posZ - d2;
        return MathHelper.squareRootDoubleToFloat(d3 * d3 + d4 * d4 + d5 * d5);
    }

    public double func_387_e(Entity entity) {
        double d = this.posX - entity.posX;
        double d1 = this.posY - entity.posY;
        double d2 = this.posZ - entity.posZ;
        return d * d + d1 * d1 + d2 * d2;
    }

    public void func_362_b(EntityPlayer entityplayer) {
    }

    public void func_380_f(Entity entity) {
        if (entity.field_617_ae == this || entity.field_616_af == this) {
            return;
        }
        double d = entity.posX - this.posX;
        double d1 = entity.posZ - this.posZ;
        double d2 = MathHelper.func_1107_a(d, d1);
        if (d2 >= (double)0.01f) {
            d2 = MathHelper.squareRootDoubleToFloat(d2);
            d /= d2;
            d1 /= d2;
            double d3 = 1.0 / d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d *= d3;
            d1 *= d3;
            d *= (double)0.05f;
            d1 *= (double)0.05f;
            this.entityMove(-(d *= (double)(1.0f - this.field_632_aO)), 0.0, -(d1 *= (double)(1.0f - this.field_632_aO)));
            entity.entityMove(d, 0.0, d1);
        }
    }

    public void entityMove(double d, double d1, double d2) {
        this.motionX += d;
        this.motionY += d1;
        this.motionZ += d2;
    }

    public boolean attacked(Entity entity, int i) {
        return false;
    }

    public boolean func_401_c_() {
        return false;
    }

    public boolean func_385_d_() {
        return false;
    }

    public void func_364_b(Entity entity, int i) {
    }

    public boolean func_390_a(Vec3D vec3d) {
        double d = this.posX - vec3d.xCoord;
        double d1 = this.posY - vec3d.yCoord;
        double d2 = this.posZ - vec3d.zCoord;
        double d3 = d * d + d1 * d1 + d2 * d2;
        return this.func_384_a(d3);
    }

    public boolean func_384_a(double d) {
        double d1 = this.boundingBox.func_1164_b();
        return d < (d1 *= 64.0 * this.field_619_ac) * d1;
    }

    public String func_356_x() {
        return null;
    }

    public boolean func_358_c(NBTTagCompound nbttagcompound) {
        String s = this.func_389_H();
        if (this.hasDied || s == null) {
            return false;
        }
        nbttagcompound.setString("id", s);
        this.func_363_d(nbttagcompound);
        return true;
    }

    public void func_363_d(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_762_a("Pos", this.func_375_a(new double[]{this.posX, this.posY, this.posZ}));
        nbttagcompound.func_762_a("Motion", this.func_375_a(new double[]{this.motionX, this.motionY, this.motionZ}));
        nbttagcompound.func_762_a("Rotation", this.func_377_a(new float[]{this.rotationYaw, this.rotationPitch}));
        nbttagcompound.setFloat("FallDistance", this.fallDistance);
        nbttagcompound.func_749_a("Fire", (short)this.fire);
        nbttagcompound.func_749_a("Air", (short)this.air);
        nbttagcompound.setBool("OnGround", this.onGround);
        this.addNBTTag(nbttagcompound);
    }

    public void func_368_e(NBTTagCompound nbttagcompound) {
        NBTTagList nbttaglist = nbttagcompound.func_753_l("Pos");
        NBTTagList nbttaglist1 = nbttagcompound.func_753_l("Motion");
        NBTTagList nbttaglist2 = nbttagcompound.func_753_l("Rotation");
        this.func_347_a(0.0, 0.0, 0.0);
        this.motionX = ((NBTTagDouble)nbttaglist1.func_741_a((int)0)).doubleValue;
        this.motionY = ((NBTTagDouble)nbttaglist1.func_741_a((int)1)).doubleValue;
        this.motionZ = ((NBTTagDouble)nbttaglist1.func_741_a((int)2)).doubleValue;
        this.field_638_aI = this.posX = ((NBTTagDouble)nbttaglist.func_741_a((int)0)).doubleValue;
        this.field_614_ah = this.posX;
        this.field_637_aJ = this.posY = ((NBTTagDouble)nbttaglist.func_741_a((int)1)).doubleValue;
        this.field_613_ai = this.posY;
        this.field_636_aK = this.posZ = ((NBTTagDouble)nbttaglist.func_741_a((int)2)).doubleValue;
        this.field_612_aj = this.posZ;
        this.headYaw = this.rotationYaw = ((NBTTagFloat)nbttaglist2.func_741_a((int)0)).floatValue;
        this.headPitch = this.rotationPitch = ((NBTTagFloat)nbttaglist2.func_741_a((int)1)).floatValue;
        this.fallDistance = nbttagcompound.func_752_g("FallDistance");
        this.fire = nbttagcompound.func_745_d("Fire");
        this.air = nbttagcompound.func_745_d("Air");
        this.onGround = nbttagcompound.tag("OnGround");
        this.func_347_a(this.posX, this.posY, this.posZ);
        this.removeNBTTag(nbttagcompound);
    }

    protected final String func_389_H() {
        return EntityList.func_1083_b(this);
    }

    protected abstract void removeNBTTag(NBTTagCompound var1);

    protected abstract void addNBTTag(NBTTagCompound var1);

    protected NBTTagList func_375_a(double[] ad) {
        NBTTagList nbttaglist = new NBTTagList();
        double[] ad1 = ad;
        int i = ad1.length;
        int j = 0;
        while (j < i) {
            double d = ad1[j];
            nbttaglist.func_742_a(new NBTTagDouble(d));
            ++j;
        }
        return nbttaglist;
    }

    protected NBTTagList func_377_a(float[] af) {
        NBTTagList nbttaglist = new NBTTagList();
        float[] af1 = af;
        int i = af1.length;
        int j = 0;
        while (j < i) {
            float f = af1[j];
            nbttaglist.func_742_a(new NBTTagFloat(f));
            ++j;
        }
        return nbttaglist;
    }

    public float func_392_h_() {
        return this.height / 2.0f;
    }

    public EntityItem func_367_b(int i, int j) {
        return this.dropItem(i, j, 0.0f);
    }

    public EntityItem dropItem(int i, int j, float f) {
        EntityItem entityitem = new EntityItem(this.worldObj, this.posX, this.posY + (double)f, this.posZ, new ItemStack(i, j));
        entityitem.field_805_c = 10;
        this.worldObj.addNewEntity(entityitem);
        return entityitem;
    }

    public boolean isEntityAlive() {
        return !this.hasDied;
    }

    public boolean func_345_I() {
        int i = MathHelper.floor_double(this.posX);
        int j = MathHelper.floor_double(this.posY + (double)this.func_373_s());
        int k = MathHelper.floor_double(this.posZ);
        return this.worldObj.isBlockNormalCube(i, j, k);
    }

    public boolean checkRide(EntityPlayer entityplayer) {
        return false;
    }

    public AxisAlignedBB func_383_b_(Entity entity) {
        return null;
    }

    public void func_350_p() {
        if (this.field_616_af.hasDied) {
            this.field_616_af = null;
            return;
        }
        this.motionX = 0.0;
        this.motionY = 0.0;
        this.motionZ = 0.0;
        this.enterWater();
        this.field_616_af.func_366_i_();
        this.field_647_e += (double)(this.field_616_af.rotationYaw - this.field_616_af.headYaw);
        this.field_649_d += (double)(this.field_616_af.rotationPitch - this.field_616_af.headPitch);
        while (this.field_647_e >= 180.0) {
            this.field_647_e -= 360.0;
        }
        while (this.field_647_e < -180.0) {
            this.field_647_e += 360.0;
        }
        while (this.field_649_d >= 180.0) {
            this.field_649_d -= 360.0;
        }
        while (this.field_649_d < -180.0) {
            this.field_649_d += 360.0;
        }
        double d = this.field_647_e * 0.5;
        double d1 = this.field_649_d * 0.5;
        float f = 10.0f;
        if (d > (double)f) {
            d = f;
        }
        if (d < (double)(-f)) {
            d = -f;
        }
        if (d1 > (double)f) {
            d1 = f;
        }
        if (d1 < (double)(-f)) {
            d1 = -f;
        }
        this.field_647_e -= d;
        this.field_649_d -= d1;
        this.rotationYaw = (float)((double)this.rotationYaw + d);
        this.rotationPitch = (float)((double)this.rotationPitch + d1);
    }

    protected void func_366_i_() {
        this.field_617_ae.func_347_a(this.posX, this.posY + this.func_402_h() + this.field_617_ae.func_388_v(), this.posZ);
    }

    public double func_388_v() {
        return this.eyeHeight;
    }

    public double func_402_h() {
        return (double)this.height * 0.75;
    }

    public void rideMount(Entity entity) {
        this.field_649_d = 0.0;
        this.field_647_e = 0.0;
        if (this.field_616_af == entity) {
            this.field_616_af.field_617_ae = null;
            this.field_616_af = null;
            this.spawnNewEntity(entity.posX, entity.boundingBox.minY + (double)entity.height, entity.posZ, this.rotationYaw, this.rotationPitch);
            return;
        }
        if (this.field_616_af != null) {
            this.field_616_af.field_617_ae = null;
        }
        if (entity.field_617_ae != null) {
            entity.field_617_ae.field_616_af = null;
        }
        this.field_616_af = entity;
        entity.field_617_ae = this;
    }

    public void func_378_a(double d, double d1, double d2, float f, float f1, int i) {
        this.func_347_a(d, d1, d2);
        this.func_376_c(f, f1);
    }

    public double getRealMoveSpeed() {
        return 0.5;
    }

    public float getEyeHeight() {
        return this.eyeHeight;
    }
}

