/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityLiving;
import com.mojang.minecraft.entity.path.PathEntity;
import com.mojang.minecraft.entity.path.PathEntityIndev;
import com.mojang.minecraft.entity.path.PathFinderIndev;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.render.Vec3D;
import com.mojang.minecraft.util.MathHelper;

public class EntityCreature
extends EntityLiving {
    private PathEntity pathToEntity;
    private PathEntityIndev indevPathToEntity;
    protected Entity entityToAttack;
    protected boolean hasAttacked = false;
    public boolean indevai;
    public static PathFinderIndev pathFinderIndev;

    public EntityCreature(World world) {
        super(world);
        if (world.difficulty >= 2) {
            this.indevai = true;
        }
        if (this.worldObj != null && (pathFinderIndev == null || EntityCreature.pathFinderIndev.worldObj != world)) {
            pathFinderIndev = new PathFinderIndev(this.worldObj);
        }
    }

    public void setWorld(World par1World) {
        this.worldObj = par1World;
        if (pathFinderIndev == null || EntityCreature.pathFinderIndev.worldObj != par1World) {
            pathFinderIndev = new PathFinderIndev(this.worldObj);
        }
    }

    protected void updateEntityActionStateIndev() {
        this.hasAttacked = false;
        PathFinderIndev pathFinder = pathFinderIndev;
        if (this.entityToAttack == null) {
            this.entityToAttack = this.findPlayerToAttack();
            if (this.entityToAttack != null) {
                this.indevPathToEntity = pathFinder.a(this, this.entityToAttack, 16.0f);
            }
        } else if (!this.entityToAttack.isEntityAlive()) {
            this.entityToAttack = null;
        } else {
            float var1 = this.entityToAttack.getDistanceToEntity(this);
            this.attackEntity(this.entityToAttack, var1);
        }
        if (this.hasAttacked) {
            this.movingLeftRight = 0.0f;
            this.movingForwardBack = 0.0f;
            this.isJumping = false;
        } else {
            float var4;
            if (this.entityToAttack != null && (this.indevPathToEntity == null || this.rand.nextInt(20) == 0)) {
                this.indevPathToEntity = pathFinder.a(this, this.entityToAttack, 16.0f);
            } else if (this.indevPathToEntity == null || this.rand.nextInt(100) == 0) {
                int var10 = -1;
                int var2 = -1;
                int var3 = -1;
                var4 = -99999.0f;
                int var14 = 0;
                while (var14 < 200) {
                    float f;
                    int var16 = (int)(this.posX + (double)this.rand.nextInt(21) - 10.0);
                    int var17 = (int)(this.posY + (double)this.rand.nextInt(9) - 4.0);
                    int var18 = (int)(this.posZ + (double)this.rand.nextInt(21) - 10.0);
                    float var9 = this.getBlockPathWeight(var16, var17, var18);
                    if (f > var4) {
                        var4 = var9;
                        var10 = var16;
                        var2 = var17;
                        var3 = var18;
                    }
                    ++var14;
                }
                if (var10 > 0) {
                    this.indevPathToEntity = pathFinder.a((Entity)this, var10, var2, var3, 16.0f);
                }
            }
            boolean var11 = this.isInWater();
            boolean var12 = this.handleLavaMovement();
            if (this.indevPathToEntity != null && this.rand.nextInt(100) != 0) {
                double var6;
                double var7;
                Vec3D var13 = this.indevPathToEntity.a(this);
                var4 = this.width * 2.0f;
                while (var13 != null) {
                    double var8 = this.posZ;
                    var7 = this.posY;
                    var6 = this.posX;
                    double var16 = var8 - var13.zCoord;
                    if ((var6 -= var13.xCoord) * var6 + (var7 -= var13.yCoord) * var7 + var16 * var16 >= (double)(var4 * var4) || var13.yCoord > this.posY) break;
                    this.indevPathToEntity.a();
                    if (this.indevPathToEntity.b()) {
                        var13 = null;
                        this.indevPathToEntity = null;
                        continue;
                    }
                    var13 = this.indevPathToEntity.a(this);
                }
                this.isJumping = false;
                if (var13 != null) {
                    double var16 = var13.xCoord - this.posX;
                    var6 = var13.zCoord - this.posZ;
                    var7 = var13.yCoord - this.posY;
                    this.rotationYaw = (float)(Math.atan2(var6, var16) * 180.0 / Math.PI) - 90.0f;
                    this.movingForwardBack = (float)this.getRealMoveSpeed();
                    if (var7 > 0.0) {
                        this.isJumping = true;
                    }
                }
                if (this.rand.nextFloat() < 0.8f && (var11 || var12)) {
                    this.isJumping = true;
                }
            } else {
                super.updateEntityActionStateIndev();
                this.indevPathToEntity = null;
            }
        }
    }

    protected void updateEntityActionState() {
        if (this.indevai) {
            this.updateEntityActionStateIndev();
            return;
        }
        this.hasAttacked = false;
        float f = 16.0f;
        if (this.entityToAttack == null) {
            this.entityToAttack = this.findPlayerToAttack();
            if (this.entityToAttack != null) {
                this.pathToEntity = this.worldObj.getPathEntityToEntity(this, this.entityToAttack, f);
            }
        } else if (!this.entityToAttack.isEntityAlive()) {
            this.entityToAttack = null;
        } else {
            float f1 = this.entityToAttack.getDistanceToEntity(this);
            if (this.canEntityBeSeen(this.entityToAttack)) {
                this.attackEntity(this.entityToAttack, f1);
            }
        }
        if (!(this.hasAttacked || this.entityToAttack == null || this.pathToEntity != null && this.rand.nextInt(20) != 0)) {
            this.pathToEntity = this.worldObj.getPathEntityToEntity(this, this.entityToAttack, f);
        } else if (this.pathToEntity == null && this.rand.nextInt(80) == 0 || this.rand.nextInt(80) == 0) {
            boolean flag = false;
            int j = -1;
            int k = -1;
            int l = -1;
            float f2 = -99999.0f;
            int i1 = 0;
            while (i1 < 10) {
                int l1;
                int k1;
                int j1 = MathHelper.floor_double(this.posX + (double)this.rand.nextInt(13) - 6.0);
                float f3 = this.getBlockPathWeight(j1, k1 = MathHelper.floor_double(this.posY + (double)this.rand.nextInt(7) - 3.0), l1 = MathHelper.floor_double(this.posZ + (double)this.rand.nextInt(13) - 6.0));
                if (f3 > f2) {
                    f2 = f3;
                    j = j1;
                    k = k1;
                    l = l1;
                    flag = true;
                }
                ++i1;
            }
            if (flag) {
                this.pathToEntity = this.worldObj.func_637_a(this, j, k, l, 10.0f);
            }
        }
        int i = MathHelper.floor_double(this.boundingBox.minY);
        boolean flag1 = this.isInWater();
        boolean flag2 = this.handleLavaMovement();
        this.rotationPitch = 0.0f;
        if (this.pathToEntity == null || this.rand.nextInt(100) == 0) {
            super.updateEntityActionState();
            this.pathToEntity = null;
            return;
        }
        Vec3D vec3d = this.pathToEntity.getPosition(this);
        double d = this.width * 2.0f;
        while (vec3d != null && vec3d.getDistance(this.posX, vec3d.yCoord, this.posZ) < d * d) {
            this.pathToEntity.incrementPathIndex();
            if (this.pathToEntity.isFinished()) {
                vec3d = null;
                this.pathToEntity = null;
                continue;
            }
            vec3d = this.pathToEntity.getPosition(this);
        }
        this.isJumping = false;
        if (vec3d != null) {
            double d1 = vec3d.xCoord - this.posX;
            double d2 = vec3d.zCoord - this.posZ;
            double d3 = vec3d.yCoord - (double)i;
            float f4 = (float)(Math.atan2(d2, d1) * 180.0 / 3.1415927410125732) - 90.0f;
            float f5 = f4 - this.rotationYaw;
            this.movingForwardBack = this.move_speed;
            while (f5 < -180.0f) {
                f5 += 360.0f;
            }
            while (f5 >= 180.0f) {
                f5 -= 360.0f;
            }
            if (f5 > 30.0f) {
                f5 = 30.0f;
            }
            if (f5 < -30.0f) {
                f5 = -30.0f;
            }
            this.rotationYaw += f5;
            if (this.hasAttacked && this.entityToAttack != null) {
                double d4 = this.entityToAttack.posX - this.posX;
                double d5 = this.entityToAttack.posZ - this.posZ;
                float f7 = this.rotationYaw;
                this.rotationYaw = (float)(Math.atan2(d5, d4) * 180.0 / 3.1415927410125732) - 90.0f;
                float f6 = (f7 - this.rotationYaw + 90.0f) * 3.141593f / 180.0f;
                this.movingLeftRight = -MathHelper.sin(f6) * this.movingForwardBack * 1.0f;
                this.movingForwardBack = MathHelper.cos(f6) * this.movingForwardBack * 1.0f;
            }
            if (d3 > 0.0) {
                this.isJumping = true;
            }
        }
        if (this.entityToAttack != null) {
            this.func_426_b(this.entityToAttack, 30.0f);
        }
        if (this.field_599_aw) {
            this.isJumping = true;
        }
        if (this.rand.nextFloat() < 0.8f && (flag1 || flag2)) {
            this.isJumping = true;
        }
    }

    protected void attackEntity(Entity entity, float f) {
    }

    protected float getBlockPathWeight(int i, int j, int k) {
        return 0.0f;
    }

    protected Entity findPlayerToAttack() {
        return null;
    }

    public boolean func_433_a() {
        int i = MathHelper.floor_double(this.posX);
        int j = MathHelper.floor_double(this.boundingBox.minY);
        int k = MathHelper.floor_double(this.posZ);
        return super.func_433_a() && this.getBlockPathWeight(i, j, k) >= 0.0f;
    }
}

