/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity;

import com.mojang.minecraft.entity.EntityAnimals;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.item.Item;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.nbt.NBTTagCompound;

public class EntityPig
extends EntityAnimals {
    public boolean isSaddled = false;

    public EntityPig(World world) {
        super(world);
        this.scoreYield = 10;
        this.texture = "/mob/pig.png";
        this.setBounds(0.9f, 0.9f);
        this.isSaddled = false;
    }

    public void addNBTTag(NBTTagCompound nbttagcompound) {
        super.addNBTTag(nbttagcompound);
        nbttagcompound.setBool("Saddle", this.isSaddled);
    }

    public void removeNBTTag(NBTTagCompound nbttagcompound) {
        super.removeNBTTag(nbttagcompound);
        this.isSaddled = nbttagcompound.tag("Saddle");
    }

    protected String idleSound() {
        return "mob.pig";
    }

    protected String hurtSound() {
        return "mob.pig";
    }

    protected String deathSound() {
        return "mob.pigdeath";
    }

    public boolean checkRide(EntityPlayer entityplayer) {
        if (this.isSaddled) {
            entityplayer.rideMount(this);
            return true;
        }
        return false;
    }

    protected int deathDropItem() {
        if (!this.isSaddled) {
            return Item.porkRaw.swiftedIndex;
        }
        this.func_367_b(Item.saddle.swiftedIndex, 1);
        return Item.porkRaw.swiftedIndex;
    }
}

