/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.MovingObjectPosition;
import com.mojang.minecraft.entity.item.Item;
import com.mojang.minecraft.entity.tile.IBlockAccess;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.material.Material;
import com.mojang.minecraft.level.tile.phys.AxisAlignedBB;
import com.mojang.minecraft.render.Vec3D;
import java.util.Random;

public class BlockDoor
extends Block {
    protected BlockDoor(int i, Material material) {
        super(i, material);
        this.textureIndex = 97;
        if (material == Material.iron) {
            ++this.textureIndex;
        }
        float f = 0.5f;
        float f1 = 1.0f;
        this.setBlockBounds(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, f1, 0.5f + f);
    }

    public int getTextureIndex(int i, int j) {
        if (i == 0 || i == 1) {
            return this.textureIndex;
        }
        int k = this.func_312_c(j);
        if ((k == 0 || k == 2) ^ i <= 3) {
            return this.textureIndex;
        }
        int l = k / 2 + (i & 1 ^ k);
        int i1 = this.textureIndex - (j & 8) * 2;
        if (((l += (j & 4) / 4) & 1) != 0) {
            i1 = -i1;
        }
        return i1;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean func_242_c() {
        return false;
    }

    public int getRenderType() {
        return 7;
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        this.func_238_a(world, i, j, k);
        return super.getCollisionBoundingBoxFromPool(world, i, j, k);
    }

    public AxisAlignedBB func_221_d(World world, int i, int j, int k) {
        this.func_238_a(world, i, j, k);
        return super.func_221_d(world, i, j, k);
    }

    public void func_238_a(IBlockAccess iblockaccess, int i, int j, int k) {
        this.func_313_b(this.func_312_c(iblockaccess.getBlockSomethingIDK(i, j, k)));
    }

    public void func_313_b(int i) {
        float f = 0.1875f;
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 2.0f, 1.0f);
        if (i == 0) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, f);
        }
        if (i == 1) {
            this.setBlockBounds(1.0f - f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
        if (i == 2) {
            this.setBlockBounds(0.0f, 0.0f, 1.0f - f, 1.0f, 1.0f, 1.0f);
        }
        if (i == 3) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, f, 1.0f, 1.0f);
        }
    }

    public void func_233_b(World world, int i, int j, int k, EntityPlayer entityplayer) {
        this.func_250_a(world, i, j, k, entityplayer);
    }

    public boolean func_250_a(World world, int i, int j, int k, EntityPlayer entityplayer) {
        if (this.material == Material.iron) {
            return true;
        }
        int l = world.getBlockSomethingIDK(i, j, k);
        if ((l & 8) != 0) {
            if (world.getBlock(i, j - 1, k) == this.blockID) {
                this.func_250_a(world, i, j - 1, k, entityplayer);
            }
            return true;
        }
        if (world.getBlock(i, j + 1, k) == this.blockID) {
            world.func_691_b(i, j + 1, k, (l ^ 4) + 8);
        }
        world.func_691_b(i, j, k, l ^ 4);
        world.setBlock(i, j - 1, k, i, j, k);
        if (Math.random() < 0.5) {
            world.playSound((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, "random.door_open", 1.0f, world.field_1037_n.nextFloat() * 0.1f + 0.9f);
        } else {
            world.playSound((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, "random.door_close", 1.0f, world.field_1037_n.nextFloat() * 0.1f + 0.9f);
        }
        return true;
    }

    public void func_311_a(World world, int i, int j, int k, boolean flag) {
        boolean flag1;
        int l = world.getBlockSomethingIDK(i, j, k);
        if ((l & 8) != 0) {
            if (world.getBlock(i, j - 1, k) == this.blockID) {
                this.func_311_a(world, i, j - 1, k, flag);
            }
            return;
        }
        boolean bl = flag1 = (world.getBlockSomethingIDK(i, j, k) & 4) > 0;
        if (flag1 == flag) {
            return;
        }
        if (world.getBlock(i, j + 1, k) == this.blockID) {
            world.func_691_b(i, j + 1, k, (l ^ 4) + 8);
        }
        world.func_691_b(i, j, k, l ^ 4);
        world.setBlock(i, j - 1, k, i, j, k);
        if (Math.random() < 0.5) {
            world.playSound((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, "random.door_open", 1.0f, world.field_1037_n.nextFloat() * 0.1f + 0.9f);
        } else {
            world.playSound((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, "random.door_close", 1.0f, world.field_1037_n.nextFloat() * 0.1f + 0.9f);
        }
    }

    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        int i1 = world.getBlockSomethingIDK(i, j, k);
        if ((i1 & 8) != 0) {
            if (world.getBlock(i, j - 1, k) != this.blockID) {
                world.setBlock(i, j, k, 0);
            }
            if (l > 0 && Block.allBlocks[l].func_209_d()) {
                this.onNeighborBlockChange(world, i, j - 1, k, l);
            }
        } else {
            boolean flag = false;
            if (world.getBlock(i, j + 1, k) != this.blockID) {
                world.setBlock(i, j, k, 0);
                flag = true;
            }
            if (!world.isBlockNormalCube(i, j - 1, k)) {
                world.setBlock(i, j, k, 0);
                flag = true;
                if (world.getBlock(i, j + 1, k) == this.blockID) {
                    world.setBlock(i, j + 1, k, 0);
                }
            }
            if (flag) {
                this.func_259_b_(world, i, j, k, i1);
            } else if (l > 0 && Block.allBlocks[l].func_209_d()) {
                boolean flag1 = world.func_625_o(i, j, k) || world.func_625_o(i, j + 1, k);
                this.func_311_a(world, i, j, k, flag1);
            }
        }
    }

    public int createBlockEntity(int i, Random random) {
        if ((i & 8) != 0) {
            return 0;
        }
        if (this.material == Material.iron) {
            return Item.doorSteel.swiftedIndex;
        }
        return Item.doorWood.swiftedIndex;
    }

    public MovingObjectPosition func_255_a(World world, int i, int j, int k, Vec3D vec3d, Vec3D vec3d1) {
        this.func_238_a(world, i, j, k);
        return super.func_255_a(world, i, j, k, vec3d, vec3d1);
    }

    public int func_312_c(int i) {
        if ((i & 4) == 0) {
            return i - 1 & 3;
        }
        return i & 3;
    }

    public boolean canPlace(World world, int i, int j, int k) {
        if (j >= 127) {
            return false;
        }
        return world.isBlockNormalCube(i, j - 1, k) && super.canPlace(world, i, j, k) && super.canPlace(world, i, j + 1, k);
    }
}

