/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.tile.IBlockAccess;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.material.Material;
import com.mojang.minecraft.level.tile.phys.AxisAlignedBB;
import com.mojang.minecraft.render.Vec3D;
import java.util.Random;

public abstract class BlockFluids
extends Block {
    protected int field_458_d = 1;
    protected static boolean isStationary;

    protected BlockFluids(int i, Material material) {
        super(i, (material != Material.lava ? 12 : 14) * 16 + 13, material);
        float f = 0.0f;
        float f1 = 0.0f;
        isStationary = true;
        if (material == Material.lava) {
            this.field_458_d = 2;
        }
        this.setBlockBounds(0.0f + f1, 0.0f + f, 0.0f + f1, 1.0f + f1, 1.0f + f, 1.0f + f1);
        this.setTickRandomly(true);
    }

    public static float getFluidLevel(int i) {
        if (i >= 8) {
            i = 0;
        }
        float f = (float)(i + 1) / 9.0f;
        return f;
    }

    public boolean getIsStationary() {
        return isStationary;
    }

    public int getTextureIndex(int i) {
        if (i < 7 && isStationary || i == 0 || i == 1) {
            return this.textureIndex;
        }
        return this.textureIndex + 1;
    }

    protected int func_290_h(World world, int i, int j, int k) {
        if (world.getMaterialXYZ(i, j, k) != this.material) {
            return -1;
        }
        return world.getBlockSomethingIDK(i, j, k);
    }

    protected int func_289_b(IBlockAccess iblockaccess, int i, int j, int k) {
        if (iblockaccess.getMaterialXYZ(i, j, k) != this.material) {
            return -1;
        }
        int l = iblockaccess.getBlockSomethingIDK(i, j, k);
        if (l >= 8) {
            l = 0;
        }
        return l;
    }

    public boolean func_242_c() {
        return false;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean func_224_a(int i, boolean flag) {
        return flag && i == 0;
    }

    public boolean isVertexInBlock(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        Material material = iblockaccess.getMaterialXYZ(i, j, k);
        if (material == this.material) {
            return false;
        }
        if (material == Material.ice) {
            return false;
        }
        if (l == 1) {
            return true;
        }
        return super.isVertexInBlock(iblockaccess, i, j, k, l);
    }

    public AxisAlignedBB func_221_d(World world, int i, int j, int k) {
        return null;
    }

    public int getRenderType() {
        return 4;
    }

    public int createBlockEntity(int i, Random random) {
        return 0;
    }

    public int dropChance(Random random) {
        return 0;
    }

    private Vec3D getFlowDirectionVector(IBlockAccess iblockaccess, int i, int j, int k) {
        Vec3D vec3d = Vec3D.newVectorAndAddToPool(0.0, 0.0, 0.0);
        int l = this.func_289_b(iblockaccess, i, j, k);
        int i1 = 0;
        while (i1 < 4) {
            int i2;
            int j1 = i;
            int k1 = j;
            int l1 = k;
            if (i1 == 0) {
                --j1;
            }
            if (i1 == 1) {
                --l1;
            }
            if (i1 == 2) {
                ++j1;
            }
            if (i1 == 3) {
                ++l1;
            }
            if ((i2 = this.func_289_b(iblockaccess, j1, k1, l1)) < 0) {
                if (!iblockaccess.getMaterialXYZ(j1, k1, l1).blocksMovement() && (i2 = this.func_289_b(iblockaccess, j1, k1 - 1, l1)) >= 0) {
                    int j2 = i2 - (l - 8);
                    vec3d = vec3d.addToVector((j1 - i) * j2, (k1 - j) * j2, (l1 - k) * j2);
                }
            } else if (i2 >= 0) {
                int k2 = i2 - l;
                vec3d = vec3d.addToVector((j1 - i) * k2, (k1 - j) * k2, (l1 - k) * k2);
            }
            ++i1;
        }
        if (iblockaccess.getBlockSomethingIDK(i, j, k) >= 8) {
            boolean flag = false;
            if (flag || this.isVertexInBlock(iblockaccess, i, j, k - 1, 2)) {
                flag = true;
            }
            if (flag || this.isVertexInBlock(iblockaccess, i, j, k + 1, 3)) {
                flag = true;
            }
            if (flag || this.isVertexInBlock(iblockaccess, i - 1, j, k, 4)) {
                flag = true;
            }
            if (flag || this.isVertexInBlock(iblockaccess, i + 1, j, k, 5)) {
                flag = true;
            }
            if (flag || this.isVertexInBlock(iblockaccess, i, j + 1, k - 1, 2)) {
                flag = true;
            }
            if (flag || this.isVertexInBlock(iblockaccess, i, j + 1, k + 1, 3)) {
                flag = true;
            }
            if (flag || this.isVertexInBlock(iblockaccess, i - 1, j + 1, k, 4)) {
                flag = true;
            }
            if (flag || this.isVertexInBlock(iblockaccess, i + 1, j + 1, k, 5)) {
                flag = true;
            }
            if (flag) {
                vec3d = vec3d.func_1252_b().addToVector(0.0, -6.0, 0.0);
            }
        }
        vec3d = vec3d.func_1252_b();
        return vec3d;
    }

    public void func_257_a(World world, int i, int j, int k, Entity entity, Vec3D vec3d) {
        Vec3D vec3d1 = this.getFlowDirectionVector(world, i, j, k);
        vec3d.xCoord += vec3d1.xCoord;
        vec3d.yCoord += vec3d1.yCoord;
        vec3d.zCoord += vec3d1.zCoord;
    }

    public int func_206_a() {
        if (this.material == Material.water) {
            return 5;
        }
        return this.material != Material.lava ? 0 : 30;
    }

    public float func_241_c(IBlockAccess iblockaccess, int i, int j, int k) {
        float f1;
        float f = iblockaccess.func_598_c(i, j, k);
        return f <= (f1 = iblockaccess.func_598_c(i, j + 1, k)) ? f1 : f;
    }

    public void update(World world, int i, int j, int k, Random random) {
        super.update(world, i, j, k, random);
    }

    public int func_234_g() {
        return this.material != Material.water ? 0 : 1;
    }

    public void func_247_b(World world, int i, int j, int k, Random random) {
        int l;
        if (this.material == Material.water && random.nextInt(64) == 0 && (l = world.getBlockSomethingIDK(i, j, k)) > 0 && l < 8) {
            world.playSound((float)i + 0.5f, (float)j + 0.5f, (float)k + 0.5f, "liquid.water", random.nextFloat() * 0.25f + 0.75f, random.nextFloat() * 1.0f + 0.5f);
        }
        if (this.material == Material.lava && world.getMaterialXYZ(i, j + 1, k) == Material.air && !world.isBlockNormalCube(i, j + 1, k) && random.nextInt(100) == 0) {
            double d = (float)i + random.nextFloat();
            double d1 = (double)j + this.blockBound4;
            double d2 = (float)k + random.nextFloat();
            world.func_694_a("liquid", d, d1, d2, 0.0, 0.0, 0.0);
            int l2 = world.getBlockSomethingIDK(i, j, k);
            if (l2 > 0 && l2 < 8) {
                world.playSound((float)i + 0.5f, (float)j + 0.5f, (float)k + 0.5f, "liquid.lava", random.nextFloat() * 0.25f + 0.75f, random.nextFloat() * 1.0f + 0.5f);
            }
        }
    }

    public static double getFlowDirectionRadians(IBlockAccess iblockaccess, int i, int j, int k, Material material) {
        Vec3D vec3d = null;
        if (material == Material.water) {
            vec3d = ((BlockFluids)Block.waterMoving).getFlowDirectionVector(iblockaccess, i, j, k);
        }
        if (material == Material.lava) {
            vec3d = ((BlockFluids)Block.lavaMoving).getFlowDirectionVector(iblockaccess, i, j, k);
        }
        if (vec3d.xCoord == 0.0 && vec3d.zCoord == 0.0) {
            isStationary = true;
            return -1000.0;
        }
        isStationary = false;
        return Math.atan2(vec3d.zCoord, vec3d.xCoord) - 1.5707963267948966;
    }

    public void onPlace(World world, int i, int j, int k) {
        this.func_287_j(world, i, j, k);
    }

    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        this.func_287_j(world, i, j, k);
    }

    private void func_287_j(World world, int i, int j, int k) {
        if (world.getBlock(i, j, k) != this.blockID) {
            return;
        }
        if (this.material == Material.lava) {
            boolean flag = false;
            if (flag || world.getMaterialXYZ(i, j, k - 1) == Material.water) {
                flag = true;
            }
            if (flag || world.getMaterialXYZ(i, j, k + 1) == Material.water) {
                flag = true;
            }
            if (flag || world.getMaterialXYZ(i - 1, j, k) == Material.water) {
                flag = true;
            }
            if (flag || world.getMaterialXYZ(i + 1, j, k) == Material.water) {
                flag = true;
            }
            if (flag || world.getMaterialXYZ(i, j + 1, k) == Material.water) {
                flag = true;
            }
            if (flag) {
                int l = world.getBlockSomethingIDK(i, j, k);
                if (l == 0) {
                    world.setBlock(i, j, k, Block.obsidian.blockID);
                } else if (l <= 4) {
                    world.setBlock(i, j, k, Block.cobblestone.blockID);
                }
                this.func_292_i(world, i, j, k);
            }
        }
    }

    protected void func_292_i(World world, int i, int j, int k) {
        world.playSound((float)i + 0.5f, (float)j + 0.5f, (float)k + 0.5f, "random.fizz", 0.5f, 2.6f + (world.field_1037_n.nextFloat() - world.field_1037_n.nextFloat()) * 0.8f);
        int l = 0;
        while (l < 8) {
            world.func_694_a("largesmoke", (double)i + Math.random(), (double)j + 1.2, (double)k + Math.random(), 0.0, 0.0, 0.0);
            ++l;
        }
    }
}

