/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityItem;
import com.mojang.minecraft.entity.item.Item;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.BlockLeavesBase;
import com.mojang.minecraft.level.tile.material.Material;
import java.util.Random;

public class BlockLeaves
extends BlockLeavesBase {
    public static final int radius = 4;
    private int field_463_b;

    protected BlockLeaves(int i, int j) {
        super(i, j, Material.leaves, false);
        this.field_463_b = j;
        this.setTickRandomly(true);
    }

    public boolean getConnectLog(World world, int x, int y, int z) {
        int x1 = x - 4;
        while (x1 <= x + 4) {
            int z1 = z - 4;
            while (z1 <= z + 4) {
                int y1 = y - 4;
                while (y1 <= y + 4) {
                    if (world.getBlock(x1, y1, z1) == Block.wood.blockID) {
                        return true;
                    }
                    ++y1;
                }
                ++z1;
            }
            ++x1;
        }
        return false;
    }

    public void update(World world, int i, int j, int k, Random random) {
        if (!this.getConnectLog(world, i, j, k)) {
            EntityItem entityitem;
            world.setBlock(i, j, k, 0);
            if (random.nextInt(10) == 0) {
                entityitem = new EntityItem(world, i, j, k, new ItemStack(Block.sapling));
                entityitem.field_805_c = 10;
                world.addNewEntity(entityitem);
            }
            if (random.nextInt(128) == 0) {
                entityitem = new EntityItem(world, i, j, k, new ItemStack(Item.appleRed));
                entityitem.field_805_c = 10;
                world.addNewEntity(entityitem);
            }
            if (random.nextInt(10000) == 0) {
                entityitem = new EntityItem(world, i, j, k, new ItemStack(Item.appleGold));
                entityitem.field_805_c = 10;
                world.addNewEntity(entityitem);
            }
        }
    }

    public int createBlockEntity(int i, Random random) {
        return 0;
    }

    public void onBreak(World world, int i, int j, int k, int l) {
        EntityItem entityitem;
        super.onBreak(world, i, j, k, l);
        Random random = new Random();
        if (random.nextInt(10) == 0) {
            entityitem = new EntityItem(world, i, j, k, new ItemStack(Block.sapling));
            entityitem.field_805_c = 10;
            world.addNewEntity(entityitem);
        }
        if (random.nextInt(128) == 0) {
            entityitem = new EntityItem(world, i, j, k, new ItemStack(Item.appleRed));
            entityitem.field_805_c = 10;
            world.addNewEntity(entityitem);
        }
        if (random.nextInt(10000) == 0) {
            entityitem = new EntityItem(world, i, j, k, new ItemStack(Item.appleGold));
            entityitem.field_805_c = 10;
            world.addNewEntity(entityitem);
        }
    }

    public void func_310_a(boolean flag) {
        this.field_462_a = flag;
        this.textureIndex = this.field_463_b + (flag ? 0 : 1);
    }

    public void func_254_a(World world, int i, int j, int k, Entity entity) {
        super.func_254_a(world, i, j, k, entity);
    }
}

