/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.entity.item.Item;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.material.Material;
import com.mojang.minecraft.level.tile.phys.AxisAlignedBB;
import java.util.Random;

public class BlockReed
extends Block {
    protected BlockReed(int i, int j) {
        super(i, Material.plants);
        this.textureIndex = j;
        float f = 0.375f;
        this.setBlockBounds(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, 1.0f, 0.5f + f);
        this.setTickRandomly(true);
    }

    public void update(World world, int i, int j, int k, Random random) {
        if (world.getBlock(i, j + 1, k) == 0) {
            int l = 1;
            while (world.getBlock(i, j - l, k) == this.blockID) {
                ++l;
            }
            if (l < 3) {
                int i1 = world.getBlockSomethingIDK(i, j, k);
                if (i1 == 15) {
                    world.setBlock(i, j + 1, k, this.blockID);
                    world.func_691_b(i, j, k, 0);
                } else {
                    world.func_691_b(i, j, k, i1 + 1);
                }
            }
        }
    }

    public boolean canPlace(World world, int i, int j, int k) {
        int l = world.getBlock(i, j - 1, k);
        if (l == this.blockID) {
            return true;
        }
        if (l != Block.grass.blockID && l != Block.dirt.blockID) {
            return false;
        }
        if (world.getMaterialXYZ(i - 1, j - 1, k) == Material.water) {
            return true;
        }
        if (world.getMaterialXYZ(i + 1, j - 1, k) == Material.water) {
            return true;
        }
        if (world.getMaterialXYZ(i, j - 1, k - 1) == Material.water) {
            return true;
        }
        return world.getMaterialXYZ(i, j - 1, k + 1) == Material.water;
    }

    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        this.func_303_h(world, i, j, k);
    }

    protected final void func_303_h(World world, int i, int j, int k) {
        if (!this.canBlockStay(world, i, j, k)) {
            this.func_259_b_(world, i, j, k, world.getBlockSomethingIDK(i, j, k));
            world.setBlock(i, j, k, 0);
        }
    }

    public boolean canBlockStay(World world, int i, int j, int k) {
        return this.canPlace(world, i, j, k);
    }

    public AxisAlignedBB func_221_d(World world, int i, int j, int k) {
        return null;
    }

    public int createBlockEntity(int i, Random random) {
        return Item.reed.swiftedIndex;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean func_242_c() {
        return false;
    }

    public int getRenderType() {
        return 1;
    }
}

