/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.network.packet;

import com.mojang.minecraft.network.NetHandler;
import com.mojang.minecraft.network.packet.Packet0KeepAlive;
import com.mojang.minecraft.network.packet.Packet10Flying;
import com.mojang.minecraft.network.packet.Packet11PlayerPosition;
import com.mojang.minecraft.network.packet.Packet12PlayerLook;
import com.mojang.minecraft.network.packet.Packet13PlayerLookMove;
import com.mojang.minecraft.network.packet.Packet14BlockDig;
import com.mojang.minecraft.network.packet.Packet15Place;
import com.mojang.minecraft.network.packet.Packet16BlockItemSwitch;
import com.mojang.minecraft.network.packet.Packet17AddToInventory;
import com.mojang.minecraft.network.packet.Packet18ArmAnimation;
import com.mojang.minecraft.network.packet.Packet1Login;
import com.mojang.minecraft.network.packet.Packet20NamedEntitySpawn;
import com.mojang.minecraft.network.packet.Packet21PickupSpawn;
import com.mojang.minecraft.network.packet.Packet22Collect;
import com.mojang.minecraft.network.packet.Packet23VehicleSpawn;
import com.mojang.minecraft.network.packet.Packet24MobSpawn;
import com.mojang.minecraft.network.packet.Packet255KickDisconnect;
import com.mojang.minecraft.network.packet.Packet29DestroyEntity;
import com.mojang.minecraft.network.packet.Packet2Handshake;
import com.mojang.minecraft.network.packet.Packet30Entity;
import com.mojang.minecraft.network.packet.Packet31RelEntityMove;
import com.mojang.minecraft.network.packet.Packet32EntityLook;
import com.mojang.minecraft.network.packet.Packet33RelEntityMoveLook;
import com.mojang.minecraft.network.packet.Packet34EntityTeleport;
import com.mojang.minecraft.network.packet.Packet3Chat;
import com.mojang.minecraft.network.packet.Packet4UpdateTime;
import com.mojang.minecraft.network.packet.Packet50PreChunk;
import com.mojang.minecraft.network.packet.Packet51MapChunk;
import com.mojang.minecraft.network.packet.Packet52MultiBlockChange;
import com.mojang.minecraft.network.packet.Packet53BlockChange;
import com.mojang.minecraft.network.packet.Packet59ComplexEntity;
import com.mojang.minecraft.network.packet.Packet5PlayerInventory;
import com.mojang.minecraft.network.packet.Packet60HurtEntity;
import com.mojang.minecraft.network.packet.Packet61PlayerHealth;
import com.mojang.minecraft.network.packet.Packet62PlaySound;
import com.mojang.minecraft.network.packet.Packet6SpawnPosition;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Packet {
    private static Map<Integer, Class<?>> packetIdToClassMap = new HashMap();
    private static Map<Class<?>, Integer> packetClassToIdMap = new HashMap();
    public boolean packetBooleanUnknown = false;

    static {
        Packet.registerPacket(0, Packet0KeepAlive.class);
        Packet.registerPacket(1, Packet1Login.class);
        Packet.registerPacket(2, Packet2Handshake.class);
        Packet.registerPacket(3, Packet3Chat.class);
        Packet.registerPacket(4, Packet4UpdateTime.class);
        Packet.registerPacket(5, Packet5PlayerInventory.class);
        Packet.registerPacket(6, Packet6SpawnPosition.class);
        Packet.registerPacket(10, Packet10Flying.class);
        Packet.registerPacket(11, Packet11PlayerPosition.class);
        Packet.registerPacket(12, Packet12PlayerLook.class);
        Packet.registerPacket(13, Packet13PlayerLookMove.class);
        Packet.registerPacket(14, Packet14BlockDig.class);
        Packet.registerPacket(15, Packet15Place.class);
        Packet.registerPacket(16, Packet16BlockItemSwitch.class);
        Packet.registerPacket(17, Packet17AddToInventory.class);
        Packet.registerPacket(18, Packet18ArmAnimation.class);
        Packet.registerPacket(20, Packet20NamedEntitySpawn.class);
        Packet.registerPacket(21, Packet21PickupSpawn.class);
        Packet.registerPacket(22, Packet22Collect.class);
        Packet.registerPacket(23, Packet23VehicleSpawn.class);
        Packet.registerPacket(24, Packet24MobSpawn.class);
        Packet.registerPacket(29, Packet29DestroyEntity.class);
        Packet.registerPacket(30, Packet30Entity.class);
        Packet.registerPacket(31, Packet31RelEntityMove.class);
        Packet.registerPacket(32, Packet32EntityLook.class);
        Packet.registerPacket(33, Packet33RelEntityMoveLook.class);
        Packet.registerPacket(34, Packet34EntityTeleport.class);
        Packet.registerPacket(50, Packet50PreChunk.class);
        Packet.registerPacket(51, Packet51MapChunk.class);
        Packet.registerPacket(52, Packet52MultiBlockChange.class);
        Packet.registerPacket(53, Packet53BlockChange.class);
        Packet.registerPacket(59, Packet59ComplexEntity.class);
        Packet.registerPacket(60, Packet60HurtEntity.class);
        Packet.registerPacket(61, Packet61PlayerHealth.class);
        Packet.registerPacket(62, Packet62PlaySound.class);
        Packet.registerPacket(255, Packet255KickDisconnect.class);
    }

    static void registerPacket(int i, Class<?> class1) {
        if (packetIdToClassMap.containsKey(i)) {
            throw new IllegalArgumentException("Duplicate packet id:" + i);
        }
        if (packetClassToIdMap.containsKey(class1)) {
            throw new IllegalArgumentException("Duplicate packet class:" + class1);
        }
        packetIdToClassMap.put(i, class1);
        packetClassToIdMap.put(class1, i);
    }

    public static Packet verifyId(int i) {
        Class<?> class1;
        block3: {
            try {
                class1 = packetIdToClassMap.get(i);
                if (class1 != null) break block3;
                return null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.out.println("Skipping packet with id " + i);
                return null;
            }
        }
        return (Packet)class1.newInstance();
    }

    public final int getId() {
        return packetClassToIdMap.get(this.getClass());
    }

    public static Packet onBaseIncoming(DataInputStream datainputstream) throws IOException {
        int i = datainputstream.read();
        if (i == -1) {
            return null;
        }
        Packet packet = Packet.verifyId(i);
        if (packet == null) {
            throw new IOException("Bad packet id " + i);
        }
        packet.onIncoming(datainputstream);
        return packet;
    }

    public static void sendToOutput(Packet packet, DataOutputStream dataoutputstream) throws IOException {
        dataoutputstream.write(packet.getId());
        packet.onOutgoing(dataoutputstream);
    }

    public abstract void onIncoming(DataInputStream var1) throws IOException;

    public abstract void onOutgoing(DataOutputStream var1) throws IOException;

    public abstract void handlePacket(NetHandler var1);

    public abstract int packetFunctionUnknown();

    static Class<?> _mthclass$(String s) {
        try {
            return Class.forName(s);
        }
        catch (ClassNotFoundException classnotfoundexception) {
            throw new NoClassDefFoundError(classnotfoundexception.getMessage());
        }
    }
}

