/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.player.controller;

import com.mojang.minecraft.Minecraft;
import com.mojang.minecraft.player.controller.KeyBinding;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import org.lwjgl.input.Keyboard;

public class GameSettings {
    private static final String[] RENDER_DISTANCES = new String[]{"FAR", "NORMAL", "SHORT", "TINY"};
    private static final String[] DIFFICULTY_LEVELS = new String[]{"Peaceful", "Easy", "Normal", "Hard"};
    public String lastServer;
    public float musicVolume = 1.0f;
    public float soundVolume = 1.0f;
    public float mouseSensitivity = 0.5f;
    public boolean invertMouse = false;
    public int renderDistance = 0;
    public boolean viewBobbing = true;
    public boolean anaglyph = false;
    public boolean limitFramerate = false;
    public boolean fancyGraphics = true;
    public KeyBinding keyBindForward;
    public KeyBinding keyBindLeft;
    public KeyBinding keyBindBack;
    public KeyBinding keyBindRight;
    public KeyBinding keyBindJump;
    public KeyBinding keyBindInventory;
    public KeyBinding keyBindDrop;
    public KeyBinding keyBindChat;
    public KeyBinding keyBindToggleFog;
    public KeyBinding keyBindSneak;
    public KeyBinding keyBindRun;
    public KeyBinding keyBindSaveLocation;
    public KeyBinding keyBindLoadLocation;
    public KeyBinding[] keyBindings;
    protected Minecraft mc;
    private File optionsFile;
    public int numberOfOptions;
    public int difficulty;
    public int BigTreePercentage;
    public boolean thirdPersonView;
    public boolean fog = true;
    public boolean clouds = true;
    public boolean fastRender = true;

    public GameSettings(Minecraft minecraft, File file) {
        this.lastServer = "";
        this.keyBindForward = new KeyBinding("Forward", 17);
        this.keyBindLeft = new KeyBinding("Left", 30);
        this.keyBindBack = new KeyBinding("Back", 31);
        this.keyBindRight = new KeyBinding("Right", 32);
        this.keyBindJump = new KeyBinding("Jump", 57);
        this.keyBindInventory = new KeyBinding("Inventory", 18);
        this.keyBindDrop = new KeyBinding("Drop", 16);
        this.keyBindChat = new KeyBinding("Chat", 20);
        this.keyBindToggleFog = new KeyBinding("Toggle fog", 33);
        this.keyBindSneak = new KeyBinding("Sneak", 42);
        this.keyBindRun = new KeyBinding("Run", 29);
        this.keyBindSaveLocation = new KeyBinding("Save Location", 28);
        this.keyBindLoadLocation = new KeyBinding("Load Location", 19);
        this.keyBindings = new KeyBinding[]{this.keyBindForward, this.keyBindLeft, this.keyBindBack, this.keyBindRight, this.keyBindJump, this.keyBindSneak, this.keyBindDrop, this.keyBindInventory, this.keyBindChat, this.keyBindToggleFog, this.keyBindRun, this.keyBindSaveLocation, this.keyBindLoadLocation};
        this.numberOfOptions = 10;
        this.difficulty = 2;
        this.thirdPersonView = false;
        this.mc = minecraft;
        this.optionsFile = new File(file, "optionsNSSS.txt");
        this.readOptions();
    }

    public GameSettings() {
        this.keyBindForward = new KeyBinding("Forward", 17);
        this.keyBindLeft = new KeyBinding("Left", 30);
        this.keyBindBack = new KeyBinding("Back", 31);
        this.keyBindRight = new KeyBinding("Right", 32);
        this.keyBindJump = new KeyBinding("Jump", 57);
        this.keyBindInventory = new KeyBinding("Inventory", 18);
        this.keyBindDrop = new KeyBinding("Drop", 16);
        this.keyBindChat = new KeyBinding("Chat", 20);
        this.keyBindToggleFog = new KeyBinding("Toggle fog", 33);
        this.keyBindSneak = new KeyBinding("Sneak", 42);
        this.keyBindRun = new KeyBinding("Run", 29);
        this.keyBindSaveLocation = new KeyBinding("Save Location", 28);
        this.keyBindLoadLocation = new KeyBinding("Load Location", 19);
        this.keyBindings = new KeyBinding[]{this.keyBindForward, this.keyBindLeft, this.keyBindBack, this.keyBindRight, this.keyBindJump, this.keyBindSneak, this.keyBindDrop, this.keyBindInventory, this.keyBindChat, this.keyBindToggleFog, this.keyBindRun, this.keyBindSaveLocation, this.keyBindLoadLocation};
        this.numberOfOptions = 10;
        this.difficulty = 2;
        this.thirdPersonView = false;
    }

    public String func_1043_a(int i) {
        return this.keyBindings[i].keyDescription + ": " + Keyboard.getKeyName((int)this.keyBindings[i].keyCode);
    }

    public void func_1042_a(int i, int j) {
        this.keyBindings[i].keyCode = j;
        this.save();
    }

    public void func_1048_a(int i, float f) {
        if (i == 0) {
            this.musicVolume = f;
            this.mc.field_158_A.func_335_a();
        }
        if (i == 1) {
            this.soundVolume = f;
            this.mc.field_158_A.func_335_a();
        }
        if (i == 3) {
            this.mouseSensitivity = f;
        }
    }

    public void func_1045_b(int i, int j) {
        if (i == 2) {
            boolean bl = this.invertMouse = !this.invertMouse;
        }
        if (i == 4) {
            this.renderDistance += j;
            if (this.renderDistance > 3) {
                this.renderDistance = 0;
            } else if (this.renderDistance < 0) {
                this.renderDistance = 3;
            }
        }
        if (i == 5) {
            boolean bl = this.viewBobbing = !this.viewBobbing;
        }
        if (i == 6) {
            this.anaglyph = !this.anaglyph;
            this.mc.field_171_n.func_1065_b();
        }
        if (i == 7) {
            boolean bl = this.limitFramerate = !this.limitFramerate;
        }
        if (i == 8) {
            this.difficulty = this.difficulty + j & 3;
        }
        if (i == 9) {
            this.fancyGraphics = !this.fancyGraphics;
            this.mc.field_179_f.func_958_a();
        }
        if (i == 101) {
            boolean bl = this.clouds = !this.clouds;
        }
        if (i == 100) {
            this.fog = !this.fog;
        }
        this.save();
    }

    public int func_1046_b(int i) {
        if (i == 0) {
            return 1;
        }
        if (i == 1) {
            return 1;
        }
        return i != 3 ? 0 : 1;
    }

    public float sliderType(int i) {
        if (i == 0) {
            return this.musicVolume;
        }
        if (i == 1) {
            return this.soundVolume;
        }
        if (i == 3) {
            return this.mouseSensitivity;
        }
        if (i == 5) {
            return this.BigTreePercentage;
        }
        return 0.0f;
    }

    public String getOptionValue(int i) {
        if (i == 0) {
            return "Music: " + (this.musicVolume <= 0.0f ? "OFF" : (int)(this.musicVolume * 100.0f) + "%");
        }
        if (i == 1) {
            return "Sound: " + (this.soundVolume <= 0.0f ? "OFF" : (int)(this.soundVolume * 100.0f) + "%");
        }
        if (i == 2) {
            return "Invert mouse: " + (this.invertMouse ? "ON" : "OFF");
        }
        if (i == 3) {
            if (this.mouseSensitivity == 0.0f) {
                return "Sensitivity: *yawn*";
            }
            if (this.mouseSensitivity == 1.0f) {
                return "Sensitivity: HYPERSPEED!!!";
            }
            return "Sensitivity: " + (int)(this.mouseSensitivity * 200.0f) + "%";
        }
        if (i == 4) {
            if (this.renderDistance >= 0 && this.renderDistance <= 4) {
                return "Render distance: " + RENDER_DISTANCES[this.renderDistance];
            }
            this.renderDistance = 1;
            return "Render distance: " + RENDER_DISTANCES[this.renderDistance];
        }
        if (i == 5) {
            return "View bobbing: " + (this.viewBobbing ? "ON" : "OFF");
        }
        if (i == 6) {
            return "3d anaglyph: " + (this.anaglyph ? "ON" : "OFF");
        }
        if (i == 7) {
            return "Limit framerate: " + (this.limitFramerate ? "ON" : "OFF");
        }
        if (i == 8) {
            return "Difficulty: " + DIFFICULTY_LEVELS[this.difficulty];
        }
        if (i == 10) {
            return "BigTree Percentage: " + this.BigTreePercentage;
        }
        if (i == 100) {
            return "Fog: " + (this.fog ? "ON" : "OFF");
        }
        if (i == 101) {
            return "Clouds: " + (this.clouds ? "ON" : "OFF");
        }
        if (i == 102) {
            return "FastRender: " + (this.fastRender ? "ON" : "OFF");
        }
        if (i == 9) {
            return "Graphics: " + (this.fancyGraphics ? "FANCY" : "FAST");
        }
        return "";
    }

    public void readOptions() {
        try {
            if (!this.optionsFile.exists()) {
                return;
            }
            BufferedReader bufferedreader = new BufferedReader(new FileReader(this.optionsFile));
            String s = "";
            while ((s = bufferedreader.readLine()) != null) {
                String[] as = s.split(":");
                if (as[0].equals("music")) {
                    this.musicVolume = this.func_1050_a(as[1]);
                }
                if (as[0].equals("sound")) {
                    this.soundVolume = this.func_1050_a(as[1]);
                }
                if (as[0].equals("mouseSensitivity")) {
                    this.mouseSensitivity = this.func_1050_a(as[1]);
                }
                if (as[0].equals("invertYMouse")) {
                    this.invertMouse = as[1].equals("true");
                }
                if (as[0].equals("viewDistance")) {
                    this.renderDistance = Integer.parseInt(as[1]);
                }
                if (as[0].equals("bobView")) {
                    this.viewBobbing = as[1].equals("true");
                }
                if (as[0].equals("anaglyph3d")) {
                    this.anaglyph = as[1].equals("true");
                }
                if (as[0].equals("limitFramerate")) {
                    this.limitFramerate = as[1].equals("true");
                }
                if (as[0].equals("difficulty")) {
                    this.difficulty = Integer.parseInt(as[1]);
                }
                if (as[0].equals("fancyGraphics")) {
                    this.fancyGraphics = as[1].equals("true");
                }
                if (as[0].equals("lastServer") && as.length > 1) {
                    this.lastServer = as[1];
                }
                if (as[0].equals("fog")) {
                    this.fog = as[1].equals("true");
                }
                if (as[0].equals("Clouds")) {
                    this.clouds = as[1].equals("true");
                }
                if (as[0].equals("fastRender")) {
                    this.fastRender = as[1].equals("true");
                }
                int i = 0;
                while (i < this.keyBindings.length) {
                    if (as[0].equals("key_" + this.keyBindings[i].keyDescription)) {
                        this.keyBindings[i].keyCode = Integer.parseInt(as[1]);
                    }
                    ++i;
                }
            }
            bufferedreader.close();
        }
        catch (Exception exception) {
            System.out.println("Failed to load options");
            exception.printStackTrace();
        }
    }

    private float func_1050_a(String s) {
        if (s.equals("true")) {
            return 1.0f;
        }
        if (s.equals("false")) {
            return 0.0f;
        }
        return Float.parseFloat(s);
    }

    public void save() {
        try {
            PrintWriter printwriter = new PrintWriter(new FileWriter(this.optionsFile));
            printwriter.println("music:" + this.musicVolume);
            printwriter.println("sound:" + this.soundVolume);
            printwriter.println("invertYMouse:" + this.invertMouse);
            printwriter.println("mouseSensitivity:" + this.mouseSensitivity);
            printwriter.println("viewDistance:" + this.renderDistance);
            printwriter.println("bobView:" + this.viewBobbing);
            printwriter.println("anaglyph3d:" + this.anaglyph);
            printwriter.println("limitFramerate:" + this.limitFramerate);
            printwriter.println("difficulty:" + this.difficulty);
            printwriter.println("fancyGraphics:" + this.fancyGraphics);
            printwriter.println(new StringBuilder().append("lastServer:").append(this.lastServer));
            printwriter.println("fog:" + this.fog);
            printwriter.println("Clouds:" + this.clouds);
            printwriter.println("fastRender:" + this.fastRender);
            int i = 0;
            while (i < this.keyBindings.length) {
                printwriter.println("key_" + this.keyBindings[i].keyDescription + ":" + this.keyBindings[i].keyCode);
                ++i;
            }
            printwriter.close();
        }
        catch (Exception exception) {
            System.out.println("Failed to save options");
            exception.printStackTrace();
        }
    }
}

