/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.render;

import com.mojang.minecraft.Minecraft;
import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityBubbleFX;
import com.mojang.minecraft.entity.EntityExplodeFX;
import com.mojang.minecraft.entity.EntityFlameFX;
import com.mojang.minecraft.entity.EntityLavaFX;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.EntityPlayerSP;
import com.mojang.minecraft.entity.EntityReddustFX;
import com.mojang.minecraft.entity.EntitySlimeFX;
import com.mojang.minecraft.entity.EntitySmokeFX;
import com.mojang.minecraft.entity.EntitySorter;
import com.mojang.minecraft.entity.EntitySplashFX;
import com.mojang.minecraft.entity.MovingObjectPosition;
import com.mojang.minecraft.entity.item.Item;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.entity.tile.TileEntity;
import com.mojang.minecraft.entity.tile.TileEntityRenderer;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.phys.AxisAlignedBB;
import com.mojang.minecraft.render.GLAllocation;
import com.mojang.minecraft.render.ICamera;
import com.mojang.minecraft.render.IWorldAccess;
import com.mojang.minecraft.render.ImageBufferDownload;
import com.mojang.minecraft.render.RenderBlocks;
import com.mojang.minecraft.render.RenderEngine;
import com.mojang.minecraft.render.RenderList;
import com.mojang.minecraft.render.RenderManager;
import com.mojang.minecraft.render.RenderSorter;
import com.mojang.minecraft.render.Tessellator;
import com.mojang.minecraft.render.Vec3D;
import com.mojang.minecraft.render.WorldRenderer;
import com.mojang.minecraft.util.MathHelper;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.ARBOcclusionQuery;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;

public class RenderGlobal
implements IWorldAccess {
    public List<TileEntity> field_1458_a;
    private World field_1448_k;
    private RenderEngine renderEngine;
    private List<WorldRenderer> worldRenderersToUpdate;
    private WorldRenderer[] field_1445_n;
    private WorldRenderer[] field_1444_o;
    private int d;
    private int field_1443_p;
    private int field_1442_q;
    private int field_1441_r;
    private int field_1440_s;
    private Minecraft field_1439_t;
    private RenderBlocks field_1438_u;
    private IntBuffer field_1437_v;
    private boolean occlusionEnabled = false;
    private int field_1435_x = 0;
    private int field_1434_y;
    private int field_1433_z;
    private int field_1432_A;
    private int field_1431_B;
    private int field_1430_C;
    private int field_1429_D;
    private int field_1428_E;
    private int field_1427_F;
    private int field_1426_G;
    private int renDist = -1;
    private int field_1424_I = 2;
    private int field_1423_J;
    private int field_1422_K;
    private int occludedEntities;
    int[] field_1457_b = null;
    IntBuffer occlusionResult;
    private int field_1420_M;
    private int outsideFrustrum;
    private int occluded;
    private int chunkRendered;
    private int field_1416_Q;
    private List<WorldRenderer> visibleRenderers;
    private RenderList[] field_1414_S = new RenderList[]{new RenderList(), new RenderList(), new RenderList(), new RenderList()};
    int field_1455_d = 0;
    int field_1454_e;
    double field_1453_f = -9999.0;
    double field_1452_g = -9999.0;
    double field_1451_h = -9999.0;
    public float field_1450_i;
    int field_1449_j = 0;
    FloatBuffer floatBuffer;
    boolean texClouds = true;
    float cloudHeight = 108.0f;

    public RenderGlobal(Minecraft minecraft, RenderEngine renderengine) {
        this.d = GL11.glGenLists((int)2);
        this.field_1458_a = new ArrayList<TileEntity>();
        this.worldRenderersToUpdate = new ArrayList<WorldRenderer>();
        this.occlusionResult = GLAllocation.func_1125_c(64);
        this.visibleRenderers = new ArrayList<WorldRenderer>();
        this.field_1454_e = GLAllocation.func_1124_a(1);
        this.field_1439_t = minecraft;
        this.renderEngine = renderengine;
        this.floatBuffer = BufferUtils.createFloatBuffer((int)16);
        int byte0 = 64;
        this.field_1440_s = GLAllocation.func_1124_a(byte0 * byte0 * byte0 * 3);
        this.occlusionEnabled = minecraft.func_137_k().func_1213_a();
        if (this.occlusionEnabled) {
            this.occlusionResult.clear();
            this.field_1437_v = GLAllocation.func_1125_c(byte0 * byte0 * byte0);
            this.field_1437_v.clear();
            this.field_1437_v.position(0);
            this.field_1437_v.limit(byte0 * byte0 * byte0);
            ARBOcclusionQuery.glGenQueriesARB((IntBuffer)this.field_1437_v);
        }
        this.field_1434_y = GLAllocation.func_1124_a(3);
        GL11.glPushMatrix();
        GL11.glNewList((int)this.field_1434_y, (int)4864);
        this.func_950_f();
        GL11.glEndList();
        GL11.glPopMatrix();
        Tessellator tessellator = Tessellator.field_1512_a;
        this.field_1433_z = this.field_1434_y + 1;
        GL11.glNewList((int)this.field_1433_z, (int)4864);
        int byte1 = 64;
        int i = 256 / byte1 + 2;
        float f = 16.0f;
        int j = -byte1 * i;
        while (j <= byte1 * i) {
            int l = -byte1 * i;
            while (l <= byte1 * i) {
                tessellator.func_977_b();
                tessellator.func_991_a(j + 0, f, l + 0);
                tessellator.func_991_a(j + byte1, f, l + 0);
                tessellator.func_991_a(j + byte1, f, l + byte1);
                tessellator.func_991_a(j + 0, f, l + byte1);
                tessellator.func_982_a();
                l += byte1;
            }
            j += byte1;
        }
        GL11.glEndList();
        this.field_1432_A = this.field_1434_y + 2;
        GL11.glNewList((int)this.field_1432_A, (int)4864);
        f = -16.0f;
        tessellator.func_977_b();
        int k = -byte1 * i;
        while (k <= byte1 * i) {
            int i1 = -byte1 * i;
            while (i1 <= byte1 * i) {
                tessellator.func_991_a(k + byte1, f, i1 + 0);
                tessellator.func_991_a(k + 0, f, i1 + 0);
                tessellator.func_991_a(k + 0, f, i1 + byte1);
                tessellator.func_991_a(k + byte1, f, i1 + byte1);
                i1 += byte1;
            }
            k += byte1;
        }
        tessellator.func_982_a();
        GL11.glEndList();
    }

    private void func_950_f() {
        Random random = new Random(10842L);
        Tessellator tessellator = Tessellator.field_1512_a;
        tessellator.func_977_b();
        int i = 0;
        while (i < 1500) {
            double d = random.nextFloat() * 2.0f - 1.0f;
            double d1 = random.nextFloat() * 2.0f - 1.0f;
            double d2 = random.nextFloat() * 2.0f - 1.0f;
            double d3 = 0.25f + random.nextFloat() * 0.25f;
            double d4 = d * d + d1 * d1 + d2 * d2;
            if (!(d4 >= 1.0) && !(d4 <= 0.01)) {
                d4 = 1.0 / Math.sqrt(d4);
                double d5 = (d *= d4) * 100.0;
                double d6 = (d1 *= d4) * 100.0;
                double d7 = (d2 *= d4) * 100.0;
                double d8 = Math.atan2(d, d2);
                double d9 = Math.sin(d8);
                double d10 = Math.cos(d8);
                double d11 = Math.atan2(Math.sqrt(d * d + d2 * d2), d1);
                double d12 = Math.sin(d11);
                double d13 = Math.cos(d11);
                double d14 = random.nextDouble() * Math.PI * 2.0;
                double d15 = Math.sin(d14);
                double d16 = Math.cos(d14);
                int j = 0;
                while (j < 4) {
                    double d22;
                    double d17 = 0.0;
                    double d18 = (double)((j & 2) - 1) * d3;
                    double d19 = (double)((j + 1 & 2) - 1) * d3;
                    double d20 = d17;
                    double d21 = d18 * d16 - d19 * d15;
                    double d23 = d22 = d19 * d16 + d18 * d15;
                    double d24 = d21 * d12 + d20 * d13;
                    double d25 = d20 * d12 - d21 * d13;
                    double d26 = d25 * d9 - d23 * d10;
                    double d27 = d24;
                    double d28 = d23 * d9 + d25 * d10;
                    tessellator.func_991_a(d5 + d26, d6 + d27, d7 + d28);
                    ++j;
                }
            }
            ++i;
        }
        tessellator.func_982_a();
    }

    public void func_946_a(World world) {
        this.cloudHeight = world.cloudHeight;
        if (this.field_1448_k != null) {
            this.field_1448_k.func_672_b(this);
        }
        this.field_1453_f = -9999.0;
        this.field_1452_g = -9999.0;
        this.field_1451_h = -9999.0;
        RenderManager.subManager.func_852_a(world);
        this.field_1448_k = world;
        this.field_1438_u = new RenderBlocks(world);
        if (world != null) {
            world.func_613_a(this);
            this.func_958_a();
        }
    }

    public void func_958_a() {
        int j;
        Block.leaves.func_310_a(this.field_1439_t.options.fancyGraphics);
        this.renDist = this.field_1439_t.options.renderDistance;
        if (this.field_1444_o != null) {
            int i = 0;
            while (i < this.field_1444_o.length) {
                this.field_1444_o[i].func_1204_c();
                ++i;
            }
        }
        if ((j = 64 << 3 - this.renDist) > 400) {
            j = 400;
        }
        this.field_1443_p = j / 16 + 1;
        this.field_1442_q = 8;
        this.field_1441_r = j / 16 + 1;
        this.field_1444_o = new WorldRenderer[this.field_1443_p * this.field_1442_q * this.field_1441_r];
        this.field_1445_n = new WorldRenderer[this.field_1443_p * this.field_1442_q * this.field_1441_r];
        int k = 0;
        int l = 0;
        this.field_1431_B = 0;
        this.field_1430_C = 0;
        this.field_1429_D = 0;
        this.field_1428_E = this.field_1443_p;
        this.field_1427_F = this.field_1442_q;
        this.field_1426_G = this.field_1441_r;
        int i1 = 0;
        while (i1 < this.worldRenderersToUpdate.size()) {
            this.worldRenderersToUpdate.get((int)i1).needsUpdate = false;
            ++i1;
        }
        this.worldRenderersToUpdate.clear();
        this.field_1458_a.clear();
        int j1 = 0;
        while (j1 < this.field_1443_p) {
            int k1 = 0;
            while (k1 < this.field_1442_q) {
                int l1 = 0;
                while (l1 < this.field_1441_r) {
                    this.field_1444_o[(l1 * this.field_1442_q + k1) * this.field_1443_p + j1] = new WorldRenderer(this.field_1448_k, this.field_1458_a, j1 * 16, k1 * 16, l1 * 16, 16, this.field_1440_s + k);
                    if (this.occlusionEnabled) {
                        this.field_1444_o[(l1 * this.field_1442_q + k1) * this.field_1443_p + j1].field_1732_z = this.field_1437_v.get(l);
                    }
                    this.field_1444_o[(l1 * this.field_1442_q + k1) * this.field_1443_p + j1].field_1733_y = false;
                    this.field_1444_o[(l1 * this.field_1442_q + k1) * this.field_1443_p + j1].isAnOccludedChunk = true;
                    this.field_1444_o[(l1 * this.field_1442_q + k1) * this.field_1443_p + j1].isInFrustrum = true;
                    this.field_1444_o[(l1 * this.field_1442_q + k1) * this.field_1443_p + j1].chunkIndex = l++;
                    this.field_1444_o[(l1 * this.field_1442_q + k1) * this.field_1443_p + j1].func_1194_f();
                    this.field_1445_n[(l1 * this.field_1442_q + k1) * this.field_1443_p + j1] = this.field_1444_o[(l1 * this.field_1442_q + k1) * this.field_1443_p + j1];
                    this.worldRenderersToUpdate.add(this.field_1444_o[(l1 * this.field_1442_q + k1) * this.field_1443_p + j1]);
                    k += 3;
                    ++l1;
                }
                ++k1;
            }
            ++j1;
        }
        if (this.field_1448_k != null) {
            EntityPlayerSP entityplayersp = this.field_1439_t.player;
            this.func_956_b(MathHelper.floor_double(entityplayersp.posX), MathHelper.floor_double(entityplayersp.posY), MathHelper.floor_double(entityplayersp.posZ));
            Arrays.sort(this.field_1445_n, new EntitySorter(entityplayersp));
        }
        this.field_1424_I = 2;
    }

    public void func_951_a(Vec3D vec3d, ICamera icamera, float f) {
        if (this.field_1424_I > 0) {
            --this.field_1424_I;
            return;
        }
        TileEntityRenderer.field_1554_a.func_1026_a(this.field_1448_k, this.renderEngine, this.field_1439_t.field_170_o, this.field_1439_t.player, f);
        RenderManager.subManager.func_857_a(this.field_1448_k, this.renderEngine, this.field_1439_t.field_170_o, this.field_1439_t.player, this.field_1439_t.options, f);
        this.field_1423_J = 0;
        this.field_1422_K = 0;
        this.occludedEntities = 0;
        EntityPlayerSP entityplayersp = this.field_1439_t.player;
        RenderManager.field_1232_b = entityplayersp.field_638_aI + (entityplayersp.posX - entityplayersp.field_638_aI) * (double)f;
        RenderManager.field_1231_c = entityplayersp.field_637_aJ + (entityplayersp.posY - entityplayersp.field_637_aJ) * (double)f;
        RenderManager.field_1230_d = entityplayersp.field_636_aK + (entityplayersp.posZ - entityplayersp.field_636_aK) * (double)f;
        TileEntityRenderer.field_1553_b = entityplayersp.field_638_aI + (entityplayersp.posX - entityplayersp.field_638_aI) * (double)f;
        TileEntityRenderer.field_1552_c = entityplayersp.field_637_aJ + (entityplayersp.posY - entityplayersp.field_637_aJ) * (double)f;
        TileEntityRenderer.field_1551_d = entityplayersp.field_636_aK + (entityplayersp.posZ - entityplayersp.field_636_aK) * (double)f;
        List<Entity> list = this.field_1448_k.func_658_i();
        this.field_1423_J = list.size();
        int i = 0;
        while (i < list.size()) {
            Entity entity = list.get(i);
            if (entity.func_390_a(vec3d) && icamera.func_342_a(entity.boundingBox) && (entity != this.field_1439_t.player || this.field_1439_t.options.thirdPersonView)) {
                ++this.field_1422_K;
                RenderManager.subManager.func_854_a(entity, f);
            }
            ++i;
        }
        int j = 0;
        while (j < this.field_1458_a.size()) {
            TileEntityRenderer.field_1554_a.func_1030_a(this.field_1458_a.get(j), f);
            ++j;
        }
    }

    public String func_953_b() {
        return "Chunks: " + this.chunkRendered + "/" + this.field_1420_M + ". Frustrum: " + this.outsideFrustrum + ", Occluded: " + this.occluded + ", Entities: " + this.field_1416_Q;
    }

    public String func_957_c() {
        return "Entities: " + this.field_1422_K + "/" + this.field_1423_J + ". Occluded: " + this.occludedEntities + ", Invisible: " + (this.field_1423_J - this.occludedEntities - this.field_1422_K);
    }

    private void func_956_b(int i, int j, int k) {
        i -= 8;
        j -= 8;
        k -= 8;
        this.field_1431_B = Integer.MAX_VALUE;
        this.field_1430_C = Integer.MAX_VALUE;
        this.field_1429_D = Integer.MAX_VALUE;
        this.field_1428_E = Integer.MIN_VALUE;
        this.field_1427_F = Integer.MIN_VALUE;
        this.field_1426_G = Integer.MIN_VALUE;
        int l = this.field_1443_p * 16;
        int i1 = l / 2;
        int j1 = 0;
        while (j1 < this.field_1443_p) {
            int k1 = j1 * 16;
            int l1 = k1 + i1 - i;
            if (l1 < 0) {
                l1 -= l - 1;
            }
            if ((k1 -= (l1 /= l) * l) < this.field_1431_B) {
                this.field_1431_B = k1;
            }
            if (k1 > this.field_1428_E) {
                this.field_1428_E = k1;
            }
            int i2 = 0;
            while (i2 < this.field_1441_r) {
                int j2 = i2 * 16;
                int k2 = j2 + i1 - k;
                if (k2 < 0) {
                    k2 -= l - 1;
                }
                if ((j2 -= (k2 /= l) * l) < this.field_1429_D) {
                    this.field_1429_D = j2;
                }
                if (j2 > this.field_1426_G) {
                    this.field_1426_G = j2;
                }
                int l2 = 0;
                while (l2 < this.field_1442_q) {
                    int i3 = l2 * 16;
                    if (i3 < this.field_1430_C) {
                        this.field_1430_C = i3;
                    }
                    if (i3 > this.field_1427_F) {
                        this.field_1427_F = i3;
                    }
                    WorldRenderer worldrenderer = this.field_1444_o[(i2 * this.field_1442_q + l2) * this.field_1443_p + j1];
                    boolean flag = worldrenderer.needsUpdate;
                    worldrenderer.func_1197_a(k1, i3, j2);
                    if (!flag && worldrenderer.needsUpdate) {
                        this.worldRenderersToUpdate.add(worldrenderer);
                    }
                    ++l2;
                }
                ++i2;
            }
            ++j1;
        }
    }

    public int func_943_a(EntityPlayer entityplayer, int i, double d) {
        if (this.field_1439_t.options.renderDistance != this.renDist) {
            this.func_958_a();
        }
        if (i == 0) {
            this.field_1420_M = 0;
            this.outsideFrustrum = 0;
            this.occluded = 0;
            this.chunkRendered = 0;
            this.field_1416_Q = 0;
        }
        double d1 = entityplayer.field_638_aI + (entityplayer.posX - entityplayer.field_638_aI) * d;
        double d2 = entityplayer.field_637_aJ + (entityplayer.posY - entityplayer.field_637_aJ) * d;
        double d3 = entityplayer.field_636_aK + (entityplayer.posZ - entityplayer.field_636_aK) * d;
        double d4 = entityplayer.posX - this.field_1453_f;
        double d5 = entityplayer.posY - this.field_1452_g;
        double d6 = entityplayer.posZ - this.field_1451_h;
        if (d4 * d4 + d5 * d5 + d6 * d6 > 16.0) {
            this.field_1453_f = entityplayer.posX;
            this.field_1452_g = entityplayer.posY;
            this.field_1451_h = entityplayer.posZ;
            this.func_956_b(MathHelper.floor_double(entityplayer.posX), MathHelper.floor_double(entityplayer.posY), MathHelper.floor_double(entityplayer.posZ));
            try {
                Arrays.sort(this.field_1445_n, new EntitySorter(entityplayer));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        int j = 0;
        if (this.occlusionEnabled && !this.field_1439_t.options.anaglyph && i == 0) {
            int k = 0;
            int l = 16;
            this.checkOcclusionQueryResult(k, l);
            int i1 = k;
            while (i1 < l) {
                this.field_1445_n[i1].isAnOccludedChunk = true;
                ++i1;
            }
            j += this.func_952_a(k, l, i, d);
            do {
                int byte0 = l;
                if ((l *= 2) > this.field_1445_n.length) {
                    l = this.field_1445_n.length;
                }
                GL11.glDisable((int)3553);
                GL11.glDisable((int)2896);
                GL11.glDisable((int)3008);
                GL11.glDisable((int)2912);
                GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                GL11.glDepthMask((boolean)false);
                this.checkOcclusionQueryResult(byte0, l);
                GL11.glPushMatrix();
                float f = 0.0f;
                float f1 = 0.0f;
                float f2 = 0.0f;
                int j1 = byte0;
                while (j1 < l) {
                    if (this.field_1445_n[j1].func_1196_e()) {
                        this.field_1445_n[j1].isInFrustrum = false;
                    } else {
                        float f3;
                        int k1;
                        if (!this.field_1445_n[j1].isInFrustrum) {
                            this.field_1445_n[j1].isAnOccludedChunk = true;
                        }
                        if (this.field_1445_n[j1].isInFrustrum && !this.field_1445_n[j1].field_1733_y && this.field_1435_x % (k1 = (int)(1.0f + (f3 = MathHelper.func_1113_c(this.field_1445_n[j1].distanceToEntitySquared(entityplayer))) / 128.0f)) == j1 % k1) {
                            WorldRenderer worldrenderer = this.field_1445_n[j1];
                            float f4 = (float)((double)worldrenderer.field_1755_i - d1);
                            float f5 = (float)((double)worldrenderer.field_1754_j - d2);
                            float f6 = (float)((double)worldrenderer.field_1753_k - d3);
                            float f7 = f4 - f;
                            float f8 = f5 - f1;
                            float f9 = f6 - f2;
                            if (f7 != 0.0f || f8 != 0.0f || f9 != 0.0f) {
                                GL11.glTranslatef((float)f7, (float)f8, (float)f9);
                                f += f7;
                                f1 += f8;
                                f2 += f9;
                            }
                            ARBOcclusionQuery.glBeginQueryARB((int)35092, (int)this.field_1445_n[j1].field_1732_z);
                            this.field_1445_n[j1].func_1201_d();
                            ARBOcclusionQuery.glEndQueryARB((int)35092);
                            this.field_1445_n[j1].field_1733_y = true;
                        }
                    }
                    ++j1;
                }
                GL11.glPopMatrix();
                GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                GL11.glDepthMask((boolean)true);
                GL11.glEnable((int)3553);
                GL11.glEnable((int)3008);
                GL11.glEnable((int)2912);
                j += this.func_952_a(byte0, l, i, d);
            } while (l < this.field_1445_n.length);
        } else {
            j += this.func_952_a(0, this.field_1445_n.length, i, d);
        }
        return j;
    }

    private void checkOcclusionQueryResult(int i, int j) {
        int k = i;
        while (k < j) {
            if (this.field_1445_n[k].field_1733_y) {
                this.occlusionResult.clear();
                ARBOcclusionQuery.glGetQueryObjectuARB((int)this.field_1445_n[k].field_1732_z, (int)34919, (IntBuffer)this.occlusionResult);
                if (this.occlusionResult.get(0) != 0) {
                    this.field_1445_n[k].field_1733_y = false;
                    this.occlusionResult.clear();
                    ARBOcclusionQuery.glGetQueryObjectuARB((int)this.field_1445_n[k].field_1732_z, (int)34918, (IntBuffer)this.occlusionResult);
                    this.field_1445_n[k].isAnOccludedChunk = this.occlusionResult.get(0) != 0;
                }
            }
            ++k;
        }
    }

    private int func_952_a(int startIndex, int endIndex, int renderPass, double partialTicks) {
        this.visibleRenderers.clear();
        int l = 0;
        int i1 = startIndex;
        while (i1 < endIndex) {
            int j1;
            if (renderPass == 0) {
                ++this.field_1420_M;
                if (this.field_1445_n[i1].field_1748_p[renderPass]) {
                    ++this.field_1416_Q;
                } else if (!this.field_1445_n[i1].isInFrustrum) {
                    ++this.outsideFrustrum;
                } else if (this.occlusionEnabled && !this.field_1445_n[i1].isAnOccludedChunk) {
                    ++this.occluded;
                } else {
                    ++this.chunkRendered;
                }
            }
            if ((!this.field_1445_n[i1].field_1748_p[renderPass] || this.field_1445_n[i1].isInFrustrum || this.field_1445_n[i1].isAnOccludedChunk) && (j1 = this.field_1445_n[i1].func_1200_a(renderPass)) >= 0) {
                this.visibleRenderers.add(this.field_1445_n[i1]);
                ++l;
            }
            ++i1;
        }
        EntityPlayerSP entityplayersp = this.field_1439_t.player;
        double d1 = entityplayersp.field_638_aI + (entityplayersp.posX - entityplayersp.field_638_aI) * partialTicks;
        double d2 = entityplayersp.field_637_aJ + (entityplayersp.posY - entityplayersp.field_637_aJ) * partialTicks;
        double d3 = entityplayersp.field_636_aK + (entityplayersp.posZ - entityplayersp.field_636_aK) * partialTicks;
        int k1 = 0;
        int l1 = 0;
        while (l1 < this.field_1414_S.length) {
            this.field_1414_S[l1].func_859_b();
            ++l1;
        }
        int i2 = 0;
        while (i2 < this.visibleRenderers.size()) {
            WorldRenderer worldrenderer = this.visibleRenderers.get(i2);
            int j2 = -1;
            int k2 = 0;
            while (k2 < k1) {
                if (this.field_1414_S[k2].func_862_a(worldrenderer.field_1755_i, worldrenderer.field_1754_j, worldrenderer.field_1753_k)) {
                    j2 = k2;
                }
                ++k2;
            }
            if (j2 < 0) {
                j2 = k1++;
                this.field_1414_S[j2].func_861_a(worldrenderer.field_1755_i, worldrenderer.field_1754_j, worldrenderer.field_1753_k, d1, d2, d3);
            }
            this.field_1414_S[j2].func_858_a(worldrenderer.func_1200_a(renderPass));
            ++i2;
        }
        this.func_944_a(renderPass, partialTicks);
        return l;
    }

    public void func_944_a(int i, double d) {
        int j = 0;
        while (j < this.field_1414_S.length) {
            this.field_1414_S[j].func_860_a();
            ++j;
        }
    }

    public void func_945_d() {
        ++this.field_1435_x;
    }

    public final void renderWater() {
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBindTexture((int)3553, (int)this.renderEngine.bindTexture("/water.png"));
        float var1 = this.field_1448_k.func_598_c(0, 0, 0);
        GL11.glColor4f((float)var1, (float)var1, (float)var1, (float)1.0f);
        GL11.glCallList((int)(this.d + 1));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
    }

    public void renderSky(float f) {
        GL11.glDisable((int)3553);
        Vec3D vec3d = this.field_1448_k.func_626_b(f);
        float f1 = (float)vec3d.xCoord;
        float f2 = (float)vec3d.yCoord;
        float f3 = (float)vec3d.zCoord;
        if (this.field_1439_t.options.anaglyph) {
            float f4 = (f1 * 30.0f + f2 * 59.0f + f3 * 11.0f) / 100.0f;
            float f5 = (f1 * 30.0f + f2 * 70.0f) / 100.0f;
            float f7 = (f1 * 30.0f + f3 * 70.0f) / 100.0f;
            f1 = f4;
            f2 = f5;
            f3 = f7;
        }
        GL11.glColor3f((float)f1, (float)f2, (float)f3);
        Tessellator tessellator = Tessellator.field_1512_a;
        GL11.glDepthMask((boolean)false);
        GL11.glEnable((int)2912);
        GL11.glColor3f((float)f1, (float)f2, (float)f3);
        GL11.glCallList((int)this.field_1433_z);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)2912);
        GL11.glDisable((int)3008);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)1, (int)1);
        GL11.glPushMatrix();
        float f6 = 0.0f;
        float f8 = 0.0f;
        float f9 = 0.0f;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslatef((float)f6, (float)f8, (float)f9);
        GL11.glRotatef((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)(this.field_1448_k.func_619_c(f) * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        float f10 = 30.0f;
        GL11.glBindTexture((int)3553, (int)this.renderEngine.bindTexture("/terrain/sun.png"));
        tessellator.func_977_b();
        tessellator.addVertexWithUV(-f10, 100.0, -f10, 0.0, 0.0);
        tessellator.addVertexWithUV(f10, 100.0, -f10, 1.0, 0.0);
        tessellator.addVertexWithUV(f10, 100.0, f10, 1.0, 1.0);
        tessellator.addVertexWithUV(-f10, 100.0, f10, 0.0, 1.0);
        tessellator.func_982_a();
        f10 = 20.0f;
        GL11.glBindTexture((int)3553, (int)this.renderEngine.bindTexture("/terrain/moon.png"));
        tessellator.func_977_b();
        tessellator.addVertexWithUV(-f10, -100.0, f10, 1.0, 1.0);
        tessellator.addVertexWithUV(f10, -100.0, f10, 0.0, 1.0);
        tessellator.addVertexWithUV(f10, -100.0, -f10, 0.0, 0.0);
        tessellator.addVertexWithUV(-f10, -100.0, -f10, 1.0, 0.0);
        tessellator.func_982_a();
        GL11.glDisable((int)3553);
        float f11 = this.field_1448_k.func_679_f(f);
        if (f11 > 0.0f) {
            GL11.glColor4f((float)f11, (float)f11, (float)f11, (float)f11);
            GL11.glCallList((int)this.field_1434_y);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)2912);
        GL11.glPopMatrix();
        GL11.glColor3f((float)(f1 * 0.2f + 0.04f), (float)(f2 * 0.2f + 0.04f), (float)(f3 * 0.6f + 0.1f));
        GL11.glDisable((int)3553);
        GL11.glCallList((int)this.field_1432_A);
        GL11.glEnable((int)3553);
        GL11.glDepthMask((boolean)true);
    }

    public void func_947_b(float f) {
        if (this.field_1439_t.options.clouds) {
            if (this.field_1439_t.options.fancyGraphics) {
                this.renderFancyClouds(f);
                return;
            }
            GL11.glDisable((int)2884);
            float f1 = (float)(this.field_1439_t.player.field_637_aJ + (this.field_1439_t.player.posY - this.field_1439_t.player.field_637_aJ) * (double)f);
            int byte0 = 32;
            int i = 256 / byte0;
            Tessellator tessellator = Tessellator.field_1512_a;
            GL11.glBindTexture((int)3553, (int)this.renderEngine.bindTexture("/clouds.png"));
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            Vec3D vec3d = this.field_1448_k.func_628_d(f);
            float f2 = (float)vec3d.xCoord;
            float f3 = (float)vec3d.yCoord;
            float f4 = (float)vec3d.zCoord;
            if (this.field_1439_t.options.anaglyph) {
                float f5 = (f2 * 30.0f + f3 * 59.0f + f4 * 11.0f) / 100.0f;
                float f7 = (f2 * 30.0f + f3 * 70.0f) / 100.0f;
                float f8 = (f2 * 30.0f + f4 * 70.0f) / 100.0f;
                f2 = f5;
                f3 = f7;
                f4 = f8;
            }
            float f6 = 4.882813E-4f;
            double d = this.field_1439_t.player.field_614_ah + (this.field_1439_t.player.posX - this.field_1439_t.player.field_614_ah) * (double)f + (double)(((float)this.field_1435_x + f) * 0.03f);
            double d1 = this.field_1439_t.player.field_612_aj + (this.field_1439_t.player.posZ - this.field_1439_t.player.field_612_aj) * (double)f;
            int j = MathHelper.floor_double(d / 2048.0);
            int k = MathHelper.floor_double(d1 / 2048.0);
            float f9 = 120.0f - f1 + 0.33f;
            float f10 = (float)((d -= (double)(j * 2048)) * (double)f6);
            float f11 = (float)((d1 -= (double)(k * 2048)) * (double)f6);
            tessellator.func_977_b();
            tessellator.draw(f2, f3, f4, 0.8f);
            int l = -byte0 * i;
            while (l < byte0 * i) {
                int i1 = -byte0 * i;
                while (i1 < byte0 * i) {
                    tessellator.addVertexWithUV(l + 0, f9, i1 + byte0, (float)(l + 0) * f6 + f10, (float)(i1 + byte0) * f6 + f11);
                    tessellator.addVertexWithUV(l + byte0, f9, i1 + byte0, (float)(l + byte0) * f6 + f10, (float)(i1 + byte0) * f6 + f11);
                    tessellator.addVertexWithUV(l + byte0, f9, i1 + 0, (float)(l + byte0) * f6 + f10, (float)(i1 + 0) * f6 + f11);
                    tessellator.addVertexWithUV(l + 0, f9, i1 + 0, (float)(l + 0) * f6 + f10, (float)(i1 + 0) * f6 + f11);
                    i1 += byte0;
                }
                l += byte0;
            }
            tessellator.func_982_a();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)3042);
            GL11.glEnable((int)2884);
        }
    }

    private FloatBuffer a(float f1, float f2, float f3, float f4) {
        this.floatBuffer.clear();
        this.floatBuffer.put(f1).put(0.0f).put(f3).put(0.0f);
        this.floatBuffer.flip();
        return this.floatBuffer;
    }

    public void renderFancyClouds(float f) {
        GL11.glDisable((int)2884);
        float f1 = (float)(this.field_1439_t.player.field_637_aJ + (this.field_1439_t.player.posY - this.field_1439_t.player.field_637_aJ) * (double)f);
        Tessellator tessellator = Tessellator.field_1512_a;
        float f2 = 12.0f;
        float f3 = 4.0f;
        double d = (this.field_1439_t.player.field_614_ah + (this.field_1439_t.player.posX - this.field_1439_t.player.field_614_ah) * (double)f + (double)(((float)this.field_1435_x + f) * 0.03f)) / (double)f2;
        double d1 = (this.field_1439_t.player.field_612_aj + (this.field_1439_t.player.posZ - this.field_1439_t.player.field_612_aj) * (double)f) / (double)f2 + (double)0.33f;
        float f4 = 108.0f - f1 - (108.0f - this.cloudHeight) + 0.33f;
        int i = MathHelper.floor_double(d / 2048.0);
        int j = MathHelper.floor_double(d1 / 2048.0);
        d -= (double)(i * 2048);
        d1 -= (double)(j * 2048);
        if (this.texClouds) {
            GL13.glActiveTexture((int)33985);
            this.renderEngine.bindTexture("/fluff.png");
            GL11.glTexGeni((int)8192, (int)9472, (int)9217);
            GL11.glTexGen((int)8192, (int)9473, (FloatBuffer)this.a(1.0f, 0.0f, 0.0f, 0.0f));
            GL11.glTexGeni((int)8193, (int)9472, (int)9217);
            GL11.glTexGen((int)8193, (int)9473, (FloatBuffer)this.a(0.0f, 0.0f, 1.0f, 0.0f));
            GL11.glEnable((int)3168);
            GL11.glEnable((int)3169);
            GL11.glEnable((int)3553);
            GL11.glMatrixMode((int)5890);
            GL11.glLoadIdentity();
            GL11.glScalef((float)0.25f, (float)0.25f, (float)0.25f);
            GL11.glTranslatef((float)((float)d), (float)((float)d1), (float)0.0f);
            GL11.glMatrixMode((int)5888);
            GL13.glActiveTexture((int)33984);
            GL11.glEnable((int)3553);
        }
        GL11.glBindTexture((int)3553, (int)this.renderEngine.bindTexture("/clouds.png"));
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Vec3D vec3d = this.field_1448_k.func_628_d(f);
        float f5 = (float)vec3d.xCoord;
        float f6 = (float)vec3d.yCoord;
        float f7 = (float)vec3d.zCoord;
        if (this.field_1439_t.options.anaglyph) {
            float f8 = (f5 * 30.0f + f6 * 59.0f + f7 * 11.0f) / 100.0f;
            float f10 = (f5 * 30.0f + f6 * 70.0f) / 100.0f;
            float f12 = (f5 * 30.0f + f7 * 70.0f) / 100.0f;
            f5 = f8;
            f6 = f10;
            f7 = f12;
        }
        float f9 = (float)(d * 0.0);
        float f11 = (float)(d1 * 0.0);
        float f13 = 0.00390625f;
        f9 = (float)MathHelper.floor_double(d) * f13;
        f11 = (float)MathHelper.floor_double(d1) * f13;
        float f14 = (float)(d - (double)MathHelper.floor_double(d));
        float f15 = (float)(d1 - (double)MathHelper.floor_double(d1));
        int k = 8;
        int byte0 = 3;
        float f16 = 9.765625E-4f;
        GL11.glScalef((float)f2, (float)1.0f, (float)f2);
        int l = 0;
        while (l < 2) {
            if (l == 0) {
                GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            } else {
                GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            }
            int i1 = -byte0 + 1;
            while (i1 <= byte0) {
                int j1 = -byte0 + 1;
                while (j1 <= byte0) {
                    tessellator.func_977_b();
                    float f17 = i1 * k;
                    float f18 = j1 * k;
                    float f19 = f17 - f14;
                    float f20 = f18 - f15;
                    if (f4 > -f3 - 1.0f) {
                        tessellator.draw(f5 * 0.7f, f6 * 0.7f, f7 * 0.7f, 0.8f);
                        tessellator.func_980_b(0.0f, -1.0f, 0.0f);
                        tessellator.addVertexWithUV(f19 + 0.0f, f4 + 0.0f, f20 + (float)k, (f17 + 0.0f) * f13 + f9, (f18 + (float)k) * f13 + f11);
                        tessellator.addVertexWithUV(f19 + (float)k, f4 + 0.0f, f20 + (float)k, (f17 + (float)k) * f13 + f9, (f18 + (float)k) * f13 + f11);
                        tessellator.addVertexWithUV(f19 + (float)k, f4 + 0.0f, f20 + 0.0f, (f17 + (float)k) * f13 + f9, (f18 + 0.0f) * f13 + f11);
                        tessellator.addVertexWithUV(f19 + 0.0f, f4 + 0.0f, f20 + 0.0f, (f17 + 0.0f) * f13 + f9, (f18 + 0.0f) * f13 + f11);
                    }
                    if (f4 <= f3 + 1.0f) {
                        tessellator.draw(f5, f6, f7, 0.8f);
                        tessellator.func_980_b(0.0f, 1.0f, 0.0f);
                        tessellator.addVertexWithUV(f19 + 0.0f, f4 + f3 - f16, f20 + (float)k, (f17 + 0.0f) * f13 + f9, (f18 + (float)k) * f13 + f11);
                        tessellator.addVertexWithUV(f19 + (float)k, f4 + f3 - f16, f20 + (float)k, (f17 + (float)k) * f13 + f9, (f18 + (float)k) * f13 + f11);
                        tessellator.addVertexWithUV(f19 + (float)k, f4 + f3 - f16, f20 + 0.0f, (f17 + (float)k) * f13 + f9, (f18 + 0.0f) * f13 + f11);
                        tessellator.addVertexWithUV(f19 + 0.0f, f4 + f3 - f16, f20 + 0.0f, (f17 + 0.0f) * f13 + f9, (f18 + 0.0f) * f13 + f11);
                    }
                    tessellator.draw(f5 * 0.9f, f6 * 0.9f, f7 * 0.9f, 0.8f);
                    if (i1 > -1) {
                        tessellator.func_980_b(-1.0f, 0.0f, 0.0f);
                        int k1 = 0;
                        while (k1 < k) {
                            tessellator.addVertexWithUV(f19 + (float)k1 + 0.0f, f4 + 0.0f, f20 + (float)k, (f17 + (float)k1 + 0.5f) * f13 + f9, (f18 + (float)k) * f13 + f11);
                            tessellator.addVertexWithUV(f19 + (float)k1 + 0.0f, f4 + f3, f20 + (float)k, (f17 + (float)k1 + 0.5f) * f13 + f9, (f18 + (float)k) * f13 + f11);
                            tessellator.addVertexWithUV(f19 + (float)k1 + 0.0f, f4 + f3, f20 + 0.0f, (f17 + (float)k1 + 0.5f) * f13 + f9, (f18 + 0.0f) * f13 + f11);
                            tessellator.addVertexWithUV(f19 + (float)k1 + 0.0f, f4 + 0.0f, f20 + 0.0f, (f17 + (float)k1 + 0.5f) * f13 + f9, (f18 + 0.0f) * f13 + f11);
                            ++k1;
                        }
                    }
                    if (i1 <= 1) {
                        tessellator.func_980_b(1.0f, 0.0f, 0.0f);
                        int l1 = 0;
                        while (l1 < k) {
                            tessellator.addVertexWithUV(f19 + (float)l1 + 1.0f - f16, f4 + 0.0f, f20 + (float)k, (f17 + (float)l1 + 0.5f) * f13 + f9, (f18 + (float)k) * f13 + f11);
                            tessellator.addVertexWithUV(f19 + (float)l1 + 1.0f - f16, f4 + f3, f20 + (float)k, (f17 + (float)l1 + 0.5f) * f13 + f9, (f18 + (float)k) * f13 + f11);
                            tessellator.addVertexWithUV(f19 + (float)l1 + 1.0f - f16, f4 + f3, f20 + 0.0f, (f17 + (float)l1 + 0.5f) * f13 + f9, (f18 + 0.0f) * f13 + f11);
                            tessellator.addVertexWithUV(f19 + (float)l1 + 1.0f - f16, f4 + 0.0f, f20 + 0.0f, (f17 + (float)l1 + 0.5f) * f13 + f9, (f18 + 0.0f) * f13 + f11);
                            ++l1;
                        }
                    }
                    tessellator.draw(f5 * 0.8f, f6 * 0.8f, f7 * 0.8f, 0.8f);
                    if (j1 > -1) {
                        tessellator.func_980_b(0.0f, 0.0f, -1.0f);
                        int i2 = 0;
                        while (i2 < k) {
                            tessellator.addVertexWithUV(f19 + 0.0f, f4 + f3, f20 + (float)i2 + 0.0f, (f17 + 0.0f) * f13 + f9, (f18 + (float)i2 + 0.5f) * f13 + f11);
                            tessellator.addVertexWithUV(f19 + (float)k, f4 + f3, f20 + (float)i2 + 0.0f, (f17 + (float)k) * f13 + f9, (f18 + (float)i2 + 0.5f) * f13 + f11);
                            tessellator.addVertexWithUV(f19 + (float)k, f4 + 0.0f, f20 + (float)i2 + 0.0f, (f17 + (float)k) * f13 + f9, (f18 + (float)i2 + 0.5f) * f13 + f11);
                            tessellator.addVertexWithUV(f19 + 0.0f, f4 + 0.0f, f20 + (float)i2 + 0.0f, (f17 + 0.0f) * f13 + f9, (f18 + (float)i2 + 0.5f) * f13 + f11);
                            ++i2;
                        }
                    }
                    if (j1 <= 1) {
                        tessellator.func_980_b(0.0f, 0.0f, 1.0f);
                        int j2 = 0;
                        while (j2 < k) {
                            tessellator.addVertexWithUV(f19 + 0.0f, f4 + f3, f20 + (float)j2 + 1.0f - f16, (f17 + 0.0f) * f13 + f9, (f18 + (float)j2 + 0.5f) * f13 + f11);
                            tessellator.addVertexWithUV(f19 + (float)k, f4 + f3, f20 + (float)j2 + 1.0f - f16, (f17 + (float)k) * f13 + f9, (f18 + (float)j2 + 0.5f) * f13 + f11);
                            tessellator.addVertexWithUV(f19 + (float)k, f4 + 0.0f, f20 + (float)j2 + 1.0f - f16, (f17 + (float)k) * f13 + f9, (f18 + (float)j2 + 0.5f) * f13 + f11);
                            tessellator.addVertexWithUV(f19 + 0.0f, f4 + 0.0f, f20 + (float)j2 + 1.0f - f16, (f17 + 0.0f) * f13 + f9, (f18 + (float)j2 + 0.5f) * f13 + f11);
                            ++j2;
                        }
                    }
                    tessellator.func_982_a();
                    ++j1;
                }
                ++i1;
            }
            ++l;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2884);
        if (this.texClouds) {
            GL13.glActiveTexture((int)33985);
            GL11.glDisable((int)3553);
            GL11.glDisable((int)3168);
            GL11.glDisable((int)3169);
            GL13.glActiveTexture((int)33984);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean func_948_a(EntityPlayer entityplayer, boolean flag) {
        block27: {
            WorldRenderer chunk;
            if (!this.field_1439_t.options.fastRender) break block27;
            RenderSorter cmp = new RenderSorter(entityplayer);
            WorldRenderer[] toAdd = new WorldRenderer[3];
            ArrayList<WorldRenderer> nearChunks = null;
            float dist = 1024.0f;
            int pendingChunkSize = this.worldRenderersToUpdate.size();
            int pendingChunkRemoved = 0;
            int i = 0;
            while (i < pendingChunkSize) {
                block30: {
                    block29: {
                        block28: {
                            chunk = this.worldRenderersToUpdate.get(i);
                            if (flag) break block28;
                            if (!(chunk.distanceToEntitySquared(entityplayer) > dist)) break block29;
                            int index = 0;
                            while (index < 3) {
                                if (toAdd[index] != null && cmp.doCompare(toAdd[index], chunk) == 1) break;
                                ++index;
                            }
                            if (--index > 0) {
                                int x = index;
                                while (--x != 0) {
                                    toAdd[x - 1] = toAdd[x];
                                }
                                toAdd[index] = chunk;
                            }
                            break block30;
                        }
                        if (!chunk.isInFrustrum) break block30;
                    }
                    if (nearChunks == null) {
                        nearChunks = new ArrayList<WorldRenderer>();
                    }
                    ++pendingChunkRemoved;
                    nearChunks.add(chunk);
                    this.worldRenderersToUpdate.set(i, null);
                }
                ++i;
            }
            if (nearChunks != null) {
                if (nearChunks.size() > 1) {
                    Collections.sort(nearChunks, new RenderSorter(entityplayer));
                }
                i = nearChunks.size() - 1;
                while (i >= 0) {
                    chunk = (WorldRenderer)nearChunks.get(i);
                    chunk.updateRenderer();
                    chunk.needsUpdate = false;
                    --i;
                }
            }
            int secondaryRemoved = 0;
            int i2 = 2;
            while (i2 >= 0) {
                WorldRenderer chunk2 = toAdd[i2];
                if (chunk2 != null) {
                    if (!chunk2.isInFrustrum && i2 != 2) {
                        toAdd[i2] = null;
                        toAdd[0] = null;
                        break;
                    }
                    toAdd[i2].updateRenderer();
                    toAdd[i2].needsUpdate = false;
                    ++secondaryRemoved;
                }
                --i2;
            }
            int cursor = 0;
            int target = 0;
            int arraySize = this.worldRenderersToUpdate.size();
            while (cursor != arraySize) {
                WorldRenderer chunk3 = this.worldRenderersToUpdate.get(cursor);
                if (chunk3 != null && chunk3 != toAdd[0] && chunk3 != toAdd[1] && chunk3 != toAdd[2]) {
                    if (target != cursor) {
                        this.worldRenderersToUpdate.set(target, chunk3);
                    }
                    ++target;
                }
                ++cursor;
            }
            while (--cursor >= target) {
                this.worldRenderersToUpdate.remove(cursor);
            }
            return pendingChunkSize == pendingChunkRemoved + secondaryRemoved;
        }
        try {
            Collections.sort(this.worldRenderersToUpdate, new RenderSorter(entityplayer));
            int i = this.worldRenderersToUpdate.size() - 1;
            int j = this.worldRenderersToUpdate.size();
            int k = 0;
            while (k < j) {
                block34: {
                    block31: {
                        WorldRenderer worldrenderer;
                        block33: {
                            block32: {
                                worldrenderer = this.worldRenderersToUpdate.get(i - k);
                                if (flag) break block31;
                                if (!(worldrenderer.distanceToEntitySquared(entityplayer) > 1024.0f)) break block32;
                                if (worldrenderer.isInFrustrum ? k >= 3 : k >= 1) {
                                    return false;
                                }
                                break block33;
                            }
                            if (!worldrenderer.isInFrustrum) break block34;
                        }
                        worldrenderer.updateRenderer();
                        this.worldRenderersToUpdate.remove(worldrenderer);
                        worldrenderer.needsUpdate = false;
                    }
                    return this.worldRenderersToUpdate.size() == 0;
                }
                ++k;
            }
        }
        catch (Exception ex) {
            return false;
        }
        return flag;
    }

    public void func_959_a(EntityPlayer entityplayer, MovingObjectPosition movingobjectposition, int i, ItemStack itemstack, float f) {
        Tessellator tessellator = Tessellator.field_1512_a;
        GL11.glEnable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)((MathHelper.sin((float)System.currentTimeMillis() / 100.0f) * 0.2f + 0.4f) * 0.5f));
        if (i == 0) {
            if (this.field_1450_i > 0.0f) {
                GL11.glBlendFunc((int)774, (int)768);
                int j = this.renderEngine.bindTexture("/terrain.png");
                GL11.glBindTexture((int)3553, (int)j);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
                GL11.glPushMatrix();
                int k = this.field_1448_k.getBlock(movingobjectposition.field_1166_b, movingobjectposition.field_1172_c, movingobjectposition.field_1171_d);
                Block block = k <= 0 ? null : Block.allBlocks[k];
                GL11.glDisable((int)3008);
                GL11.glPolygonOffset((float)-3.0f, (float)-3.0f);
                GL11.glEnable((int)32823);
                tessellator.func_977_b();
                double d = entityplayer.field_638_aI + (entityplayer.posX - entityplayer.field_638_aI) * (double)f;
                double d1 = entityplayer.field_637_aJ + (entityplayer.posY - entityplayer.field_637_aJ) * (double)f;
                double d2 = entityplayer.field_636_aK + (entityplayer.posZ - entityplayer.field_636_aK) * (double)f;
                tessellator.setTranslation(-d, -d1, -d2);
                tessellator.func_989_c();
                if (block == null) {
                    block = Block.stone;
                }
                this.field_1438_u.func_1223_a(block, movingobjectposition.field_1166_b, movingobjectposition.field_1172_c, movingobjectposition.field_1171_d, 240 + (int)(this.field_1450_i * 10.0f));
                tessellator.func_982_a();
                tessellator.setTranslation(0.0, 0.0, 0.0);
                GL11.glPolygonOffset((float)0.0f, (float)0.0f);
                GL11.glDisable((int)32823);
                GL11.glEnable((int)3008);
                GL11.glDepthMask((boolean)true);
                GL11.glPopMatrix();
            }
        } else if (itemstack != null) {
            GL11.glBlendFunc((int)770, (int)771);
            float f1 = MathHelper.sin((float)System.currentTimeMillis() / 100.0f) * 0.2f + 0.8f;
            GL11.glColor4f((float)f1, (float)f1, (float)f1, (float)(MathHelper.sin((float)System.currentTimeMillis() / 200.0f) * 0.2f + 0.5f));
            int l = this.renderEngine.bindTexture("/terrain.png");
            GL11.glBindTexture((int)3553, (int)l);
        }
        GL11.glDisable((int)3042);
        GL11.glDisable((int)3008);
    }

    public void func_955_b(EntityPlayer entityplayer, MovingObjectPosition movingobjectposition, int i, ItemStack itemstack, float f) {
        if (i == 0 && movingobjectposition.field_1167_a == 0) {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
            GL11.glLineWidth((float)2.0f);
            GL11.glDisable((int)3553);
            GL11.glDepthMask((boolean)false);
            float f1 = 0.002f;
            int j = this.field_1448_k.getBlock(movingobjectposition.field_1166_b, movingobjectposition.field_1172_c, movingobjectposition.field_1171_d);
            if (j > 0) {
                Block.allBlocks[j].func_238_a(this.field_1448_k, movingobjectposition.field_1166_b, movingobjectposition.field_1172_c, movingobjectposition.field_1171_d);
                double d = entityplayer.field_638_aI + (entityplayer.posX - entityplayer.field_638_aI) * (double)f;
                double d1 = entityplayer.field_637_aJ + (entityplayer.posY - entityplayer.field_637_aJ) * (double)f;
                double d2 = entityplayer.field_636_aK + (entityplayer.posZ - entityplayer.field_636_aK) * (double)f;
                this.func_942_a(Block.allBlocks[j].getCollisionBoundingBoxFromPool(this.field_1448_k, movingobjectposition.field_1166_b, movingobjectposition.field_1172_c, movingobjectposition.field_1171_d).func_1177_b(f1, f1, f1).func_1166_c(-d, -d1, -d2));
            }
            GL11.glDepthMask((boolean)true);
            GL11.glEnable((int)3553);
            GL11.glDisable((int)3042);
        }
    }

    private void func_942_a(AxisAlignedBB axisalignedbb) {
        Tessellator tessellator = Tessellator.field_1512_a;
        tessellator.func_992_a(3);
        tessellator.func_991_a(axisalignedbb.field_1698_a, axisalignedbb.minY, axisalignedbb.field_1704_c);
        tessellator.func_991_a(axisalignedbb.field_1703_d, axisalignedbb.minY, axisalignedbb.field_1704_c);
        tessellator.func_991_a(axisalignedbb.field_1703_d, axisalignedbb.minY, axisalignedbb.field_1701_f);
        tessellator.func_991_a(axisalignedbb.field_1698_a, axisalignedbb.minY, axisalignedbb.field_1701_f);
        tessellator.func_991_a(axisalignedbb.field_1698_a, axisalignedbb.minY, axisalignedbb.field_1704_c);
        tessellator.func_982_a();
        tessellator.func_992_a(3);
        tessellator.func_991_a(axisalignedbb.field_1698_a, axisalignedbb.field_1702_e, axisalignedbb.field_1704_c);
        tessellator.func_991_a(axisalignedbb.field_1703_d, axisalignedbb.field_1702_e, axisalignedbb.field_1704_c);
        tessellator.func_991_a(axisalignedbb.field_1703_d, axisalignedbb.field_1702_e, axisalignedbb.field_1701_f);
        tessellator.func_991_a(axisalignedbb.field_1698_a, axisalignedbb.field_1702_e, axisalignedbb.field_1701_f);
        tessellator.func_991_a(axisalignedbb.field_1698_a, axisalignedbb.field_1702_e, axisalignedbb.field_1704_c);
        tessellator.func_982_a();
        tessellator.func_992_a(1);
        tessellator.func_991_a(axisalignedbb.field_1698_a, axisalignedbb.minY, axisalignedbb.field_1704_c);
        tessellator.func_991_a(axisalignedbb.field_1698_a, axisalignedbb.field_1702_e, axisalignedbb.field_1704_c);
        tessellator.func_991_a(axisalignedbb.field_1703_d, axisalignedbb.minY, axisalignedbb.field_1704_c);
        tessellator.func_991_a(axisalignedbb.field_1703_d, axisalignedbb.field_1702_e, axisalignedbb.field_1704_c);
        tessellator.func_991_a(axisalignedbb.field_1703_d, axisalignedbb.minY, axisalignedbb.field_1701_f);
        tessellator.func_991_a(axisalignedbb.field_1703_d, axisalignedbb.field_1702_e, axisalignedbb.field_1701_f);
        tessellator.func_991_a(axisalignedbb.field_1698_a, axisalignedbb.minY, axisalignedbb.field_1701_f);
        tessellator.func_991_a(axisalignedbb.field_1698_a, axisalignedbb.field_1702_e, axisalignedbb.field_1701_f);
        tessellator.func_982_a();
    }

    public void func_949_a(int i, int j, int k, int l, int i1, int j1) {
        int k1 = MathHelper.func_1111_a(i, 16);
        int l1 = MathHelper.func_1111_a(j, 16);
        int i2 = MathHelper.func_1111_a(k, 16);
        int j2 = MathHelper.func_1111_a(l, 16);
        int k2 = MathHelper.func_1111_a(i1, 16);
        int l2 = MathHelper.func_1111_a(j1, 16);
        int i3 = k1;
        while (i3 <= j2) {
            int j3 = i3 % this.field_1443_p;
            if (j3 < 0) {
                j3 += this.field_1443_p;
            }
            int k3 = l1;
            while (k3 <= k2) {
                int l3 = k3 % this.field_1442_q;
                if (l3 < 0) {
                    l3 += this.field_1442_q;
                }
                int i4 = i2;
                while (i4 <= l2) {
                    int j4 = i4 % this.field_1441_r;
                    if (j4 < 0) {
                        j4 += this.field_1441_r;
                    }
                    int k4 = (j4 * this.field_1442_q + l3) * this.field_1443_p + j3;
                    WorldRenderer worldrenderer = this.field_1444_o[k4];
                    if (!worldrenderer.needsUpdate) {
                        this.worldRenderersToUpdate.add(worldrenderer);
                    }
                    worldrenderer.func_1194_f();
                    ++i4;
                }
                ++k3;
            }
            ++i3;
        }
    }

    public void func_934_a(int i, int j, int k) {
        this.func_949_a(i - 1, j - 1, k - 1, i + 1, j + 1, k + 1);
    }

    public void func_937_b(int i, int j, int k, int l, int i1, int j1) {
        this.func_949_a(i - 1, j - 1, k - 1, l + 1, i1 + 1, j1 + 1);
    }

    public void func_960_a(ICamera icamera, float f) {
        int i = 0;
        while (i < this.field_1444_o.length) {
            if (!(this.field_1444_o[i].func_1196_e() || this.field_1444_o[i].isInFrustrum && (i + this.field_1449_j & 0xF) != 0)) {
                this.field_1444_o[i].func_1199_a(icamera);
            }
            ++i;
        }
        ++this.field_1449_j;
    }

    public void func_933_a(String s, int i, int j, int k) {
        if (s != null) {
            this.field_1439_t.field_164_u.func_553_b("C418 - " + s);
        }
        this.field_1439_t.field_158_A.func_331_a(s, i, j, k, 1.0f, 1.0f);
    }

    public void func_940_a(String s, double d, double d1, double d2, float f, float f1) {
        float f2 = 16.0f;
        if (f > 1.0f) {
            f2 *= f;
        }
        if (this.field_1439_t.player.func_360_d(d, d1, d2) < (double)(f2 * f2) && !this.field_1439_t.isServer()) {
            this.field_1439_t.field_158_A.func_336_b(s, (float)d, (float)d1, (float)d2, f, f1);
        }
    }

    public void func_939_a(String s, double d, double d1, double d2, double d3, double d4, double d5) {
        double d6 = this.field_1439_t.player.posX - d;
        double d7 = this.field_1439_t.player.posY - d1;
        double d8 = this.field_1439_t.player.posZ - d2;
        if (d6 * d6 + d7 * d7 + d8 * d8 > 256.0) {
            return;
        }
        if (s == "bubble") {
            this.field_1439_t.field_177_h.func_1192_a(new EntityBubbleFX(this.field_1448_k, d, d1, d2, d3, d4, d5));
        } else if (s == "smoke") {
            this.field_1439_t.field_177_h.func_1192_a(new EntitySmokeFX(this.field_1448_k, d, d1, d2));
        } else if (s == "explode") {
            this.field_1439_t.field_177_h.func_1192_a(new EntityExplodeFX(this.field_1448_k, d, d1, d2, d3, d4, d5));
        } else if (s == "flame") {
            this.field_1439_t.field_177_h.func_1192_a(new EntityFlameFX(this.field_1448_k, d, d1, d2, d3, d4, d5));
        } else if (s == "lava") {
            this.field_1439_t.field_177_h.func_1192_a(new EntityLavaFX(this.field_1448_k, d, d1, d2));
        } else if (s == "splash") {
            this.field_1439_t.field_177_h.func_1192_a(new EntitySplashFX(this.field_1448_k, d, d1, d2, d3, d4, d5));
        } else if (s == "largesmoke") {
            this.field_1439_t.field_177_h.func_1192_a(new EntitySmokeFX(this.field_1448_k, d, d1, d2, 2.5f));
        } else if (s == "reddust") {
            this.field_1439_t.field_177_h.func_1192_a(new EntityReddustFX(this.field_1448_k, d, d1, d2));
        } else if (s == "snowballpoof") {
            this.field_1439_t.field_177_h.func_1192_a(new EntitySlimeFX(this.field_1448_k, d, d1, d2, Item.snowball));
        } else if (s == "slime") {
            this.field_1439_t.field_177_h.func_1192_a(new EntitySlimeFX(this.field_1448_k, d, d1, d2, Item.slimeBall));
        }
    }

    public void func_941_a(Entity entity) {
        if (entity.field_622_aY != null) {
            this.renderEngine.func_1075_a(entity.field_622_aY, new ImageBufferDownload());
        }
    }

    public void func_938_b(Entity entity) {
        if (entity.field_622_aY != null) {
            this.renderEngine.func_1073_b(entity.field_622_aY);
        }
    }

    public void func_936_e() {
        int i = 0;
        while (i < this.field_1444_o.length) {
            if (this.field_1444_o[i].field_1747_A) {
                if (!this.field_1444_o[i].needsUpdate) {
                    this.worldRenderersToUpdate.add(this.field_1444_o[i]);
                }
                this.field_1444_o[i].func_1194_f();
            }
            ++i;
        }
    }

    public void func_935_a(int i, int j, int k, TileEntity tileentity) {
    }
}

