/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.sound;

import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.render.Vec3D;

public class AmbientLoopHandler {
    World world;
    EntityPlayer player;
    int leaves;
    int waterSurface;
    int exposedOre;
    int fallingWater;
    public boolean enoughLeaves;
    public boolean enoughWater;
    public boolean enoughOre;
    public Vec3D avgLeavesPos;
    public Vec3D avgWaterPos;

    public AmbientLoopHandler(World wrld, EntityPlayer plyr) {
        this.world = wrld;
        plyr = this.player;
    }

    public void update() {
        this.avgLeavesPos = Vec3D.newVector(0.0, 0.0, 0.0);
        this.avgWaterPos = Vec3D.newVector(0.0, 0.0, 0.0);
        this.leaves = 0;
        this.waterSurface = 0;
        this.exposedOre = 0;
        this.fallingWater = 0;
        this.enoughLeaves = false;
        this.enoughWater = false;
        this.enoughOre = false;
        int x = -25;
        while (x < 25) {
            int y = -25;
            while (y < 25) {
                int z = -25;
                while (z < 25) {
                    int block = this.world.getBlock(x + (int)this.player.posX, y + (int)this.player.posY, z + (int)this.player.posZ);
                    if (block == Block.leaves.blockID) {
                        ++this.leaves;
                        this.avgLeavesPos = this.avgLeavesPos.avgVector(this.avgLeavesPos, Vec3D.newVector(x, y, z));
                    }
                    if (block == Block.waterStill.blockID && this.world.getBlock(x + (int)this.player.posX, y + (int)this.player.posY + 1, z + (int)this.player.posZ) == 0) {
                        ++this.waterSurface;
                        this.avgWaterPos = this.avgWaterPos.avgVector(this.avgWaterPos, Vec3D.newVector(x, y, z));
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        if (this.leaves >= 25) {
            this.enoughLeaves = true;
            System.out.println("Enough leaves!");
        } else {
            this.enoughLeaves = false;
        }
        if (this.waterSurface >= 9) {
            this.enoughWater = true;
            System.out.println("Enough Water!");
        } else {
            this.enoughWater = false;
        }
    }
}

