/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.sound;

import com.mojang.minecraft.entity.EntityLiving;
import com.mojang.minecraft.player.controller.GameSettings;
import com.mojang.minecraft.sound.CodecMus;
import com.mojang.minecraft.sound.SoundPool;
import com.mojang.minecraft.sound.SoundPoolEntry;
import com.mojang.minecraft.util.MathHelper;
import java.io.File;
import java.util.Random;
import paulscode.sound.SoundSystem;
import paulscode.sound.SoundSystemConfig;
import paulscode.sound.codecs.CodecJOrbis;
import paulscode.sound.codecs.CodecWav;
import paulscode.sound.libraries.LibraryLWJGLOpenAL;

public class SoundManager {
    private static SoundSystem field_591_a;
    private SoundPool field_590_b = new SoundPool();
    private SoundPool field_589_c = new SoundPool();
    private SoundPool field_588_d = new SoundPool();
    private int field_587_e = 0;
    private GameSettings settings;
    private static boolean field_585_g;
    private Random field_584_h = new Random();
    private int field_583_i = this.field_584_h.nextInt(12000);

    static {
        field_585_g = false;
    }

    public void func_340_a(GameSettings gamesettings) {
        this.field_589_c.field_1657_b = false;
        this.settings = gamesettings;
        if (!(field_585_g || gamesettings != null && gamesettings.soundVolume == 0.0f && gamesettings.musicVolume == 0.0f)) {
            this.func_339_d();
        }
    }

    private void func_339_d() {
        try {
            float soundVol = this.settings.soundVolume;
            float musicVol = this.settings.musicVolume;
            this.settings.soundVolume = 0.0f;
            this.settings.musicVolume = 0.0f;
            this.settings.save();
            SoundSystemConfig.addLibrary(LibraryLWJGLOpenAL.class);
            SoundSystemConfig.setCodec((String)"ogg", CodecJOrbis.class);
            SoundSystemConfig.setCodec((String)"mus", CodecMus.class);
            SoundSystemConfig.setCodec((String)"wav", CodecWav.class);
            field_591_a = new SoundSystem();
            this.settings.soundVolume = soundVol;
            this.settings.musicVolume = musicVol;
            this.settings.save();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.err.println("error linking with the LibraryJavaSound plug-in");
        }
        field_585_g = true;
    }

    public void func_335_a() {
        if (field_591_a != null) {
            if (!(field_585_g || this.settings.soundVolume == 0.0f && this.settings.musicVolume == 0.0f)) {
                this.func_339_d();
            }
            if (this.settings.musicVolume == 0.0f) {
                field_591_a.stop("BgMusic");
            } else {
                field_591_a.setVolume("BgMusic", this.settings.musicVolume);
            }
        }
    }

    public void func_330_b() {
        if (field_585_g) {
            field_591_a.cleanup();
        }
    }

    public void func_332_a(String s, File file) {
        this.field_590_b.func_1117_a(s, file);
    }

    public void func_333_b(String s, File file) {
        this.field_589_c.func_1117_a(s, file);
    }

    public void func_334_c(String s, File file) {
        this.field_588_d.func_1117_a(s, file);
    }

    public void func_341_c() {
        if (!field_585_g || this.settings.musicVolume == 0.0f) {
            return;
        }
        if (!field_591_a.playing("BgMusic") && !field_591_a.playing("streaming")) {
            if (this.field_583_i > 0) {
                --this.field_583_i;
                return;
            }
            SoundPoolEntry soundpoolentry = this.field_588_d.func_1116_a();
            if (soundpoolentry != null) {
                this.field_583_i = this.field_584_h.nextInt(24000) + 24000;
                field_591_a.backgroundMusic("BgMusic", soundpoolentry.field_1780_b, soundpoolentry.field_1781_a, false);
                field_591_a.setVolume("BgMusic", this.settings.musicVolume);
                field_591_a.play("BgMusic");
            }
        }
    }

    public void func_338_a(EntityLiving entityliving, float f) {
        if (!field_585_g || this.settings.soundVolume == 0.0f) {
            return;
        }
        if (entityliving == null) {
            return;
        }
        float f1 = entityliving.headYaw + (entityliving.rotationYaw - entityliving.headYaw) * f;
        double d = entityliving.field_614_ah + (entityliving.posX - entityliving.field_614_ah) * (double)f;
        double d1 = entityliving.field_613_ai + (entityliving.posY - entityliving.field_613_ai) * (double)f;
        double d2 = entityliving.field_612_aj + (entityliving.posZ - entityliving.field_612_aj) * (double)f;
        float f2 = MathHelper.cos(-f1 * 0.01745329f - 3.141593f);
        float f3 = MathHelper.sin(-f1 * 0.01745329f - 3.141593f);
        float f4 = -f3;
        float f5 = 0.0f;
        float f6 = -f2;
        float f7 = 0.0f;
        float f8 = 1.0f;
        float f9 = 0.0f;
        field_591_a.setListenerPosition((float)d, (float)d1, (float)d2);
        field_591_a.setListenerOrientation(f4, f5, f6, f7, f8, f9);
    }

    public void func_331_a(String s, float f, float f1, float f2, float f3, float f4) {
        if (!field_585_g || this.settings.soundVolume == 0.0f) {
            return;
        }
        String s1 = "streaming";
        if (field_591_a.playing("streaming")) {
            field_591_a.stop("streaming");
        }
        if (s == null) {
            return;
        }
        SoundPoolEntry soundpoolentry = this.field_589_c.func_1118_a(s);
        if (soundpoolentry != null && f3 > 0.0f) {
            if (field_591_a.playing("BgMusic")) {
                field_591_a.stop("BgMusic");
            }
            float f5 = 16.0f;
            field_591_a.newStreamingSource(true, s1, soundpoolentry.field_1780_b, soundpoolentry.field_1781_a, false, f, f1, f2, 2, f5 * 4.0f);
            field_591_a.setVolume(s1, 0.5f * this.settings.soundVolume);
            field_591_a.play(s1);
        }
    }

    public void func_336_b(String s, float f, float f1, float f2, float f3, float f4) {
        if (!field_585_g || this.settings.soundVolume == 0.0f) {
            return;
        }
        SoundPoolEntry soundpoolentry = this.field_590_b.func_1118_a(s);
        if (soundpoolentry != null && f3 > 0.0f) {
            this.field_587_e = (this.field_587_e + 1) % 256;
            String s1 = "sound_" + this.field_587_e;
            float f5 = 16.0f;
            if (f3 > 1.0f) {
                f5 *= f3;
            }
            field_591_a.newSource(f3 > 1.0f, s1, soundpoolentry.field_1780_b, soundpoolentry.field_1781_a, false, f, f1, f2, 2, f5);
            field_591_a.setPitch(s1, f4);
            if (f3 > 1.0f) {
                f3 = 1.0f;
            }
            field_591_a.setVolume(s1, f3 * this.settings.soundVolume);
            field_591_a.play(s1);
        }
    }

    public void func_337_a(String s, float f, float f1) {
        if (!field_585_g || this.settings.soundVolume == 0.0f) {
            return;
        }
        SoundPoolEntry soundpoolentry = this.field_590_b.func_1118_a(s);
        if (soundpoolentry != null) {
            this.field_587_e = (this.field_587_e + 1) % 256;
            String s1 = "sound_" + this.field_587_e;
            field_591_a.newSource(false, s1, soundpoolentry.field_1780_b, soundpoolentry.field_1781_a, false, 0.0f, 0.0f, 0.0f, 0, 0.0f);
            if (f > 1.0f) {
                f = 1.0f;
            }
            field_591_a.setPitch(s1, f1);
            field_591_a.setVolume(s1, (f *= 0.25f) * this.settings.soundVolume);
            field_591_a.play(s1);
        }
    }
}

