/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityMobs;
import com.mojang.minecraft.entity.item.Item;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.nbt.NBTTagCompound;
import com.mojang.minecraft.util.MathHelper;

public class EntitySpider
extends EntityMobs {
    public EntitySpider(World world) {
        super(world);
        this.scoreYield = 30;
        this.texture = "/mob/spider.png";
        this.setBounds(1.4f, 0.9f);
        this.move_speed = 0.8f;
        this.currentSpeed = 0.5;
    }

    @Override
    public double func_402_h() {
        return (double)this.height * 0.75 - 0.5;
    }

    @Override
    protected Entity findPlayerToAttack() {
        float f = this.func_382_a(1.0f);
        if (f < 0.5f) {
            double d = 16.0;
            this.currentSpeed = 1.0;
            return this.worldObj.getPlayerEntityAtHeight(this, d);
        }
        return null;
    }

    @Override
    public boolean onLadder() {
        if (this.worldObj.difficulty == 3) {
            return true;
        }
        return super.onLadder();
    }

    @Override
    protected String idleSound() {
        return "mob.spider";
    }

    @Override
    protected String hurtSound() {
        return "mob.spider";
    }

    @Override
    protected String deathSound() {
        return "mob.spiderdeath";
    }

    @Override
    protected void attackEntity(Entity entity, float f) {
        float f1 = this.func_382_a(1.0f);
        if (f1 > 0.5f && this.rand.nextInt(100) == 0) {
            this.entityToAttack = null;
            return;
        }
        if (f > 2.0f && f < 6.0f && this.rand.nextInt(10) == 0) {
            if (this.onGround) {
                double d = entity.posX - this.posX;
                double d1 = entity.posZ - this.posZ;
                float f2 = MathHelper.squareRootDoubleToFloat(d * d + d1 * d1);
                this.motionX = d / (double)f2 * 0.5 * (double)0.8f + this.motionX * (double)0.2f;
                this.motionZ = d1 / (double)f2 * 0.5 * (double)0.8f + this.motionZ * (double)0.2f;
                this.motionY = 0.4f;
            }
        } else {
            super.attackEntity(entity, f);
        }
    }

    @Override
    public void addNBTTag(NBTTagCompound nbttagcompound) {
        super.addNBTTag(nbttagcompound);
    }

    @Override
    public void removeNBTTag(NBTTagCompound nbttagcompound) {
        super.removeNBTTag(nbttagcompound);
    }

    @Override
    protected int deathDropItem() {
        return Item.silk.swiftedIndex;
    }

    @Override
    public double getRealMoveSpeed() {
        return this.currentSpeed;
    }
}

