/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.entity.MovingObjectPosition;
import com.mojang.minecraft.entity.tile.IBlockAccess;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.MinecartTrackLogic;
import com.mojang.minecraft.level.tile.material.Material;
import com.mojang.minecraft.level.tile.phys.AxisAlignedBB;
import com.mojang.minecraft.render.Vec3D;
import java.util.Random;

public class BlockMinecartTrack
extends Block {
    protected BlockMinecartTrack(int i, int j) {
        super(i, j, Material.circuits);
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
    }

    @Override
    public AxisAlignedBB func_221_d(World world, int i, int j, int k) {
        return null;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public MovingObjectPosition func_255_a(World world, int i, int j, int k, Vec3D vec3d, Vec3D vec3d1) {
        this.func_238_a(world, i, j, k);
        return super.func_255_a(world, i, j, k, vec3d, vec3d1);
    }

    @Override
    public void func_238_a(IBlockAccess iblockaccess, int i, int j, int k) {
        int l = iblockaccess.getBlockDmg(i, j, k);
        if (l >= 2 && l <= 5) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.625f, 1.0f);
        } else {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
        }
    }

    @Override
    public int getTextureIndex(int i, int j) {
        if (j >= 6) {
            return this.textureIndex - 16;
        }
        return this.textureIndex;
    }

    @Override
    public boolean func_242_c() {
        return false;
    }

    @Override
    public int getRenderType() {
        return 9;
    }

    @Override
    public int dropChance(Random random) {
        return 1;
    }

    @Override
    public boolean canPlace(World world, int i, int j, int k) {
        return world.isBlockNormalCube(i, j - 1, k);
    }

    @Override
    public void onPlace(World world, int i, int j, int k) {
        world.func_691_b(i, j, k, 15);
        this.func_304_h(world, i, j, k);
    }

    @Override
    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        int i1 = world.getBlockDmg(i, j, k);
        boolean flag = false;
        if (!world.isBlockNormalCube(i, j - 1, k)) {
            flag = true;
        }
        if (i1 == 2 && !world.isBlockNormalCube(i + 1, j, k)) {
            flag = true;
        }
        if (i1 == 3 && !world.isBlockNormalCube(i - 1, j, k)) {
            flag = true;
        }
        if (i1 == 4 && !world.isBlockNormalCube(i, j, k - 1)) {
            flag = true;
        }
        if (i1 == 5 && !world.isBlockNormalCube(i, j, k + 1)) {
            flag = true;
        }
        if (flag) {
            this.func_259_b_(world, i, j, k, world.getBlockDmg(i, j, k));
            world.setBlock(i, j, k, 0);
        } else if (l > 0 && Block.allBlocks[l].func_209_d() && MinecartTrackLogic.func_791_a(new MinecartTrackLogic(this, world, i, j, k)) == 3) {
            this.func_304_h(world, i, j, k);
        }
    }

    private void func_304_h(World world, int i, int j, int k) {
        new MinecartTrackLogic(this, world, i, j, k).func_792_a(world.func_625_o(i, j, k));
    }
}

