/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.gui;

import com.mojang.minecraft.entity.EntityChicken;
import com.mojang.minecraft.entity.EntityCow;
import com.mojang.minecraft.entity.EntityCreeper;
import com.mojang.minecraft.entity.EntityItem;
import com.mojang.minecraft.entity.EntityLiving;
import com.mojang.minecraft.entity.EntityMob;
import com.mojang.minecraft.entity.EntityMobs;
import com.mojang.minecraft.entity.EntityPig;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.EntitySheep;
import com.mojang.minecraft.entity.EntitySkeleton;
import com.mojang.minecraft.entity.EntitySlime;
import com.mojang.minecraft.entity.EntitySpider;
import com.mojang.minecraft.entity.EntityZombie;
import com.mojang.minecraft.entity.EntityZombieSimple;
import com.mojang.minecraft.entity.item.Item;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.gui.GuiScreen;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.player.controller.PlayerControllerCreative;
import com.mojang.minecraft.player.controller.PlayerControllerSP;
import com.mojang.minecraft.util.IdMap;
import java.io.UnsupportedEncodingException;
import java.util.Random;
import org.lwjgl.input.Keyboard;

public class GuiChat
extends GuiScreen {
    static String[] PLAYER_COLORS = new String[]{"c", "b", "a", "5", "6", "e", "d", "7"};
    private String field_985_a = "";
    private int field_986_h = 0;

    @Override
    public void func_575_a() {
        Keyboard.enableRepeatEvents((boolean)true);
    }

    @Override
    public void func_576_h() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    @Override
    public void func_570_g() {
        ++this.field_986_h;
    }

    public void sendText(String s) {
        this.mc.field_164_u.func_552_a(s);
    }

    public static String computePlayerColor(String name) {
        byte[] pName = null;
        try {
            pName = name.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        int length = pName.length;
        int oddShift = 1 - length % 2;
        int value = 0;
        int i = 0;
        while (i < length) {
            byte by = pName[i];
            int rev = length - (i + 1) + oddShift;
            value = rev % 4 >= 2 ? (value -= by) : (value += by);
            ++i;
        }
        if ((value %= 8) < 0) {
            value = PLAYER_COLORS.length + value;
        }
        System.out.println(value);
        return PLAYER_COLORS[value];
    }

    @Override
    protected void close(char c, int i) {
        if (i == 1) {
            this.mc.setCurrentScreen(null);
            return;
        }
        if (i == 28) {
            String s = this.field_985_a.trim();
            if (s.length() > 0) {
                this.mc.player.func_461_a(this.field_985_a.trim());
            }
            this.mc.setCurrentScreen(null);
            if (!this.mc.isServer()) {
                if (this.field_985_a.startsWith("/") && !this.mc.player.worldObj.cheatsDisabled) {
                    this.handleCommand(this.field_985_a.replaceFirst("/", ""));
                } else if (!this.field_985_a.startsWith("/")) {
                    this.sendText("<\u00a7" + GuiChat.computePlayerColor(this.mc.field_176_i.username) + this.mc.field_176_i.username + "\u00a7f> " + this.field_985_a);
                }
            }
            return;
        }
        if (i == 14 && this.field_985_a.length() > 0) {
            this.field_985_a = this.field_985_a.substring(0, this.field_985_a.length() - 1);
        }
        if (" !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_'abcdefghijklmnopqrstuvwxyz{|}~\u2302\u00c7\u00fc\u00e9\u00e2\u00e4\u00e0\u00e5\u00e7\u00ea\u00eb\u00e8\u00ef\u00ee\u00ec\u00c4\u00c5\u00c9\u00e6\u00c6\u00f4\u00f6\u00f2\u00fb\u00f9\u00ff\u00d6\u00dc\u00f8\u00a3\u00d8\u00d7\u0192\u00e1\u00ed\u00f3\u00fa\u00f1\u00d1\u00aa\u00ba\u00bf\u00ae\u00ac\u00bd\u00bc\u00a1\u00ab\u00bb".indexOf(c) >= 0 && this.field_985_a.length() < 100) {
            this.field_985_a = String.valueOf(this.field_985_a) + c;
        }
    }

    private Block getBlockIfExist(int id) {
        int i = 0;
        while (i < Block.allBlocks.length) {
            if (Block.allBlocks[i] != null && Block.allBlocks[i].blockID == id) {
                return Block.allBlocks[i];
            }
            ++i;
        }
        return null;
    }

    private Item getItemIfExist(int id) {
        int i = 0;
        while (i < Item.itemsList.length) {
            if (Item.itemsList[i] != null && Item.itemsList[i].swiftedIndex == id) {
                return Item.itemsList[i];
            }
            ++i;
        }
        return null;
    }

    private void handleCommand(String command) {
        String[] commandArgs = command.split(" ");
        if (commandArgs[0].equalsIgnoreCase("give") || commandArgs[0].equalsIgnoreCase("i")) {
            block88: {
                if (commandArgs.length <= 3 && commandArgs.length >= 2) {
                    try {
                        int id;
                        block87: {
                            id = 0;
                            try {
                                id = Integer.parseInt(commandArgs[1]);
                            }
                            catch (Exception ex) {
                                id = IdMap.getItem(commandArgs[1]);
                                if (id != -1) break block87;
                                this.sendText("Invalid item: " + commandArgs[1]);
                                if (commandArgs[1].equals("null")) {
                                    this.mc.func_105_a(null, "");
                                }
                                return;
                            }
                        }
                        Block blk = this.getBlockIfExist(id);
                        Item itm = null;
                        int size = 64;
                        if (commandArgs.length == 3) {
                            size = Integer.parseInt(commandArgs[2]);
                        }
                        if (blk == null) {
                            itm = this.getItemIfExist(id);
                            if (itm != null) {
                                if (commandArgs.length < 3) {
                                    size = itm.maxStackSize;
                                }
                                this.sendText("Giving " + size + " of item " + id);
                                EntityItem entityitem = new EntityItem(this.mc.player.worldObj, this.mc.player.posX, this.mc.player.posY, this.mc.player.posZ, new ItemStack(itm, size));
                                entityitem.field_805_c = 10;
                                this.mc.player.worldObj.addNewEntity(entityitem);
                            } else {
                                this.sendText("\u00a7cInvalid item: " + id);
                            }
                            break block88;
                        }
                        this.sendText("Giving " + size + " of item " + id);
                        EntityItem entityitem = new EntityItem(this.mc.player.worldObj, this.mc.player.posX, this.mc.player.posY, this.mc.player.posZ, new ItemStack(blk, size));
                        entityitem.field_805_c = 10;
                        this.mc.player.worldObj.addNewEntity(entityitem);
                    }
                    catch (Exception ex) {
                        this.sendText("\u00a7cInvalid syntax for command: " + command);
                        ex.printStackTrace();
                    }
                } else if (commandArgs.length < 2) {
                    this.sendText("\u00a7cThis requires 2 or more arguments!");
                } else {
                    this.sendText("\u00a7cThis command cannot accept more than 3 arguments!");
                }
            }
            return;
        }
        if (commandArgs.length == 2) {
            if (commandArgs[0].equalsIgnoreCase("setwinter")) {
                try {
                    commandArgs[1] = commandArgs[1].toLowerCase();
                    if (commandArgs[1].equalsIgnoreCase("true") || commandArgs[1].equalsIgnoreCase("false")) {
                        this.mc.player.worldObj.snowCovered = Boolean.parseBoolean(commandArgs[1]);
                    } else {
                        this.sendText("\u00a7cYou cannot set winter to " + commandArgs[1] + "!");
                    }
                }
                catch (Exception ex) {
                    this.sendText("\u00a7cInvalid syntax for command: " + command);
                    ex.printStackTrace();
                }
                return;
            }
            if (commandArgs[0].equalsIgnoreCase("summon")) {
                Random rand = new Random();
                EntityLiving entitysummon = null;
                if (commandArgs[1].equalsIgnoreCase("slime")) {
                    entitysummon = new EntitySlime(this.mc.player.worldObj);
                } else if (commandArgs[1].equalsIgnoreCase("mob")) {
                    entitysummon = new EntityMob(this.mc.player.worldObj);
                } else if (commandArgs[1].equalsIgnoreCase("monster")) {
                    entitysummon = new EntityMobs(this.mc.player.worldObj);
                } else if (commandArgs[1].equalsIgnoreCase("zombie")) {
                    entitysummon = new EntityZombie(this.mc.player.worldObj);
                } else if (commandArgs[1].equalsIgnoreCase("creeper")) {
                    entitysummon = new EntityCreeper(this.mc.player.worldObj);
                } else if (commandArgs[1].equalsIgnoreCase("skeleton")) {
                    entitysummon = new EntitySkeleton(this.mc.player.worldObj);
                } else if (commandArgs[1].equalsIgnoreCase("sheep")) {
                    entitysummon = new EntitySheep(this.mc.player.worldObj);
                } else if (commandArgs[1].equalsIgnoreCase("pig")) {
                    entitysummon = new EntityPig(this.mc.player.worldObj);
                } else if (commandArgs[1].equalsIgnoreCase("cow")) {
                    entitysummon = new EntityCow(this.mc.player.worldObj);
                } else if (commandArgs[1].equalsIgnoreCase("chicken")) {
                    entitysummon = new EntityChicken(this.mc.player.worldObj);
                } else if (commandArgs[1].equalsIgnoreCase("giant")) {
                    entitysummon = new EntityZombieSimple(this.mc.player.worldObj);
                } else if (commandArgs[1].equalsIgnoreCase("spider")) {
                    entitysummon = new EntitySpider(this.mc.player.worldObj);
                } else if (commandArgs[1].equalsIgnoreCase("player")) {
                    entitysummon = new EntityPlayer(this.mc.player.worldObj);
                }
                if (entitysummon != null) {
                    entitysummon.spawnNewEntity(this.mc.player.posX, this.mc.player.posY + 0.5, this.mc.player.posZ, rand.nextFloat() * 360.0f, 0.0f);
                    this.mc.player.worldObj.addNewEntity(entitysummon);
                } else {
                    this.sendText("\u00a7cA " + commandArgs[1] + " is not a valid entity!");
                }
                return;
            }
            if (commandArgs[0].equalsIgnoreCase("gamemode")) {
                if (commandArgs[1].equalsIgnoreCase("survival")) {
                    this.mc.playerController = new PlayerControllerSP(this.mc);
                    this.mc.player.isCreative = false;
                    this.sendText("Your game mode has been set to survival.");
                } else if (commandArgs[1].equalsIgnoreCase("creative")) {
                    this.mc.playerController = new PlayerControllerCreative(this.mc);
                    this.mc.player.isCreative = true;
                    this.sendText("Your game mode has been set to creative.");
                } else {
                    this.sendText("\u00a7c" + commandArgs[1] + " is not a valid game mode!");
                }
                return;
            }
        } else if (commandArgs.length == 3) {
            if (commandArgs[0].equalsIgnoreCase("time")) {
                try {
                    if (commandArgs[1].equalsIgnoreCase("add")) {
                        int ticks = Integer.parseInt(commandArgs[2]);
                        this.mc.player.worldObj.worldTime += (long)ticks;
                    } else if (commandArgs[1].equalsIgnoreCase("set")) {
                        if (commandArgs[2].equalsIgnoreCase("day")) {
                            this.mc.player.worldObj.worldTime = 0L;
                        } else if (commandArgs[2].equalsIgnoreCase("night")) {
                            this.mc.player.worldObj.worldTime = 13000L;
                        } else {
                            int ticks = Integer.parseInt(commandArgs[2]);
                            this.mc.player.worldObj.worldTime = ticks;
                        }
                    } else {
                        this.sendText("\u00a7cInvalid parameter for time command: " + commandArgs[1] + ". Use 'add' or 'set'");
                    }
                }
                catch (Exception ex) {
                    this.sendText("\u00a7cInvalid syntax for command: " + command);
                    ex.printStackTrace();
                }
                return;
            }
        } else if (commandArgs.length == 4) {
            if (commandArgs[0].equalsIgnoreCase("give") || commandArgs[0].equalsIgnoreCase("i")) {
                try {
                    int id = Integer.parseInt(commandArgs[1]);
                    int size = Integer.parseInt(commandArgs[2]);
                    int damage = Integer.parseInt(commandArgs[3]);
                    Block blk = this.getBlockIfExist(id);
                    Item itm = null;
                    if (blk == null) {
                        itm = this.getItemIfExist(id);
                        if (itm != null) {
                            this.sendText("Giving " + size + " of item " + id + " with damage " + damage);
                            EntityItem entityitem = new EntityItem(this.mc.player.worldObj, this.mc.player.posX, this.mc.player.posY, this.mc.player.posZ, new ItemStack(itm.swiftedIndex, size, damage));
                            entityitem.field_805_c = 10;
                            this.mc.player.worldObj.addNewEntity(entityitem);
                        } else {
                            this.sendText("\u00a7cInvalid item: " + id);
                        }
                    } else {
                        this.sendText("Giving " + size + " of item " + id + " with damage " + damage);
                        this.sendText("Damage invalid for block, ignoring");
                        EntityItem entityitem = new EntityItem(this.mc.player.worldObj, this.mc.player.posX, this.mc.player.posY, this.mc.player.posZ, new ItemStack(blk, size));
                        entityitem.field_805_c = 10;
                        this.mc.player.worldObj.addNewEntity(entityitem);
                    }
                }
                catch (Exception ex) {
                    this.sendText("\u00a7cInvalid syntax for command: " + command);
                    ex.printStackTrace();
                }
                return;
            }
            if (commandArgs[0].equalsIgnoreCase("teleport") || commandArgs[0].equalsIgnoreCase("tp")) {
                try {
                    int x = Integer.parseInt(commandArgs[1]);
                    int y = Integer.parseInt(commandArgs[2]);
                    int z = Integer.parseInt(commandArgs[3]);
                    if (this.mc.player.worldObj.getBlock(x, y, z) != 0) {
                        // empty if block
                    }
                    y = this.getHighestBlock(this.mc.player.worldObj, x, y, z);
                    this.mc.player.moveToPosDouble(x, y, z);
                }
                catch (Exception ex) {
                    this.sendText("\u00a7cInvalid syntax for command: " + command);
                    ex.printStackTrace();
                }
                return;
            }
        } else if (commandArgs.length == 1) {
            if (commandArgs[0].equalsIgnoreCase("spawn")) {
                try {
                    int x = this.mc.player.worldObj.spawnX;
                    int y = this.mc.player.worldObj.spawnY;
                    int z = this.mc.player.worldObj.spawnZ;
                    if (this.mc.player.worldObj.getBlock(x, y, z) != 0) {
                        // empty if block
                    }
                    y = this.getHighestBlock(this.mc.player.worldObj, x, y, z);
                    this.mc.player.moveToPosDouble(x, y, z);
                }
                catch (Exception ex) {
                    this.sendText("\u00a7cInvalid syntax for command: " + command);
                    ex.printStackTrace();
                }
                return;
            }
            if (commandArgs[0].equalsIgnoreCase("help")) {
                this.sendText("\u00a7b---------------Command help (Page 1 of 1)---------------");
                this.sendText("\u00a7e/teleport/tp <x> <y> <z> - teleport to a location");
                this.sendText("\u00a7e/give <item> [quantity] - gives requested item");
                this.sendText("\u00a7e/i <item> [quantity] - alias to give");
                this.sendText("\u00a7e/time <set/add> <ticks> - changes the time");
                this.sendText("\u00a7e/setwinter <true/false> - sets the world's climate");
                this.sendText("\u00a7e/summon <entity> - spawns the requested entity");
                this.sendText("\u00a7e/spawn - sends you to the spawn location");
                this.sendText("\u00a7e/gamemode <survival/creative> - sets your current gamemode");
                this.sendText("\u00a7b-----------------------------------------------------");
                return;
            }
        }
        this.sendText("\u00a7cInvalid command: " + command);
    }

    private int getHighestBlock(World world, int x, int y, int z) {
        int i = 128;
        while (i > 0) {
            if (world.getBlock(x, i, z) != 0) {
                return i + 2;
            }
            --i;
        }
        return 0;
    }

    @Override
    public void func_571_a(int i, int j, float f) {
        this.func_551_a(2, this.height - 14, this.width - 2, this.height - 2, Integer.MIN_VALUE);
        this.func_547_b(this.fontRenderer, "> " + this.field_985_a + (this.field_986_h / 6 % 2 != 0 ? "" : "_"), 4, this.height - 12, 0xE0E0E0);
    }

    @Override
    protected void func_565_a(int i, int j, int k) {
        System.out.println(this.field_985_a);
        if (k != 0 || this.mc.field_164_u.field_933_a == null) {
            return;
        }
        if (this.field_985_a.length() > 0 && !this.field_985_a.endsWith(" ")) {
            this.field_985_a = String.valueOf(this.field_985_a) + " ";
        }
        this.field_985_a = String.valueOf(this.field_985_a) + this.mc.field_164_u.field_933_a;
        int byte0 = 100;
        if (this.field_985_a.length() > byte0) {
            this.field_985_a = this.field_985_a.substring(0, byte0);
        }
    }
}

