/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.generate;

import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.generate.WorldGenerator;
import com.mojang.minecraft.level.tile.Block;
import java.util.Random;

public class WorldGenTrees
extends WorldGenerator {
    @Override
    public boolean tryGen(World world, Random random, int i, int j, int k) {
        int l = random.nextInt(3) + 4;
        boolean flag = true;
        if (j < 1 || j + l + 1 > 128) {
            return false;
        }
        int i1 = j;
        while (i1 <= j + 1 + l) {
            int byte0 = 1;
            if (i1 == j) {
                byte0 = 0;
            }
            if (i1 >= j + 1 + l - 2) {
                byte0 = 2;
            }
            int i2 = i - byte0;
            while (i2 <= i + byte0 && flag) {
                int l2 = k - byte0;
                while (l2 <= k + byte0 && flag) {
                    if (i1 >= 0 && i1 < 128) {
                        int j3 = world.getBlock(i2, i1, l2);
                        if (j3 != 0 && j3 != Block.leaves.blockID) {
                            flag = false;
                        }
                    } else {
                        flag = false;
                    }
                    ++l2;
                }
                ++i2;
            }
            ++i1;
        }
        if (!flag) {
            return false;
        }
        int j1 = world.getBlock(i, j - 1, k);
        if (j1 != Block.grass.blockID && j1 != Block.dirt.blockID || j >= 128 - l - 1) {
            return false;
        }
        world.func_634_a(i, j - 1, k, Block.dirt.blockID);
        int k1 = j - 3 + l;
        while (k1 <= j + l) {
            int j2 = k1 - (j + l);
            int i3 = 1 - j2 / 2;
            int k3 = i - i3;
            while (k3 <= i + i3) {
                int l3 = k3 - i;
                int i4 = k - i3;
                while (i4 <= k + i3) {
                    int j4 = i4 - k;
                    if ((Math.abs(l3) != i3 || Math.abs(j4) != i3 || random.nextInt(2) != 0 && j2 != 0) && !Block.opaqueCubeLookup[world.getBlock(k3, k1, i4)]) {
                        world.func_634_a(k3, k1, i4, Block.leaves.blockID);
                    }
                    ++i4;
                }
                ++k3;
            }
            ++k1;
        }
        int l1 = 0;
        while (l1 < l) {
            int k2 = world.getBlock(i, j + l1, k);
            if (k2 == 0 || k2 == Block.leaves.blockID) {
                world.func_634_a(i, j + l1, k, Block.wood.blockID);
            }
            ++l1;
        }
        return true;
    }
}

