/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.material.Material;
import com.mojang.minecraft.level.tile.phys.AxisAlignedBB;
import java.util.Random;

public class BlockCactus
extends Block {
    protected BlockCactus(int i, int j) {
        super(i, j, Material.cactus);
        this.setTickRandomly(true);
    }

    @Override
    public void update(World world, int i, int j, int k, Random random) {
        if (world.getBlock(i, j + 1, k) == 0) {
            int l = 1;
            while (world.getBlock(i, j - l, k) == this.blockID) {
                ++l;
            }
            if (l < 3) {
                int i1 = world.getBlockDmg(i, j, k);
                if (i1 == 15) {
                    world.setBlock(i, j + 1, k, this.blockID);
                    world.func_691_b(i, j, k, 0);
                } else {
                    world.func_691_b(i, j, k, i1 + 1);
                }
            }
        }
    }

    @Override
    public AxisAlignedBB func_221_d(World world, int i, int j, int k) {
        float f = 0.0625f;
        return AxisAlignedBB.func_1161_b((float)i + f, j, (float)k + f, (float)(i + 1) - f, (float)(j + 1) - f, (float)(k + 1) - f);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        float f = 0.0625f;
        return AxisAlignedBB.func_1161_b((float)i + f, j, (float)k + f, (float)(i + 1) - f, j + 1, (float)(k + 1) - f);
    }

    @Override
    public int getTextureIndex(int i) {
        if (i == 1) {
            return this.textureIndex - 1;
        }
        if (i == 0) {
            return this.textureIndex + 1;
        }
        return this.textureIndex;
    }

    @Override
    public boolean func_242_c() {
        return false;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public int getRenderType() {
        return 13;
    }

    @Override
    public boolean canPlace(World world, int i, int j, int k) {
        if (!super.canPlace(world, i, j, k)) {
            return false;
        }
        return this.canBlockStay(world, i, j, k);
    }

    @Override
    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        if (!this.canBlockStay(world, i, j, k)) {
            this.func_259_b_(world, i, j, k, world.getBlockDmg(i, j, k));
            world.setBlock(i, j, k, 0);
        }
    }

    @Override
    public boolean canBlockStay(World world, int i, int j, int k) {
        if (world.getMaterialXYZ(i - 1, j, k).isSolidMaterial()) {
            return false;
        }
        if (world.getMaterialXYZ(i + 1, j, k).isSolidMaterial()) {
            return false;
        }
        if (world.getMaterialXYZ(i, j, k - 1).isSolidMaterial()) {
            return false;
        }
        if (world.getMaterialXYZ(i, j, k + 1).isSolidMaterial()) {
            return false;
        }
        int l = world.getBlock(i, j - 1, k);
        return l == Block.cactus.blockID || l == Block.sand.blockID;
    }

    @Override
    public void func_236_b(World world, int i, int j, int k, Entity entity) {
        entity.attacked(null, 1);
    }
}

