/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.material.Material;
import com.mojang.minecraft.level.tile.phys.AxisAlignedBB;
import java.util.Random;

public class BlockFlower
extends Block {
    protected BlockFlower(int i, int j) {
        super(i, Material.plants);
        this.textureIndex = j;
        this.setTickRandomly(true);
        float f = 0.2f;
        this.setBlockBounds(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, f * 3.0f, 0.5f + f);
    }

    @Override
    public boolean canPlace(World world, int i, int j, int k) {
        return this.canThisPlantGrowOnThisBlockID(world.getBlock(i, j - 1, k));
    }

    protected boolean canThisPlantGrowOnThisBlockID(int i) {
        return i == Block.grass.blockID || i == Block.dirt.blockID || i == Block.tilledField.blockID;
    }

    @Override
    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        super.onNeighborBlockChange(world, i, j, k, l);
        this.func_268_h(world, i, j, k);
    }

    @Override
    public void update(World world, int i, int j, int k, Random random) {
        this.func_268_h(world, i, j, k);
    }

    protected final void func_268_h(World world, int i, int j, int k) {
        if (!this.canBlockStay(world, i, j, k)) {
            this.func_259_b_(world, i, j, k, world.getBlockDmg(i, j, k));
            world.setBlock(i, j, k, 0);
        }
    }

    @Override
    public boolean canBlockStay(World world, int i, int j, int k) {
        return (world.func_618_j(i, j, k) >= 8 || world.func_647_i(i, j, k)) && this.canThisPlantGrowOnThisBlockID(world.getBlock(i, j - 1, k));
    }

    @Override
    public AxisAlignedBB func_221_d(World world, int i, int j, int k) {
        return null;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean func_242_c() {
        return false;
    }

    @Override
    public int getRenderType() {
        return 1;
    }
}

