/*
 * Decompiled with CFR 0.152.
 */
package org.json.simple;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONAware;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class JSONValue {
    public static Object parse(Reader in) {
        try {
            JSONParser parser = new JSONParser();
            return parser.parse(in);
        }
        catch (Exception e2) {
            return null;
        }
    }

    public static Object parse(String s2) {
        StringReader in = new StringReader(s2);
        return JSONValue.parse(in);
    }

    public static Object parseWithException(Reader in) throws IOException, ParseException {
        JSONParser parser = new JSONParser();
        return parser.parse(in);
    }

    public static Object parseWithException(String s2) throws ParseException {
        JSONParser parser = new JSONParser();
        return parser.parse(s2);
    }

    public static void writeJSONString(Object value, Writer out) throws IOException {
        if (value == null) {
            out.write("null");
            return;
        }
        if (value instanceof String) {
            out.write(34);
            out.write(JSONValue.escape((String)value));
            out.write(34);
            return;
        }
        if (value instanceof Double) {
            if (((Double)value).isInfinite() || ((Double)value).isNaN()) {
                out.write("null");
            } else {
                out.write(value.toString());
            }
            return;
        }
        if (value instanceof Float) {
            if (((Float)value).isInfinite() || ((Float)value).isNaN()) {
                out.write("null");
            } else {
                out.write(value.toString());
            }
            return;
        }
        if (value instanceof Number) {
            out.write(value.toString());
            return;
        }
        if (value instanceof Boolean) {
            out.write(value.toString());
            return;
        }
        if (value instanceof JSONStreamAware) {
            ((JSONStreamAware)value).writeJSONString(out);
            return;
        }
        if (value instanceof JSONAware) {
            out.write(((JSONAware)value).toJSONString());
            return;
        }
        if (value instanceof Map) {
            JSONObject.writeJSONString((Map)value, out);
            return;
        }
        if (value instanceof List) {
            JSONArray.writeJSONString((List)value, out);
            return;
        }
        out.write(value.toString());
    }

    public static String toJSONString(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof String) {
            return "\"" + JSONValue.escape((String)value) + "\"";
        }
        if (value instanceof Double) {
            if (((Double)value).isInfinite() || ((Double)value).isNaN()) {
                return "null";
            }
            return value.toString();
        }
        if (value instanceof Float) {
            if (((Float)value).isInfinite() || ((Float)value).isNaN()) {
                return "null";
            }
            return value.toString();
        }
        if (value instanceof Number) {
            return value.toString();
        }
        if (value instanceof Boolean) {
            return value.toString();
        }
        if (value instanceof JSONAware) {
            return ((JSONAware)value).toJSONString();
        }
        if (value instanceof Map) {
            return JSONObject.toJSONString((Map)value);
        }
        if (value instanceof List) {
            return JSONArray.toJSONString((List)value);
        }
        return value.toString();
    }

    public static String escape(String s2) {
        if (s2 == null) {
            return null;
        }
        StringBuffer sb2 = new StringBuffer();
        JSONValue.escape(s2, sb2);
        return sb2.toString();
    }

    static void escape(String s2, StringBuffer sb2) {
        block10: for (int i2 = 0; i2 < s2.length(); ++i2) {
            char ch2 = s2.charAt(i2);
            switch (ch2) {
                case '\"': {
                    sb2.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    sb2.append("\\\\");
                    continue block10;
                }
                case '\b': {
                    sb2.append("\\b");
                    continue block10;
                }
                case '\f': {
                    sb2.append("\\f");
                    continue block10;
                }
                case '\n': {
                    sb2.append("\\n");
                    continue block10;
                }
                case '\r': {
                    sb2.append("\\r");
                    continue block10;
                }
                case '\t': {
                    sb2.append("\\t");
                    continue block10;
                }
                case '/': {
                    sb2.append("\\/");
                    continue block10;
                }
                default: {
                    if (ch2 >= '\u0000' && ch2 <= '\u001f' || ch2 >= '\u007f' && ch2 <= '\u009f' || ch2 >= '\u2000' && ch2 <= '\u20ff') {
                        String ss2 = Integer.toHexString(ch2);
                        sb2.append("\\u");
                        for (int k2 = 0; k2 < 4 - ss2.length(); ++k2) {
                            sb2.append('0');
                        }
                        sb2.append(ss2.toUpperCase());
                        continue block10;
                    }
                    sb2.append(ch2);
                }
            }
        }
    }
}

