/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft;

import com.mojang.minecraft.HitResult;
import com.mojang.minecraft.Player;
import com.mojang.minecraft.Textures;
import com.mojang.minecraft.Timer;
import com.mojang.minecraft.character.Zombie;
import com.mojang.minecraft.gui.Font;
import com.mojang.minecraft.gui.Gui;
import com.mojang.minecraft.gui.GuiDisclaimer;
import com.mojang.minecraft.gui.GuiIngame;
import com.mojang.minecraft.gui.GuiTitle;
import com.mojang.minecraft.gui.PauseMenu;
import com.mojang.minecraft.level.Chunk;
import com.mojang.minecraft.level.Frustum;
import com.mojang.minecraft.level.Level;
import com.mojang.minecraft.level.LevelRenderer;
import com.mojang.minecraft.level.Tesselator;
import com.mojang.minecraft.level.tile.Tile;
import com.mojang.minecraft.particle.ParticleEngine;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;

public class RubyDung
implements Runnable {
    private static final boolean FULLSCREEN_MODE = false;
    public int width;
    public int height;
    private FloatBuffer fogColor0 = BufferUtils.createFloatBuffer((int)4);
    private FloatBuffer fogColor1 = BufferUtils.createFloatBuffer((int)4);
    private Timer timer = new Timer(20.0f);
    public Level level;
    public LevelRenderer levelRenderer;
    public Player player;
    private int paintTexture = 1;
    public ParticleEngine particleEngine;
    private ArrayList<Zombie> zombies;
    private IntBuffer viewportBuffer;
    private IntBuffer selectBuffer;
    private HitResult hitResult = null;
    FloatBuffer lb;
    public Gui gui = null;
    public Textures textures = new Textures();
    public int tickCount = 0;
    boolean disclaimerDeath = false;
    public Font font;
    public int fpsCount;

    public RubyDung() {
        this.zombies = new ArrayList();
        this.viewportBuffer = BufferUtils.createIntBuffer((int)16);
        this.selectBuffer = BufferUtils.createIntBuffer((int)2000);
        this.lb = BufferUtils.createFloatBuffer((int)16);
    }

    public void init() throws LWJGLException, IOException {
        int v1 = 16710650;
        int v2 = 920330;
        float v3 = 0.5f;
        float v4 = 0.8f;
        float v5 = 1.0f;
        this.fogColor0.put(new float[]{0.05490196f, 0.043137256f, 0.039215688f, 1.0f});
        this.fogColor0.flip();
        this.fogColor1.put(new float[]{0.05490196f, 0.043137256f, 0.039215688f, 1.0f});
        this.fogColor1.flip();
        Display.setDisplayMode((DisplayMode)new DisplayMode(1024, 768));
        Display.setTitle((String)"RubyRevived");
        Display.create();
        Keyboard.create();
        Mouse.create();
        this.width = Display.getDisplayMode().getWidth();
        this.height = Display.getDisplayMode().getHeight();
        GL11.glEnable((int)3553);
        GL11.glShadeModel((int)7425);
        GL11.glClearDepth((double)1.0);
        GL11.glEnable((int)2929);
        GL11.glDepthFunc((int)515);
        GL11.glEnable((int)3008);
        GL11.glAlphaFunc((int)516, (float)0.5f);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glMatrixMode((int)5888);
        this.font = new Font("/default.gif", this.textures);
        this.level = new Level(256, 256, 64);
        this.levelRenderer = new LevelRenderer(this, this.level);
        this.player = new Player(this, this.level);
        this.particleEngine = new ParticleEngine(this, this.level);
        int v6 = 0;
        while (v6 < 10) {
            Zombie v7 = new Zombie(this, this.level, 128.0f, 0.0f, 128.0f);
            v7.resetPos();
            this.zombies.add(v7);
            ++v6;
        }
        try {
            this.setCurrentScreen(new GuiDisclaimer());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setCurrentScreen(new GuiTitle());
        }
    }

    public void resetLevel() {
        RubyDung game = this;
        game.level = null;
        game.level = new Level(256, 256, 64, 1);
        game.levelRenderer = null;
        game.player = null;
        game.particleEngine = null;
        game.levelRenderer = new LevelRenderer(game, game.level);
        game.player = new Player(game, game.level);
        game.particleEngine = new ParticleEngine(game, game.level);
    }

    public final void grabMouse() {
        Mouse.setGrabbed((boolean)true);
    }

    public final void releaseMouse() {
        Mouse.setGrabbed((boolean)false);
    }

    public final void setCurrentScreen(Gui dVar) {
        if (this.gui != null) {
            this.gui.onGuiClosed();
        }
        this.gui = dVar;
        if (dVar != null) {
            this.releaseMouse();
            dVar.setResolution(this, this.width * 240 / this.height, this.height * 240 / this.height);
        } else {
            this.grabMouse();
        }
    }

    public void destroy() {
        Mouse.destroy();
        Keyboard.destroy();
        Display.destroy();
    }

    @Override
    public void run() {
        try {
            this.init();
        }
        catch (Exception v1) {
            JOptionPane.showMessageDialog(null, v1.toString(), "Failed to start RubyDung", 0);
            System.exit(0);
            v1.printStackTrace();
        }
        long v2 = System.currentTimeMillis();
        int v3 = 0;
        try {
            try {
                while (!Keyboard.isKeyDown((int)6)) {
                    if (Display.isCloseRequested()) {
                        break;
                    }
                    this.timer.advanceTime();
                    int v4 = 0;
                    while (v4 < this.timer.ticks) {
                        this.tick();
                        ++v4;
                    }
                    this.render(this.timer.a);
                    ++v3;
                    while (System.currentTimeMillis() >= v2 + 1000L) {
                        this.fpsCount = v3;
                        Chunk.updates = 0;
                        v2 += 1000L;
                        v3 = 0;
                    }
                }
            }
            catch (Exception v5) {
                v5.printStackTrace();
                this.destroy();
                return;
            }
        }
        finally {
            this.destroy();
        }
        this.destroy();
    }

    public void tick() {
        ++this.tickCount;
        if (this.tickCount > 50 && this.tickCount <= 51) {
            this.disclaimerDeath = true;
        }
        if (this.disclaimerDeath) {
            this.disclaimerDeath = false;
            this.setCurrentScreen(new GuiTitle());
        }
        while (Keyboard.next()) {
            if (!Keyboard.getEventKeyState()) continue;
            if (Keyboard.getEventKey() == 1) {
                this.releaseMouse();
                this.setCurrentScreen(new PauseMenu());
            }
            if (Keyboard.getEventKey() == 28) {
                this.level.save();
            }
            if (Keyboard.getEventKey() == 2) {
                this.paintTexture = 1;
            }
            if (Keyboard.getEventKey() == 3) {
                this.paintTexture = 2;
            }
            if (Keyboard.getEventKey() != 34) continue;
            this.zombies.add(new Zombie(this, this.level, this.player.x, this.player.y, this.player.z));
        }
        if (this.gui != null) {
            this.gui.updateEvents();
            if (this.gui != null) {
                try {
                    this.gui.updateScreen();
                }
                catch (Exception error) {
                    error.printStackTrace();
                }
            }
        }
        if (this.gui == null && this.level != null) {
            this.setCurrentScreen(new GuiIngame());
            this.grabMouse();
        }
        if (this.level != null) {
            this.level.tick();
            this.particleEngine.tick();
            int v1 = 0;
            while (v1 < this.zombies.size()) {
                this.zombies.get(v1).tick();
                if (this.zombies.get((int)v1).removed) {
                    this.zombies.remove(v1--);
                }
                ++v1;
            }
        }
        this.player.tick();
    }

    private void moveCameraToPlayer(float a1) {
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.3f);
        GL11.glRotatef((float)this.player.xRot, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)this.player.yRot, (float)0.0f, (float)1.0f, (float)0.0f);
        float v1 = this.player.xo + (this.player.x - this.player.xo) * a1;
        float v2 = this.player.yo + (this.player.y - this.player.yo) * a1;
        float v3 = this.player.zo + (this.player.z - this.player.zo) * a1;
        GL11.glTranslatef((float)(-v1), (float)(-v2), (float)(-v3));
    }

    private void setupCamera(float a1) {
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GLU.gluPerspective((float)70.0f, (float)((float)this.width / (float)this.height), (float)0.05f, (float)1000.0f);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        this.moveCameraToPlayer(a1);
    }

    private void setupPickCamera(float a1, int a2, int a3) {
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        this.viewportBuffer.clear();
        GL11.glGetInteger((int)2978, (IntBuffer)this.viewportBuffer);
        this.viewportBuffer.flip();
        this.viewportBuffer.limit(16);
        GLU.gluPickMatrix((float)a2, (float)a3, (float)5.0f, (float)5.0f, (IntBuffer)this.viewportBuffer);
        GLU.gluPerspective((float)70.0f, (float)(this.width / this.height), (float)0.05f, (float)1000.0f);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        this.moveCameraToPlayer(a1);
    }

    private void pick(float a1) {
        this.selectBuffer.clear();
        GL11.glSelectBuffer((IntBuffer)this.selectBuffer);
        GL11.glRenderMode((int)7170);
        this.setupPickCamera(a1, this.width / 2, this.height / 2);
        this.levelRenderer.pick(this.player, Frustum.getFrustum());
        int v1 = GL11.glRenderMode((int)7168);
        this.selectBuffer.flip();
        this.selectBuffer.limit(this.selectBuffer.capacity());
        long v2 = 0L;
        int[] v3 = new int[10];
        int v4 = 0;
        int v5 = 0;
        while (v5 < v1) {
            int v9;
            int v6 = this.selectBuffer.get();
            long v7 = this.selectBuffer.get();
            this.selectBuffer.get();
            long v8 = v7;
            if (v8 < v2 || v5 == 0) {
                v2 = v8;
                v4 = v6;
                v9 = 0;
                while (v9 < v6) {
                    v3[v9] = this.selectBuffer.get();
                    ++v9;
                }
            } else {
                v9 = 0;
                while (v9 < v6) {
                    this.selectBuffer.get();
                    ++v9;
                }
            }
            ++v5;
        }
        this.hitResult = v4 > 0 ? new HitResult(v3[0], v3[1], v3[2], v3[3], v3[4]) : null;
    }

    public void render(float a1) {
        int v6;
        float v1 = Mouse.getDX();
        float v2 = Mouse.getDY();
        if (!(this.gui instanceof PauseMenu)) {
            this.player.turn(v1, v2);
        }
        this.pick(a1);
        if (this.gui instanceof GuiIngame) {
            while (Mouse.next()) {
                if (Mouse.getEventButton() == 1 && Mouse.getEventButtonState() && this.hitResult != null) {
                    Tile v3 = Tile.tiles[this.level.getTile(this.hitResult.x, this.hitResult.y, this.hitResult.z)];
                    boolean v4 = this.level.setTile(this.hitResult.x, this.hitResult.y, this.hitResult.z, 0);
                    if (v3 != null && v4) {
                        v3.destroy(this.level, this.hitResult.x, this.hitResult.y, this.hitResult.z, this.particleEngine);
                    }
                }
                if (Mouse.getEventButton() != 0 || !Mouse.getEventButtonState() || this.hitResult == null) continue;
                int v5 = this.hitResult.x;
                v6 = this.hitResult.y;
                int v7 = this.hitResult.z;
                if (this.hitResult.f == 0) {
                    --v6;
                }
                if (this.hitResult.f == 1) {
                    ++v6;
                }
                if (this.hitResult.f == 2) {
                    --v7;
                }
                if (this.hitResult.f == 3) {
                    ++v7;
                }
                if (this.hitResult.f == 4) {
                    --v5;
                }
                if (this.hitResult.f == 5) {
                    ++v5;
                }
                this.level.setTile(v5, v6, v7, this.paintTexture);
            }
        }
        GL11.glClear((int)16640);
        this.setupCamera(a1);
        GL11.glEnable((int)2884);
        Frustum v8 = Frustum.getFrustum();
        this.levelRenderer.updateDirtyChunks(this.player);
        this.setupFog(0);
        GL11.glEnable((int)2912);
        this.levelRenderer.render(this.player, 0);
        v6 = 0;
        while (v6 < this.zombies.size()) {
            Zombie v9 = this.zombies.get(v6);
            if (v9.isLit() && v8.isVisible(v9.bb)) {
                this.zombies.get(v6).render(a1);
            }
            ++v6;
        }
        this.particleEngine.render(this.player, a1, 0);
        this.setupFog(1);
        this.levelRenderer.render(this.player, 1);
        v6 = 0;
        while (v6 < this.zombies.size()) {
            Zombie v9 = this.zombies.get(v6);
            if (!v9.isLit() && v8.isVisible(v9.bb)) {
                this.zombies.get(v6).render(a1);
            }
            ++v6;
        }
        this.particleEngine.render(this.player, a1, 1);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2912);
        if (this.hitResult != null) {
            GL11.glDisable((int)3008);
            this.levelRenderer.renderHit(this.hitResult);
            GL11.glEnable((int)3008);
        }
        this.drawGui(a1);
        Display.update();
    }

    private void drawGui(float a1) {
        int v1 = this.width * 240 / this.height;
        int v2 = this.height * 240 / this.height;
        GL11.glClear((int)256);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)v1, (double)v2, (double)0.0, (double)100.0, (double)300.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-200.0f);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(v1 - 16), (float)16.0f, (float)0.0f);
        Tesselator v3 = Tesselator.instance;
        GL11.glScalef((float)16.0f, (float)16.0f, (float)16.0f);
        GL11.glRotatef((float)30.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-1.5f, (float)0.5f, (float)-0.5f);
        GL11.glScalef((float)-1.0f, (float)-1.0f, (float)1.0f);
        int v4 = this.textures.loadTexture("/terrain.png", 9728);
        GL11.glBindTexture((int)3553, (int)v4);
        GL11.glEnable((int)3553);
        v3.init();
        if (this.gui instanceof GuiIngame) {
            Tile.tiles[this.paintTexture].render(v3, this.level, 0, -2, 0, 0);
        }
        v3.flush();
        GL11.glDisable((int)3553);
        GL11.glPopMatrix();
        int v5 = v1 / 2;
        int v6 = v2 / 2;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        v3.init();
        v3.vertex(v5 + 1, v6 - 4, 0.0f);
        v3.vertex(v5 - 0, v6 - 4, 0.0f);
        v3.vertex(v5 - 0, v6 + 5, 0.0f);
        v3.vertex(v5 + 1, v6 + 5, 0.0f);
        v3.vertex(v5 + 5, v6 - 0, 0.0f);
        v3.vertex(v5 - 4, v6 - 0, 0.0f);
        v3.vertex(v5 - 4, v6 + 1, 0.0f);
        v3.vertex(v5 + 5, v6 + 1, 0.0f);
        v3.flush();
        int i24 = this.width * 240 / this.height;
        int i25 = this.height * 240 / this.height;
        int x = Mouse.getX() * i24 / this.width;
        int y = i25 - Mouse.getY() * i25 / this.height - 1;
        if (this.gui != null) {
            this.gui.drawScreen(x, y);
        }
    }

    private void setupFog(int a1) {
        GL11.glFogi((int)2917, (int)2048);
        GL11.glFogf((int)2914, (float)0.009f);
        GL11.glFog((int)2918, (FloatBuffer)this.fogColor1);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2903);
        float v1 = 0.8f;
        GL11.glLightModel((int)2899, (FloatBuffer)this.getBuffer(0.8f, 0.8f, 0.8f, 1.0f));
    }

    private FloatBuffer getBuffer(float a1, float a2, float a3, float a4) {
        this.lb.clear();
        this.lb.put(a1).put(a2).put(a3).put(a4);
        this.lb.flip();
        return this.lb;
    }

    public static void checkError() {
        int v1 = GL11.glGetError();
        if (v1 != 0) {
            throw new IllegalStateException(GLU.gluErrorString((int)v1));
        }
    }

    public static void main(String[] a1) throws LWJGLException {
        new Thread(new RubyDung()).start();
    }
}

