/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level;

import com.mojang.minecraft.level.LevelListener;
import com.mojang.minecraft.level.PerlinNoiseFilter;
import com.mojang.minecraft.level.tile.Tile;
import com.mojang.minecraft.phys.AABB;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Random;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class Level {
    private static final int TILE_UPDATE_INTERVAL = 400;
    public final int width;
    public final int height;
    public final int depth;
    private byte[] blocks;
    private int[] lightDepths;
    private ArrayList<LevelListener> levelListeners = new ArrayList();
    private Random random = new Random();
    int unprocessed = 0;
    public int seed;

    public Level(int a1, int a2, int a3) {
        this.width = a1;
        this.height = a2;
        this.depth = a3;
        this.blocks = new byte[a1 * a2 * a3];
        this.lightDepths = new int[a1 * a2];
        this.calcLightDepths(0, 0, a1, a2);
    }

    public Level(int a1, int a2, int a3, int whattodo) {
        this.width = a1;
        this.height = a2;
        this.depth = a3;
        this.blocks = new byte[a1 * a2 * a3];
        this.lightDepths = new int[a1 * a2];
        if (whattodo == 0) {
            this.generateMap();
        } else if (whattodo == 1) {
            this.load();
        } else if (whattodo == 2) {
            this.generateMap();
            this.save();
            this.load();
        }
        this.calcLightDepths(0, 0, a1, a2);
    }

    public void generateMap() {
        int v1 = this.width;
        int v2 = this.height;
        int v3 = this.depth;
        int[] v4 = new PerlinNoiseFilter(0).read(v1, v2);
        int[] v5 = new PerlinNoiseFilter(0).read(v1, v2);
        int[] v6 = new PerlinNoiseFilter(2).read(v1, v2);
        int[] v7 = new PerlinNoiseFilter(5).read(v1, v2);
        int v8 = 0;
        while (v8 < v1) {
            int v9 = 0;
            while (v9 < v3) {
                int v10 = 0;
                while (v10 < v2) {
                    int v14;
                    int v11 = v4[v8 + v10 * this.width];
                    int v12 = v5[v8 + v10 * this.width];
                    int v13 = v6[v8 + v10 * this.width];
                    if (v13 < 128) {
                        v12 = v11;
                    }
                    if (v12 > (v14 = v11)) {
                        v14 = v12;
                    } else {
                        v12 = v11;
                    }
                    v14 = (int)((double)v14 + 1.5);
                    v14 = v14 / 8 / 3;
                    int v15 = v7[v8 + v10 * this.width] / 8 / 3;
                    v15 = this.random.nextInt(5) == 0 ? v7[v8 + v10 * this.width] / 8 + v3 / 3 : v7[v8 + v10 * this.width] / 8 / 3;
                    if (v15 > v14 - 2) {
                        v15 = v14 - 2;
                    }
                    int v16 = (v9 * this.height + v10) * this.width + v8;
                    int v17 = 0;
                    if (v9 == v14) {
                        v17 = Tile.grass.id;
                    }
                    if (v9 < v14) {
                        v17 = Tile.rock.id;
                    }
                    this.blocks[v16] = (byte)v17;
                    ++v10;
                }
                ++v9;
            }
            ++v8;
        }
    }

    public boolean load() {
        try {
            DataInputStream v1 = new DataInputStream(new GZIPInputStream(new FileInputStream(new File("level.dat"))));
            v1.readFully(this.blocks);
            this.calcLightDepths(0, 0, this.width, this.height);
            int v2 = 0;
            while (v2 < this.levelListeners.size()) {
                this.levelListeners.get(v2).allChanged();
                ++v2;
            }
            v1.close();
            return true;
        }
        catch (Exception v3) {
            v3.printStackTrace();
            return false;
        }
    }

    public void save() {
        try {
            DataOutputStream v1 = new DataOutputStream(new GZIPOutputStream(new FileOutputStream(new File("level.dat"))));
            v1.write(this.blocks);
            v1.close();
        }
        catch (Exception v2) {
            v2.printStackTrace();
        }
    }

    public void calcLightDepths(int a1, int a2, int a3, int a4) {
        int v1 = a1;
        while (v1 < a1 + a3) {
            int v2 = a2;
            while (v2 < a2 + a4) {
                int v3 = this.lightDepths[v1 + v2 * this.width];
                int v4 = this.depth - 1;
                while (v4 > 0 && !this.isLightBlocker(v1, v4, v2)) {
                    --v4;
                }
                this.lightDepths[v1 + v2 * this.width] = v4;
                if (v3 != this.lightDepths[v1 + v2 * this.width]) {
                    int v5 = v3 < v4 ? v3 : v4;
                    int v6 = v3 > v4 ? v3 : v4;
                    int v7 = 0;
                    while (v7 < this.levelListeners.size()) {
                        this.levelListeners.get(v7).lightColumnChanged(v1, v2, v5, v6);
                        ++v7;
                    }
                }
                ++v2;
            }
            ++v1;
        }
    }

    public void addListener(LevelListener a1) {
        this.levelListeners.add(a1);
    }

    public void removeListener(LevelListener a1) {
        this.levelListeners.remove(a1);
    }

    public boolean isLightBlocker(int a1, int a2, int a3) {
        Tile v1 = Tile.tiles[this.getTile(a1, a2, a3)];
        return v1 != null && v1.blocksLight();
    }

    public ArrayList<AABB> getCubes(AABB a1) {
        ArrayList<AABB> v1 = new ArrayList<AABB>();
        int v2 = (int)a1.x0;
        int v3 = (int)(a1.x1 + 1.0f);
        int v4 = (int)a1.y0;
        int v5 = (int)(a1.y1 + 1.0f);
        int v6 = (int)a1.z0;
        int v7 = (int)(a1.z1 + 1.0f);
        if (v2 < 0) {
            v2 = 0;
        }
        if (v4 < 0) {
            v4 = 0;
        }
        if (v6 < 0) {
            v6 = 0;
        }
        if (v3 > this.width) {
            v3 = this.width;
        }
        if (v5 > this.depth) {
            v5 = this.depth;
        }
        if (v7 > this.height) {
            v7 = this.height;
        }
        int v8 = v2;
        while (v8 < v3) {
            int v9 = v4;
            while (v9 < v5) {
                int v10 = v6;
                while (v10 < v7) {
                    AABB v12;
                    Tile v11 = Tile.tiles[this.getTile(v8, v9, v10)];
                    if (v11 != null && (v12 = v11.getAABB(v8, v9, v10)) != null) {
                        v1.add(v12);
                    }
                    ++v10;
                }
                ++v9;
            }
            ++v8;
        }
        return v1;
    }

    public boolean setTile(int a1, int a2, int a3, int a4) {
        if (a1 < 0 || a2 < 0 || a3 < 0 || a1 >= this.width || a2 >= this.depth || a3 >= this.height) {
            return false;
        }
        if (a4 == this.blocks[(a2 * this.height + a3) * this.width + a1]) {
            return false;
        }
        this.blocks[(a2 * this.height + a3) * this.width + a1] = (byte)a4;
        this.calcLightDepths(a1, a3, 1, 1);
        int v1 = 0;
        while (v1 < this.levelListeners.size()) {
            this.levelListeners.get(v1).tileChanged(a1, a2, a3);
            ++v1;
        }
        return true;
    }

    public boolean isLit(int a1, int a2, int a3) {
        return a1 < 0 || a2 < 0 || a3 < 0 || a1 >= this.width || a2 >= this.depth || a3 >= this.height || a2 >= this.lightDepths[a1 + a3 * this.width];
    }

    public int getTile(int a1, int a2, int a3) {
        if (a1 < 0 || a2 < 0 || a3 < 0 || a1 >= this.width || a2 >= this.depth || a3 >= this.height) {
            return 0;
        }
        return this.blocks[(a2 * this.height + a3) * this.width + a1];
    }

    public boolean isSolidTile(int a1, int a2, int a3) {
        Tile v1 = Tile.tiles[this.getTile(a1, a2, a3)];
        return v1 != null && v1.isSolid();
    }

    public void tick() {
        this.unprocessed += this.width * this.height * this.depth;
        int v1 = this.unprocessed / 400;
        this.unprocessed -= v1 * 400;
        int v2 = 0;
        while (v2 < v1) {
            int v5;
            int v4;
            int v3 = this.random.nextInt(this.width);
            Tile v6 = Tile.tiles[this.getTile(v3, v4 = this.random.nextInt(this.depth), v5 = this.random.nextInt(this.height))];
            if (v6 != null) {
                v6.tick(this, v3, v4, v5, this.random);
            }
            ++v2;
        }
    }
}

