/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.level.Level;
import com.mojang.minecraft.level.Tesselator;
import com.mojang.minecraft.level.tile.Bush;
import com.mojang.minecraft.level.tile.DirtTile;
import com.mojang.minecraft.level.tile.GrassTile;
import com.mojang.minecraft.particle.Particle;
import com.mojang.minecraft.particle.ParticleEngine;
import com.mojang.minecraft.phys.AABB;
import java.util.Random;

public class Tile {
    public static final Tile[] tiles = new Tile[256];
    public static final Tile empty = null;
    public static final Tile rock = new Tile(1, 1);
    public static final Tile grass = new GrassTile(2);
    public static final Tile dirt = new DirtTile(3, 2);
    public static final Tile stoneBrick = new Tile(4, 16);
    public static final Tile wood = new Tile(5, 4);
    public static final Tile bush = new Bush(6);
    public int tex;
    public final int id;

    protected Tile(int a1) {
        Tile.tiles[a1] = this;
        this.id = a1;
    }

    protected Tile(int a1, int a2) {
        this(a1);
        this.tex = a2;
    }

    public void render(Tesselator a1, Level a2, int a3, int a4, int a5, int a6) {
        float v1 = 1.0f;
        float v2 = 0.8f;
        float v3 = 0.6f;
        if (this.shouldRenderFace(a2, a4, a5 - 1, a6, a3)) {
            a1.color(1.0f, 1.0f, 1.0f);
            this.renderFace(a1, a4, a5, a6, 0);
        }
        if (this.shouldRenderFace(a2, a4, a5 + 1, a6, a3)) {
            a1.color(1.0f, 1.0f, 1.0f);
            this.renderFace(a1, a4, a5, a6, 1);
        }
        if (this.shouldRenderFace(a2, a4, a5, a6 - 1, a3)) {
            a1.color(0.8f, 0.8f, 0.8f);
            this.renderFace(a1, a4, a5, a6, 2);
        }
        if (this.shouldRenderFace(a2, a4, a5, a6 + 1, a3)) {
            a1.color(0.8f, 0.8f, 0.8f);
            this.renderFace(a1, a4, a5, a6, 3);
        }
        if (this.shouldRenderFace(a2, a4 - 1, a5, a6, a3)) {
            a1.color(0.6f, 0.6f, 0.6f);
            this.renderFace(a1, a4, a5, a6, 4);
        }
        if (this.shouldRenderFace(a2, a4 + 1, a5, a6, a3)) {
            a1.color(0.6f, 0.6f, 0.6f);
            this.renderFace(a1, a4, a5, a6, 5);
        }
    }

    private boolean shouldRenderFace(Level a1, int a2, int a3, int a4, int a5) {
        return !a1.isSolidTile(a2, a3, a4) && a1.isLit(a2, a3, a4) ^ a5 == 1;
    }

    protected int getTexture(int a1) {
        return this.tex;
    }

    public void renderFace(Tesselator a1, int a2, int a3, int a4, int a5) {
        int v1 = this.getTexture(a5);
        float v2 = (float)(v1 % 16) / 16.0f;
        float v3 = v2 + 0.0624375f;
        float v4 = (float)(v1 / 16) / 16.0f;
        float v5 = v4 + 0.0624375f;
        float v6 = (float)a2 + 0.0f;
        float v7 = (float)a2 + 1.0f;
        float v8 = (float)a3 + 0.0f;
        float v9 = (float)a3 + 1.0f;
        float v10 = (float)a4 + 0.0f;
        float v11 = (float)a4 + 1.0f;
        if (a5 == 0) {
            a1.vertexUV(v6, v8, v11, v2, v5);
            a1.vertexUV(v6, v8, v10, v2, v4);
            a1.vertexUV(v7, v8, v10, v3, v4);
            a1.vertexUV(v7, v8, v11, v3, v5);
        }
        if (a5 == 1) {
            a1.vertexUV(v7, v9, v11, v3, v5);
            a1.vertexUV(v7, v9, v10, v3, v4);
            a1.vertexUV(v6, v9, v10, v2, v4);
            a1.vertexUV(v6, v9, v11, v2, v5);
        }
        if (a5 == 2) {
            a1.vertexUV(v6, v9, v10, v3, v4);
            a1.vertexUV(v7, v9, v10, v2, v4);
            a1.vertexUV(v7, v8, v10, v2, v5);
            a1.vertexUV(v6, v8, v10, v3, v5);
        }
        if (a5 == 3) {
            a1.vertexUV(v6, v9, v11, v2, v4);
            a1.vertexUV(v6, v8, v11, v2, v5);
            a1.vertexUV(v7, v8, v11, v3, v5);
            a1.vertexUV(v7, v9, v11, v3, v4);
        }
        if (a5 == 4) {
            a1.vertexUV(v6, v9, v11, v3, v4);
            a1.vertexUV(v6, v9, v10, v2, v4);
            a1.vertexUV(v6, v8, v10, v2, v5);
            a1.vertexUV(v6, v8, v11, v3, v5);
        }
        if (a5 == 5) {
            a1.vertexUV(v7, v8, v11, v2, v5);
            a1.vertexUV(v7, v8, v10, v3, v5);
            a1.vertexUV(v7, v9, v10, v3, v4);
            a1.vertexUV(v7, v9, v11, v2, v4);
        }
    }

    public void renderFaceNoTexture(Tesselator a1, int a2, int a3, int a4, int a5) {
        float v1 = (float)a2 + 0.0f;
        float v2 = (float)a2 + 1.0f;
        float v3 = (float)a3 + 0.0f;
        float v4 = (float)a3 + 1.0f;
        float v5 = (float)a4 + 0.0f;
        float v6 = (float)a4 + 1.0f;
        if (a5 == 0) {
            a1.vertex(v1, v3, v6);
            a1.vertex(v1, v3, v5);
            a1.vertex(v2, v3, v5);
            a1.vertex(v2, v3, v6);
        }
        if (a5 == 1) {
            a1.vertex(v2, v4, v6);
            a1.vertex(v2, v4, v5);
            a1.vertex(v1, v4, v5);
            a1.vertex(v1, v4, v6);
        }
        if (a5 == 2) {
            a1.vertex(v1, v4, v5);
            a1.vertex(v2, v4, v5);
            a1.vertex(v2, v3, v5);
            a1.vertex(v1, v3, v5);
        }
        if (a5 == 3) {
            a1.vertex(v1, v4, v6);
            a1.vertex(v1, v3, v6);
            a1.vertex(v2, v3, v6);
            a1.vertex(v2, v4, v6);
        }
        if (a5 == 4) {
            a1.vertex(v1, v4, v6);
            a1.vertex(v1, v4, v5);
            a1.vertex(v1, v3, v5);
            a1.vertex(v1, v3, v6);
        }
        if (a5 == 5) {
            a1.vertex(v2, v3, v6);
            a1.vertex(v2, v3, v5);
            a1.vertex(v2, v4, v5);
            a1.vertex(v2, v4, v6);
        }
    }

    public final AABB getTileAABB(int a1, int a2, int a3) {
        return new AABB(a1, a2, a3, a1 + 1, a2 + 1, a3 + 1);
    }

    public AABB getAABB(int a1, int a2, int a3) {
        return new AABB(a1, a2, a3, a1 + 1, a2 + 1, a3 + 1);
    }

    public boolean blocksLight() {
        return true;
    }

    public boolean isSolid() {
        return true;
    }

    public void tick(Level a1, int a2, int a3, int a4, Random a5) {
    }

    public void destroy(Level a1, int a2, int a3, int a4, ParticleEngine a5) {
        int v1 = 4;
        int v2 = 0;
        while (v2 < v1) {
            int v3 = 0;
            while (v3 < v1) {
                int v4 = 0;
                while (v4 < v1) {
                    float v5 = (float)a2 + ((float)v2 + 0.5f) / (float)v1;
                    float v6 = (float)a3 + ((float)v3 + 0.5f) / (float)v1;
                    float v7 = (float)a4 + ((float)v4 + 0.5f) / (float)v1;
                    a5.add(new Particle(null, a1, v5, v6, v7, v5 - (float)a2 - 0.5f, v6 - (float)a3 - 0.5f, v7 - (float)a4 - 0.5f, this.tex));
                    ++v4;
                }
                ++v3;
            }
            ++v2;
        }
    }
}

