/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level;

import com.mojang.minecraft.Player;
import com.mojang.minecraft.level.Chunk;
import com.mojang.minecraft.level.Frustum;
import java.util.Comparator;

public class DirtyChunkSorter
implements Comparator<Chunk> {
    private Player player;
    private Frustum frustum;
    private long now = System.currentTimeMillis();

    public DirtyChunkSorter(Player a1, Frustum a2) {
        this.player = a1;
        this.frustum = a2;
    }

    @Override
    public int compare(Chunk a1, Chunk a2) {
        boolean v1 = this.frustum.isVisible(a1.aabb);
        boolean v2 = this.frustum.isVisible(a2.aabb);
        if (v1 && !v2) {
            return -1;
        }
        if (v2 && !v1) {
            return 1;
        }
        int v3 = (int)((this.now - a1.dirtiedTime) / 2000L);
        int v4 = (int)((this.now - a2.dirtiedTime) / 2000L);
        if (v3 < v4) {
            return -1;
        }
        if (v3 > v4) {
            return 1;
        }
        return a1.distanceToSqr(this.player) < a2.distanceToSqr(this.player) ? -1 : 1;
    }
}

