/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level;

import com.mojang.minecraft.phys.AABB;
import java.nio.FloatBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class Frustum {
    public float[][] m_Frustum = new float[6][4];
    public static final int RIGHT = 0;
    public static final int LEFT = 1;
    public static final int BOTTOM = 2;
    public static final int TOP = 3;
    public static final int BACK = 4;
    public static final int FRONT = 5;
    public static final int A = 0;
    public static final int B = 1;
    public static final int C = 2;
    public static final int D = 3;
    private static Frustum frustum = new Frustum();
    private FloatBuffer _proj = BufferUtils.createFloatBuffer((int)16);
    private FloatBuffer _modl = BufferUtils.createFloatBuffer((int)16);
    private FloatBuffer _clip = BufferUtils.createFloatBuffer((int)16);
    float[] proj = new float[16];
    float[] modl = new float[16];
    float[] clip = new float[16];

    private Frustum() {
    }

    public static Frustum getFrustum() {
        frustum.calculateFrustum();
        return frustum;
    }

    private void normalizePlane(float[][] a1, int a2) {
        float v1 = (float)Math.sqrt(a1[a2][0] * a1[a2][0] + a1[a2][1] * a1[a2][1] + a1[a2][2] * a1[a2][2]);
        float[] array = a1[a2];
        boolean n = false;
        array[0] = array[0] / v1;
        float[] array2 = a1[a2];
        boolean n2 = true;
        array2[1] = array2[1] / v1;
        float[] array3 = a1[a2];
        int n3 = 2;
        array3[2] = array3[2] / v1;
        float[] array4 = a1[a2];
        int n4 = 3;
        array4[3] = array4[3] / v1;
    }

    private void calculateFrustum() {
        this._proj.clear();
        this._modl.clear();
        this._clip.clear();
        GL11.glGetFloat((int)2983, (FloatBuffer)this._proj);
        GL11.glGetFloat((int)2982, (FloatBuffer)this._modl);
        this._proj.flip().limit(16);
        this._proj.get(this.proj);
        this._modl.flip().limit(16);
        this._modl.get(this.modl);
        this.clip[0] = this.modl[0] * this.proj[0] + this.modl[1] * this.proj[4] + this.modl[2] * this.proj[8] + this.modl[3] * this.proj[12];
        this.clip[1] = this.modl[0] * this.proj[1] + this.modl[1] * this.proj[5] + this.modl[2] * this.proj[9] + this.modl[3] * this.proj[13];
        this.clip[2] = this.modl[0] * this.proj[2] + this.modl[1] * this.proj[6] + this.modl[2] * this.proj[10] + this.modl[3] * this.proj[14];
        this.clip[3] = this.modl[0] * this.proj[3] + this.modl[1] * this.proj[7] + this.modl[2] * this.proj[11] + this.modl[3] * this.proj[15];
        this.clip[4] = this.modl[4] * this.proj[0] + this.modl[5] * this.proj[4] + this.modl[6] * this.proj[8] + this.modl[7] * this.proj[12];
        this.clip[5] = this.modl[4] * this.proj[1] + this.modl[5] * this.proj[5] + this.modl[6] * this.proj[9] + this.modl[7] * this.proj[13];
        this.clip[6] = this.modl[4] * this.proj[2] + this.modl[5] * this.proj[6] + this.modl[6] * this.proj[10] + this.modl[7] * this.proj[14];
        this.clip[7] = this.modl[4] * this.proj[3] + this.modl[5] * this.proj[7] + this.modl[6] * this.proj[11] + this.modl[7] * this.proj[15];
        this.clip[8] = this.modl[8] * this.proj[0] + this.modl[9] * this.proj[4] + this.modl[10] * this.proj[8] + this.modl[11] * this.proj[12];
        this.clip[9] = this.modl[8] * this.proj[1] + this.modl[9] * this.proj[5] + this.modl[10] * this.proj[9] + this.modl[11] * this.proj[13];
        this.clip[10] = this.modl[8] * this.proj[2] + this.modl[9] * this.proj[6] + this.modl[10] * this.proj[10] + this.modl[11] * this.proj[14];
        this.clip[11] = this.modl[8] * this.proj[3] + this.modl[9] * this.proj[7] + this.modl[10] * this.proj[11] + this.modl[11] * this.proj[15];
        this.clip[12] = this.modl[12] * this.proj[0] + this.modl[13] * this.proj[4] + this.modl[14] * this.proj[8] + this.modl[15] * this.proj[12];
        this.clip[13] = this.modl[12] * this.proj[1] + this.modl[13] * this.proj[5] + this.modl[14] * this.proj[9] + this.modl[15] * this.proj[13];
        this.clip[14] = this.modl[12] * this.proj[2] + this.modl[13] * this.proj[6] + this.modl[14] * this.proj[10] + this.modl[15] * this.proj[14];
        this.clip[15] = this.modl[12] * this.proj[3] + this.modl[13] * this.proj[7] + this.modl[14] * this.proj[11] + this.modl[15] * this.proj[15];
        this.m_Frustum[0][0] = this.clip[3] - this.clip[0];
        this.m_Frustum[0][1] = this.clip[7] - this.clip[4];
        this.m_Frustum[0][2] = this.clip[11] - this.clip[8];
        this.m_Frustum[0][3] = this.clip[15] - this.clip[12];
        this.normalizePlane(this.m_Frustum, 0);
        this.m_Frustum[1][0] = this.clip[3] + this.clip[0];
        this.m_Frustum[1][1] = this.clip[7] + this.clip[4];
        this.m_Frustum[1][2] = this.clip[11] + this.clip[8];
        this.m_Frustum[1][3] = this.clip[15] + this.clip[12];
        this.normalizePlane(this.m_Frustum, 1);
        this.m_Frustum[2][0] = this.clip[3] + this.clip[1];
        this.m_Frustum[2][1] = this.clip[7] + this.clip[5];
        this.m_Frustum[2][2] = this.clip[11] + this.clip[9];
        this.m_Frustum[2][3] = this.clip[15] + this.clip[13];
        this.normalizePlane(this.m_Frustum, 2);
        this.m_Frustum[3][0] = this.clip[3] - this.clip[1];
        this.m_Frustum[3][1] = this.clip[7] - this.clip[5];
        this.m_Frustum[3][2] = this.clip[11] - this.clip[9];
        this.m_Frustum[3][3] = this.clip[15] - this.clip[13];
        this.normalizePlane(this.m_Frustum, 3);
        this.m_Frustum[4][0] = this.clip[3] - this.clip[2];
        this.m_Frustum[4][1] = this.clip[7] - this.clip[6];
        this.m_Frustum[4][2] = this.clip[11] - this.clip[10];
        this.m_Frustum[4][3] = this.clip[15] - this.clip[14];
        this.normalizePlane(this.m_Frustum, 4);
        this.m_Frustum[5][0] = this.clip[3] + this.clip[2];
        this.m_Frustum[5][1] = this.clip[7] + this.clip[6];
        this.m_Frustum[5][2] = this.clip[11] + this.clip[10];
        this.m_Frustum[5][3] = this.clip[15] + this.clip[14];
        this.normalizePlane(this.m_Frustum, 5);
    }

    public boolean pointInFrustum(float a1, float a2, float a3) {
        int v1 = 0;
        while (v1 < 6) {
            if (this.m_Frustum[v1][0] * a1 + this.m_Frustum[v1][1] * a2 + this.m_Frustum[v1][2] * a3 + this.m_Frustum[v1][3] <= 0.0f) {
                return false;
            }
            ++v1;
        }
        return true;
    }

    public boolean sphereInFrustum(float a1, float a2, float a3, float a4) {
        int v1 = 0;
        while (v1 < 6) {
            if (this.m_Frustum[v1][0] * a1 + this.m_Frustum[v1][1] * a2 + this.m_Frustum[v1][2] * a3 + this.m_Frustum[v1][3] <= -a4) {
                return false;
            }
            ++v1;
        }
        return true;
    }

    public boolean cubeFullyInFrustum(float a1, float a2, float a3, float a4, float a5, float a6) {
        int v1 = 0;
        while (v1 < 6) {
            if (this.m_Frustum[v1][0] * a1 + this.m_Frustum[v1][1] * a2 + this.m_Frustum[v1][2] * a3 + this.m_Frustum[v1][3] <= 0.0f) {
                return false;
            }
            if (this.m_Frustum[v1][0] * a4 + this.m_Frustum[v1][1] * a2 + this.m_Frustum[v1][2] * a3 + this.m_Frustum[v1][3] <= 0.0f) {
                return false;
            }
            if (this.m_Frustum[v1][0] * a1 + this.m_Frustum[v1][1] * a5 + this.m_Frustum[v1][2] * a3 + this.m_Frustum[v1][3] <= 0.0f) {
                return false;
            }
            if (this.m_Frustum[v1][0] * a4 + this.m_Frustum[v1][1] * a5 + this.m_Frustum[v1][2] * a3 + this.m_Frustum[v1][3] <= 0.0f) {
                return false;
            }
            if (this.m_Frustum[v1][0] * a1 + this.m_Frustum[v1][1] * a2 + this.m_Frustum[v1][2] * a6 + this.m_Frustum[v1][3] <= 0.0f) {
                return false;
            }
            if (this.m_Frustum[v1][0] * a4 + this.m_Frustum[v1][1] * a2 + this.m_Frustum[v1][2] * a6 + this.m_Frustum[v1][3] <= 0.0f) {
                return false;
            }
            if (this.m_Frustum[v1][0] * a1 + this.m_Frustum[v1][1] * a5 + this.m_Frustum[v1][2] * a6 + this.m_Frustum[v1][3] <= 0.0f) {
                return false;
            }
            if (this.m_Frustum[v1][0] * a4 + this.m_Frustum[v1][1] * a5 + this.m_Frustum[v1][2] * a6 + this.m_Frustum[v1][3] <= 0.0f) {
                return false;
            }
            ++v1;
        }
        return true;
    }

    public boolean cubeInFrustum(float a1, float a2, float a3, float a4, float a5, float a6) {
        int v1 = 0;
        while (v1 < 6) {
            if (this.m_Frustum[v1][0] * a1 + this.m_Frustum[v1][1] * a2 + this.m_Frustum[v1][2] * a3 + this.m_Frustum[v1][3] <= 0.0f && this.m_Frustum[v1][0] * a4 + this.m_Frustum[v1][1] * a2 + this.m_Frustum[v1][2] * a3 + this.m_Frustum[v1][3] <= 0.0f && this.m_Frustum[v1][0] * a1 + this.m_Frustum[v1][1] * a5 + this.m_Frustum[v1][2] * a3 + this.m_Frustum[v1][3] <= 0.0f && this.m_Frustum[v1][0] * a4 + this.m_Frustum[v1][1] * a5 + this.m_Frustum[v1][2] * a3 + this.m_Frustum[v1][3] <= 0.0f && this.m_Frustum[v1][0] * a1 + this.m_Frustum[v1][1] * a2 + this.m_Frustum[v1][2] * a6 + this.m_Frustum[v1][3] <= 0.0f && this.m_Frustum[v1][0] * a4 + this.m_Frustum[v1][1] * a2 + this.m_Frustum[v1][2] * a6 + this.m_Frustum[v1][3] <= 0.0f && this.m_Frustum[v1][0] * a1 + this.m_Frustum[v1][1] * a5 + this.m_Frustum[v1][2] * a6 + this.m_Frustum[v1][3] <= 0.0f && this.m_Frustum[v1][0] * a4 + this.m_Frustum[v1][1] * a5 + this.m_Frustum[v1][2] * a6 + this.m_Frustum[v1][3] <= 0.0f) {
                return false;
            }
            ++v1;
        }
        return true;
    }

    public boolean isVisible(AABB a1) {
        return this.cubeInFrustum(a1.x0, a1.y0, a1.z0, a1.x1, a1.y1, a1.z1);
    }
}

