/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level;

import com.mojang.minecraft.HitResult;
import com.mojang.minecraft.Player;
import com.mojang.minecraft.RubyDung;
import com.mojang.minecraft.level.Chunk;
import com.mojang.minecraft.level.DirtyChunkSorter;
import com.mojang.minecraft.level.Frustum;
import com.mojang.minecraft.level.Level;
import com.mojang.minecraft.level.LevelListener;
import com.mojang.minecraft.level.Tesselator;
import com.mojang.minecraft.level.tile.Tile;
import com.mojang.minecraft.phys.AABB;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.lwjgl.opengl.GL11;

public class LevelRenderer
implements LevelListener {
    public static final int MAX_REBUILDS_PER_FRAME = 8;
    public static final int CHUNK_SIZE = 16;
    private Level level;
    private Chunk[] chunks;
    private int xChunks;
    private int yChunks;
    private int zChunks;
    protected RubyDung game;

    public LevelRenderer(RubyDung g, Level a1) {
        this.game = g;
        this.level = a1;
        this.level.addListener(this);
        this.xChunks = a1.width / 16;
        this.yChunks = a1.depth / 16;
        this.zChunks = a1.height / 16;
        this.chunks = new Chunk[this.xChunks * this.yChunks * this.zChunks];
        int v1 = 0;
        while (v1 < this.xChunks) {
            int v2 = 0;
            while (v2 < this.yChunks) {
                int v3 = 0;
                while (v3 < this.zChunks) {
                    int v4 = v1 * 16;
                    int v5 = v2 * 16;
                    int v6 = v3 * 16;
                    int v7 = (v1 + 1) * 16;
                    int v8 = (v2 + 1) * 16;
                    int v9 = (v3 + 1) * 16;
                    if (v7 > a1.width) {
                        v7 = a1.width;
                    }
                    if (v8 > a1.depth) {
                        v8 = a1.depth;
                    }
                    if (v9 > a1.height) {
                        v9 = a1.height;
                    }
                    this.chunks[(v1 + v2 * this.xChunks) * this.zChunks + v3] = new Chunk(a1, v4, v5, v6, v7, v8, v9);
                    ++v3;
                }
                ++v2;
            }
            ++v1;
        }
    }

    public List<Chunk> getAllDirtyChunks() {
        ArrayList<Chunk> v1 = null;
        int v2 = 0;
        while (v2 < this.chunks.length) {
            Chunk v3 = this.chunks[v2];
            if (v3.isDirty()) {
                if (v1 == null) {
                    v1 = new ArrayList<Chunk>();
                }
                v1.add(v3);
            }
            ++v2;
        }
        return v1;
    }

    public void render(Player a1, int a2) {
        GL11.glEnable((int)3553);
        int v1 = this.game.textures.loadTexture("/terrain.png", 9728);
        GL11.glBindTexture((int)3553, (int)v1);
        Frustum v2 = Frustum.getFrustum();
        int v3 = 0;
        while (v3 < this.chunks.length) {
            if (v2.isVisible(this.chunks[v3].aabb)) {
                this.chunks[v3].render(a2);
            }
            ++v3;
        }
        GL11.glDisable((int)3553);
    }

    public void updateDirtyChunks(Player a1) {
        List<Chunk> v1 = this.getAllDirtyChunks();
        if (v1 == null) {
            return;
        }
        Collections.sort(v1, new DirtyChunkSorter(a1, Frustum.getFrustum()));
        int v2 = 0;
        while (v2 < 8 && v2 < v1.size()) {
            v1.get(v2).rebuild();
            ++v2;
        }
    }

    public void pick(Player a1, Frustum a2) {
        Tesselator v1 = Tesselator.instance;
        float v2 = 3.0f;
        AABB v3 = a1.bb.grow(3.0f, 3.0f, 3.0f);
        int v4 = (int)v3.x0;
        int v5 = (int)(v3.x1 + 1.0f);
        int v6 = (int)v3.y0;
        int v7 = (int)(v3.y1 + 1.0f);
        int v8 = (int)v3.z0;
        int v9 = (int)(v3.z1 + 1.0f);
        GL11.glInitNames();
        GL11.glPushName((int)0);
        GL11.glPushName((int)0);
        int v10 = v4;
        while (v10 < v5) {
            GL11.glLoadName((int)v10);
            GL11.glPushName((int)0);
            int v11 = v6;
            while (v11 < v7) {
                GL11.glLoadName((int)v11);
                GL11.glPushName((int)0);
                int v12 = v8;
                while (v12 < v9) {
                    Tile v13 = Tile.tiles[this.level.getTile(v10, v11, v12)];
                    if (v13 != null && a2.isVisible(v13.getTileAABB(v10, v11, v12))) {
                        GL11.glLoadName((int)v12);
                        GL11.glPushName((int)0);
                        int v14 = 0;
                        while (v14 < 6) {
                            GL11.glLoadName((int)v14);
                            v1.init();
                            v13.renderFaceNoTexture(v1, v10, v11, v12, v14);
                            v1.flush();
                            ++v14;
                        }
                        GL11.glPopName();
                    }
                    ++v12;
                }
                GL11.glPopName();
                ++v11;
            }
            GL11.glPopName();
            ++v10;
        }
        GL11.glPopName();
        GL11.glPopName();
    }

    public void renderHit(HitResult a1) {
        Tesselator v1 = Tesselator.instance;
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(((float)Math.sin((double)System.currentTimeMillis() / 100.0) * 0.2f + 0.4f) * 0.5f));
        v1.init();
        Tile.rock.renderFaceNoTexture(v1, a1.x, a1.y, a1.z, a1.f);
        v1.flush();
        GL11.glDisable((int)3042);
    }

    public void setDirty(int a1, int a2, int a3, int a4, int a5, int a6) {
        a1 /= 16;
        a4 /= 16;
        a2 /= 16;
        a5 /= 16;
        a3 /= 16;
        a6 /= 16;
        if (a1 < 0) {
            a1 = 0;
        }
        if (a2 < 0) {
            a2 = 0;
        }
        if (a3 < 0) {
            a3 = 0;
        }
        if (a4 >= this.xChunks) {
            a4 = this.xChunks - 1;
        }
        if (a5 >= this.yChunks) {
            a5 = this.yChunks - 1;
        }
        if (a6 >= this.zChunks) {
            a6 = this.zChunks - 1;
        }
        int v1 = a1;
        while (v1 <= a4) {
            int v2 = a2;
            while (v2 <= a5) {
                int v3 = a3;
                while (v3 <= a6) {
                    this.chunks[(v1 + v2 * this.xChunks) * this.zChunks + v3].setDirty();
                    ++v3;
                }
                ++v2;
            }
            ++v1;
        }
    }

    @Override
    public void tileChanged(int a1, int a2, int a3) {
        this.setDirty(a1 - 1, a2 - 1, a3 - 1, a1 + 1, a2 + 1, a3 + 1);
    }

    @Override
    public void lightColumnChanged(int a1, int a2, int a3, int a4) {
        this.setDirty(a1 - 1, a3 - 1, a2 - 1, a1 + 1, a4 + 1, a2 + 1);
    }

    @Override
    public void allChanged() {
        this.setDirty(0, 0, 0, this.level.width, this.level.depth, this.level.height);
    }
}

