/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level;

import com.mojang.minecraft.Player;
import com.mojang.minecraft.level.Level;
import com.mojang.minecraft.level.Tesselator;
import com.mojang.minecraft.level.tile.Tile;
import com.mojang.minecraft.phys.AABB;
import org.lwjgl.opengl.GL11;

public class Chunk {
    public AABB aabb;
    public final Level level;
    public final int x0;
    public final int y0;
    public final int z0;
    public final int x1;
    public final int y1;
    public final int z1;
    public final float x;
    public final float y;
    public final float z;
    private boolean dirty = true;
    private int lists = -1;
    public long dirtiedTime = 0L;
    private static Tesselator t = Tesselator.instance;
    public static int updates = 0;
    private static long totalTime = 0L;
    private static int totalUpdates = 0;

    public Chunk(Level a1, int a2, int a3, int a4, int a5, int a6, int a7) {
        this.level = a1;
        this.x0 = a2;
        this.y0 = a3;
        this.z0 = a4;
        this.x1 = a5;
        this.y1 = a6;
        this.z1 = a7;
        this.x = (float)(a2 + a5) / 2.0f;
        this.y = (float)(a3 + a6) / 2.0f;
        this.z = (float)(a4 + a7) / 2.0f;
        this.aabb = new AABB(a2, a3, a4, a5, a6, a7);
        this.lists = GL11.glGenLists((int)2);
    }

    private void rebuild(int a1) {
        this.dirty = false;
        ++updates;
        long v1 = System.nanoTime();
        GL11.glNewList((int)(this.lists + a1), (int)4864);
        t.init();
        int v2 = 0;
        int v3 = this.x0;
        while (v3 < this.x1) {
            int v4 = this.y0;
            while (v4 < this.y1) {
                int v5 = this.z0;
                while (v5 < this.z1) {
                    int v6 = this.level.getTile(v3, v4, v5);
                    if (v6 > 0) {
                        Tile.tiles[v6].render(t, this.level, a1, v3, v4, v5);
                        ++v2;
                    }
                    ++v5;
                }
                ++v4;
            }
            ++v3;
        }
        t.flush();
        GL11.glEndList();
        long v7 = System.nanoTime();
        if (v2 > 0) {
            totalTime += v7 - v1;
            ++totalUpdates;
        }
    }

    public void rebuild() {
        this.rebuild(0);
        this.rebuild(1);
    }

    public void render(int a1) {
        GL11.glCallList((int)(this.lists + a1));
    }

    public void setDirty() {
        if (!this.dirty) {
            this.dirtiedTime = System.currentTimeMillis();
        }
        this.dirty = true;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public float distanceToSqr(Player a1) {
        float v1 = a1.x - this.x;
        float v2 = a1.y - this.y;
        float v3 = a1.z - this.z;
        return v1 * v1 + v2 * v2 + v3 * v3;
    }
}

