/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft;

public class Timer {
    private static final long NS_PER_SECOND = 1000000000L;
    private static final long MAX_NS_PER_UPDATE = 1000000000L;
    private static final int MAX_TICKS_PER_UPDATE = 100;
    private float ticksPerSecond;
    private long lastTime;
    public int ticks;
    public float a;
    public float timeScale = 1.0f;
    public float fps = 0.0f;
    public float passedTime = 0.0f;

    public Timer(float a1) {
        this.ticksPerSecond = a1;
        this.lastTime = System.nanoTime();
    }

    public void advanceTime() {
        long v1 = System.nanoTime();
        long v2 = v1 - this.lastTime;
        this.lastTime = v1;
        if (v2 < 0L) {
            v2 = 0L;
        }
        if (v2 > 1000000000L) {
            v2 = 1000000000L;
        }
        this.fps = v2 / 1000000000L;
        this.passedTime += (float)v2 * this.timeScale * this.ticksPerSecond / 1.0E9f;
        this.ticks = (int)this.passedTime;
        if (this.ticks > 100) {
            this.ticks = 100;
        }
        this.passedTime -= (float)this.ticks;
        this.a = this.passedTime;
    }
}

