/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.character;

import com.mojang.minecraft.character.Polygon;
import com.mojang.minecraft.character.Vertex;
import org.lwjgl.opengl.GL11;

public class Cube {
    private Vertex[] vertices;
    private Polygon[] polygons;
    private int xTexOffs;
    private int yTexOffs;
    public float x;
    public float y;
    public float z;
    public float xRot;
    public float yRot;
    public float zRot;
    private boolean compiled = false;
    private int list = 0;

    public Cube(int a1, int a2) {
        this.xTexOffs = a1;
        this.yTexOffs = a2;
    }

    public void setTexOffs(int a1, int a2) {
        this.xTexOffs = a1;
        this.yTexOffs = a2;
    }

    public void addBox(float a1, float a2, float a3, int a4, int a5, int a6) {
        this.vertices = new Vertex[8];
        this.polygons = new Polygon[6];
        float v1 = a1 + (float)a4;
        float v2 = a2 + (float)a5;
        float v3 = a3 + (float)a6;
        Vertex v4 = new Vertex(a1, a2, a3, 0.0f, 0.0f);
        Vertex v5 = new Vertex(v1, a2, a3, 0.0f, 8.0f);
        Vertex v6 = new Vertex(v1, v2, a3, 8.0f, 8.0f);
        Vertex v7 = new Vertex(a1, v2, a3, 8.0f, 0.0f);
        Vertex v8 = new Vertex(a1, a2, v3, 0.0f, 0.0f);
        Vertex v9 = new Vertex(v1, a2, v3, 0.0f, 8.0f);
        Vertex v10 = new Vertex(v1, v2, v3, 8.0f, 8.0f);
        Vertex v11 = new Vertex(a1, v2, v3, 8.0f, 0.0f);
        this.vertices[0] = v4;
        this.vertices[1] = v5;
        this.vertices[2] = v6;
        this.vertices[3] = v7;
        this.vertices[4] = v8;
        this.vertices[5] = v9;
        this.vertices[6] = v10;
        this.vertices[7] = v11;
        this.polygons[0] = new Polygon(new Vertex[]{v9, v5, v6, v10}, this.xTexOffs + a6 + a4, this.yTexOffs + a6, this.xTexOffs + a6 + a4 + a6, this.yTexOffs + a6 + a5);
        this.polygons[1] = new Polygon(new Vertex[]{v4, v8, v11, v7}, this.xTexOffs + 0, this.yTexOffs + a6, this.xTexOffs + a6, this.yTexOffs + a6 + a5);
        this.polygons[2] = new Polygon(new Vertex[]{v9, v8, v4, v5}, this.xTexOffs + a6, this.yTexOffs + 0, this.xTexOffs + a6 + a4, this.yTexOffs + a6);
        this.polygons[3] = new Polygon(new Vertex[]{v6, v7, v11, v10}, this.xTexOffs + a6 + a4, this.yTexOffs + 0, this.xTexOffs + a6 + a4 + a4, this.yTexOffs + a6);
        this.polygons[4] = new Polygon(new Vertex[]{v5, v4, v7, v6}, this.xTexOffs + a6, this.yTexOffs + a6, this.xTexOffs + a6 + a4, this.yTexOffs + a6 + a5);
        this.polygons[5] = new Polygon(new Vertex[]{v8, v9, v10, v11}, this.xTexOffs + a6 + a4 + a6, this.yTexOffs + a6, this.xTexOffs + a6 + a4 + a6 + a4, this.yTexOffs + a6 + a5);
    }

    public void setPos(float a1, float a2, float a3) {
        this.x = a1;
        this.y = a2;
        this.z = a3;
    }

    public void render() {
        if (!this.compiled) {
            this.compile();
        }
        float v1 = 57.29578f;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.x, (float)this.y, (float)this.z);
        GL11.glRotatef((float)(this.zRot * 57.29578f), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)(this.yRot * 57.29578f), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(this.xRot * 57.29578f), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glCallList((int)this.list);
        GL11.glPopMatrix();
    }

    private void compile() {
        this.list = GL11.glGenLists((int)1);
        GL11.glNewList((int)this.list, (int)4864);
        GL11.glBegin((int)7);
        int v1 = 0;
        while (v1 < this.polygons.length) {
            this.polygons[v1].render();
            ++v1;
        }
        GL11.glEnd();
        GL11.glEndList();
        this.compiled = true;
    }
}

