/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class Biome {
    public static Biome[] biomes = new Biome[256];
    public static final Biome OCEAN = new OceanBiome(0).setColor(112).setBiomeName("Ocean").setMinMaxHeight(-1.0f, 0.5f);
    public static final Biome PLAINS = new PlainsBiome(1).setColor(9286496).setBiomeName("Plains").setTemperatureRainfall(0.8f, 0.4f);
    public static final Biome DESERT = new DesertBiome(2).setColor(16421912).setBiomeName("Desert").setTemperatureRainfall(2.0f, 0.0f).setMinMaxHeight(0.1f, 0.2f);
    public static final Biome EXTREME_HILLS = new HillBiome(3).setColor(0x606060).setBiomeName("Extreme Hills").setMinMaxHeight(0.2f, 1.8f).setTemperatureRainfall(0.2f, 0.3f);
    public static final Biome FOREST = new ForestBiome(4).setColor(353825).setBiomeName("Forest").setTemperatureRainfall(0.7f, 0.8f);
    public static final Biome TAIGA = new TaigaBiome(5).setColor(747097).setBiomeName("Taiga").setTemperatureRainfall(0.3f, 0.8f).setMinMaxHeight(0.2f, 0.6f);
    public static final Biome SWAMPLAND = new SwampBiome(6).setColor(522674).setBiomeName("Swampland").setMinMaxHeight(-0.2f, 0.1f).setTemperatureRainfall(0.8f, 0.9f);
    public static final Biome RIVER = new RiverBiome(7).setColor(255).setBiomeName("River").setMinMaxHeight(-0.5f, -0.1f);
    public static final Biome FROZEN_OCEAN = new OceanBiome(10).setColor(0x9090A0).setBiomeName("FrozenOcean").setMinMaxHeight(-1.0f, 0.5f).setTemperatureRainfall(0.0f, 0.5f).enableSnow();
    public static final Biome FROZEN_RIVER = new RiverBiome(11).setColor(0xA0A0FF).setBiomeName("FrozenRiver").setMinMaxHeight(-0.5f, 0.0f).setTemperatureRainfall(0.0f, 0.5f).enableSnow();
    public static final Biome ICE_PLAINS = new Biome(12).setColor(0xFFFFFF).setBiomeName("Ice Plains").setTemperatureRainfall(0.0f, 0.5f).enableSnow();
    public static final Biome OLD_GROWTH_PLAINS = new OldGrowthPlainsBiome(16).setColor(7648330).setBiomeName("Old Growth Plains").setTemperatureRainfall(1.0f, 0.5f).setMinMaxHeight(0.0f, 1.0f);
    public static final Biome SNOWY_TAIGA = new TaigaBiome(17).setColor(747097).setBiomeName("Snowy Taiga").setTemperatureRainfall(0.05f, 0.8f).setMinMaxHeight(0.1f, 0.4f).enableSnow();
    public static final Biome ICE_MOUNTAINS = new Biome(18).setColor(0xFFFFFF).setBiomeName("Ice Mountains").setTemperatureRainfall(0.0f, 0.5f).setMinMaxHeight(0.2f, 1.8f).enableSnow();
    public static final Biome RAINFOREST = new RainforestBiome(19).setColor(588342).setBiomeName("Rainforest").setTemperatureRainfall(1.0f, 0.8f).setMinMaxHeight(0.0f, 1.2f);
    public static final Biome OASIS = new OasisBiome(20).setColor(16448024).setBiomeName("Oasis").setTemperatureRainfall(2.0f, 0.5f).setMinMaxHeight(-0.1f, 0.5f);
    public static final Biome ICE_DESERT = new DesertBiome(21).setColor(0xBBFFFF).setBiomeName("Ice Desert").setTemperatureRainfall(0.0f, 0.0f).setMinMaxHeight(0.1f, 0.2f).enableSnow();
    public static final Biome WOODS = new WoodsBiome(22).setColor(353825).setBiomeName("Woods").setTemperatureRainfall(0.3f, 0.8f).setMinMaxHeight(0.2f, 0.6f);
    public static final Biome SNOWY_WOODS = new WoodsBiome(23).setColor(353825).setBiomeName("Snowy Woods").setTemperatureRainfall(0.05f, 0.8f).setMinMaxHeight(0.1f, 0.4f).enableSnow();
    public static final Biome HIGHLANDS = new HighlandsBiome(24).setColor(6328480).setBiomeName("Highlands").setTemperatureRainfall(0.6f, 0.7f).setMinMaxHeight(1.8f, 0.8f);
    public static final Biome HILLY_SWAMP = new SwampBiome(25).setColor(522674).setBiomeName("Hilly Swampland").setMinMaxHeight(-0.2f, 0.5f).setTemperatureRainfall(0.8f, 0.9f);
    public static final Biome WINDSWEPT_WOODS = new WoodsBiome(26).setColor(0x606060).setBiomeName("Windswept Woods").setMinMaxHeight(0.2f, 1.8f).setTemperatureRainfall(0.8f, 0.3f);
    public static final Biome OLD_GROWTH_ICE_PLAINS = new OldGrowthPlainsBiome(27).setColor(7648330).setBiomeName("Old Growth Ice Plains").setTemperatureRainfall(0.0f, 0.5f).setMinMaxHeight(0.0f, 1.0f).enableSnow();
    public int biomeID;
    public String biomeName;
    public int color;
    public byte topBlock;
    public byte fillerBlock;
    public int unusedColorizer;
    public float minHeight;
    public float maxHeight;
    public Awesomeness awesomeness;
    public Biome boringVariant;
    public float temperature;
    public float rainfall;
    public BiomeDecorator biomeDecorator;
    protected List<SpawnListEntry> spawnableMonsterList;
    protected List<SpawnListEntry> spawnableCreatureList;
    private boolean enableSnow;
    protected oa worldGenTrees;
    protected ej worldGenBigTree;
    protected WorldGenSwamp worldGenSwamp;

    protected Biome(int n2) {
        this.topBlock = (byte)ly.v.bc;
        this.fillerBlock = (byte)ly.w.bc;
        this.unusedColorizer = 5169201;
        this.minHeight = 0.1f;
        this.maxHeight = 0.3f;
        this.awesomeness = Awesomeness.ALWAYS;
        this.temperature = 0.5f;
        this.rainfall = 0.5f;
        this.spawnableMonsterList = new ArrayList<SpawnListEntry>();
        this.spawnableCreatureList = new ArrayList<SpawnListEntry>();
        this.worldGenTrees = new oa();
        this.worldGenBigTree = new ej();
        this.worldGenSwamp = new WorldGenSwamp();
        this.biomeID = n2;
        Biome.biomes[n2] = this;
        this.biomeDecorator = this.createBiomeDecorator();
        this.spawnableMonsterList.add(new SpawnListEntry(ax.class, 10, 4, 4));
        this.spawnableMonsterList.add(new SpawnListEntry(mb.class, 10, 4, 4));
        this.spawnableMonsterList.add(new SpawnListEntry(cw.class, 10, 4, 4));
        this.spawnableMonsterList.add(new SpawnListEntry(dd.class, 10, 4, 4));
        this.spawnableMonsterList.add(new SpawnListEntry(ma.class, 10, 4, 4));
        this.spawnableCreatureList.add(new SpawnListEntry(bo.class, 12, 4, 4));
        this.spawnableCreatureList.add(new SpawnListEntry(mv.class, 10, 4, 4));
        this.spawnableCreatureList.add(new SpawnListEntry(mz.class, 10, 4, 4));
        this.spawnableCreatureList.add(new SpawnListEntry(am.class, 8, 4, 4));
    }

    protected BiomeDecorator createBiomeDecorator() {
        return new BiomeDecorator(this);
    }

    private Biome setTemperatureRainfall(float f2, float f3) {
        this.temperature = f2;
        this.rainfall = f3;
        return this;
    }

    private Biome setMinMaxHeight(float f2, float f3) {
        this.minHeight = f2;
        this.maxHeight = f3;
        return this;
    }

    private Biome setAwesomeness(Awesomeness awesomeness) {
        this.awesomeness = awesomeness;
        return this;
    }

    private Biome setAwesomeness(Awesomeness awesomeness, Biome biome) {
        this.awesomeness = awesomeness;
        this.boringVariant = biome;
        return this;
    }

    public double modifyMinHeight(double d2, double d3) {
        return d2 + d3 * 0.2;
    }

    public double modifyMaxHeight(double d2, double d3) {
        return d2;
    }

    public ik getRandomWorldGenForTrees(Random random) {
        return random.nextInt(10) == 0 ? new ej() : new oa();
    }

    public int getTreeCount(Random random, double d2) {
        int n2 = this.biomeDecorator.treesPerChunk;
        if (random.nextInt(10) == 0) {
            ++n2;
        }
        return n2;
    }

    protected Biome enableSnow() {
        this.enableSnow = true;
        return this;
    }

    protected Biome setBiomeName(String string) {
        this.biomeName = string;
        return this;
    }

    protected Biome setBiomeColorizer(int n2) {
        this.unusedColorizer = n2;
        return this;
    }

    protected Biome setColor(int n2) {
        this.color = n2;
        return this;
    }

    public int getSkyColorByTemp(float f2) {
        if ((f2 /= 3.0f) < -1.0f) {
            f2 = -1.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        return Color.getHSBColor(0.62222224f - f2 * 0.05f, 0.5f + f2 * 0.1f, 1.0f).getRGB();
    }

    public List<SpawnListEntry> getSpawnableList(EnumCreatureType enumCreatureType) {
        return enumCreatureType == EnumCreatureType.monster ? this.spawnableMonsterList : (enumCreatureType == EnumCreatureType.creature ? this.spawnableCreatureList : null);
    }

    public boolean getEnableSnow() {
        return this.enableSnow;
    }

    public void buildBiomeSurface(cn cn2, Random random, byte[] byArray, int n2, int n3, double d2) {
        this.buildDefaultSurface(cn2, random, byArray, n2, n3, d2);
    }

    public final void buildDefaultSurface(cn cn2, Random random, byte[] byArray, int n2, int n3, double d2) {
        int n4 = this.topBlock;
        int n5 = this.fillerBlock;
        int n6 = -1;
        int n7 = (int)(d2 / 3.0 + 3.0 + random.nextDouble() * 0.25);
        int n8 = n2 & 0xF;
        int n9 = n3 & 0xF;
        for (int i2 = 127; i2 >= 0; --i2) {
            int n10 = n8 << 11 | n9 << 7 | i2;
            if (i2 <= random.nextInt(5)) {
                byArray[n10] = (byte)ly.A.bc;
                continue;
            }
            byte by2 = byArray[n10];
            if (by2 > 0) {
                if (by2 != ly.u.bc) continue;
                if (n6 == -1) {
                    if (n7 <= 0) {
                        n4 = 0;
                        n5 = ly.u.bc;
                    } else if (i2 >= 59 && i2 <= 64) {
                        n4 = this.topBlock;
                        n5 = this.fillerBlock;
                    }
                    if (i2 < 63 && n4 == 0) {
                        n4 = this.getFloatTemperature() < 0.15f ? ly.aU.bc : ly.C.bc;
                    }
                    n6 = n7;
                    if (i2 >= 62) {
                        byArray[n10] = (byte)n4;
                        continue;
                    }
                    if (i2 < 56 - n7) {
                        n4 = 0;
                        n5 = ly.u.bc;
                        byArray[n10] = (byte)ly.G.bc;
                        continue;
                    }
                    byArray[n10] = (byte)n5;
                    continue;
                }
                if (n6 <= 0) continue;
                --n6;
                byArray[n10] = (byte)n5;
                continue;
            }
            n6 = -1;
        }
    }

    public float getSpawningChance() {
        return 0.1f;
    }

    public final int getIntRainfall() {
        return (int)(this.rainfall * 65536.0f);
    }

    public final int getIntTemperature() {
        return (int)(this.temperature * 65536.0f);
    }

    public final float getFloatRainfall() {
        return this.rainfall;
    }

    public final float getFloatTemperature() {
        return this.temperature;
    }

    public void decorate(cn cn2, Random random, int n2, int n3) {
        this.biomeDecorator.decorate(cn2, random, n2, n3);
    }

    static {
        TAIGA.setAwesomeness(Awesomeness.NOT_KINDA_BORING, WOODS);
        ICE_PLAINS.setAwesomeness(Awesomeness.NOT_BORING);
        OLD_GROWTH_PLAINS.setAwesomeness(Awesomeness.KINDA_AWESOME);
        SNOWY_TAIGA.setAwesomeness(Awesomeness.AWESOME, SNOWY_WOODS);
        ICE_MOUNTAINS.setAwesomeness(Awesomeness.NOT_BORING);
        RAINFOREST.setAwesomeness(Awesomeness.KINDA_AWESOME);
        OASIS.setAwesomeness(Awesomeness.KINDA_AWESOME);
        ICE_DESERT.setAwesomeness(Awesomeness.KINDA_AWESOME);
        SNOWY_WOODS.setAwesomeness(Awesomeness.AWESOME, SNOWY_TAIGA);
        HIGHLANDS.setAwesomeness(Awesomeness.KINDA_AWESOME);
        HILLY_SWAMP.setAwesomeness(Awesomeness.KINDA_AWESOME);
        WINDSWEPT_WOODS.setAwesomeness(Awesomeness.KINDA_AWESOME);
        OLD_GROWTH_ICE_PLAINS.setAwesomeness(Awesomeness.KINDA_AWESOME);
    }
}

