/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.List;

public class BiomeCache {
    private final BiomeSource chunkManager;
    private long lastCleanupTime = 0L;
    private final MCHashTable2 cacheMap = new MCHashTable2();
    private final List<Block> cacheList = new ArrayList<Block>();

    public BiomeCache(BiomeSource biomeSource) {
        this.chunkManager = biomeSource;
    }

    private Block getBiomeCacheBlock(int n2, int n3) {
        long l2 = (long)(n2 >>= 4) & 0xFFFFFFFFL | ((long)(n3 >>= 4) & 0xFFFFFFFFL) << 32;
        Block block = (Block)this.cacheMap.lookup(l2);
        if (block == null) {
            block = new Block(n2, n3);
            this.cacheMap.addKey(l2, block);
            this.cacheList.add(block);
        }
        block.lastAccessTime = System.currentTimeMillis();
        return block;
    }

    public Biome getBiomeGenAt(int n2, int n3) {
        return this.getBiomeCacheBlock(n2, n3).getBiomeGenAt(n2, n3);
    }

    public void cleanupCache() {
        long l2 = System.currentTimeMillis();
        long l3 = l2 - this.lastCleanupTime;
        if (l3 > 7500L || l3 < 0L) {
            this.lastCleanupTime = l2;
            for (int i2 = 0; i2 < this.cacheList.size(); ++i2) {
                Block block = this.cacheList.get(i2);
                long l4 = l2 - block.lastAccessTime;
                if (l4 <= 30000L && l4 >= 0L) continue;
                this.cacheList.remove(i2--);
                long l5 = (long)block.xPosition & 0xFFFFFFFFL | ((long)block.zPosition & 0xFFFFFFFFL) << 32;
                this.cacheMap.removeObject(l5);
            }
        }
    }

    public Biome[] getCachedBiomes(int n2, int n3) {
        return this.getBiomeCacheBlock((int)n2, (int)n3).biomes;
    }

    class Block {
        public Biome[] biomes = new Biome[256];
        public int xPosition;
        public int zPosition;
        public long lastAccessTime;

        public Block(int n2, int n3) {
            this.xPosition = n2;
            this.zPosition = n3;
            BiomeCache.this.chunkManager.getBiomeGenAt(this.biomes, n2 << 4, n3 << 4, 16, 16, false);
        }

        public Biome getBiomeGenAt(int n2, int n3) {
            return this.biomes[n2 & 0xF | (n3 & 0xF) << 4];
        }
    }
}

