/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class BiomeSource {
    private Layer genBiomes;
    private Layer biomeIndexLayer;
    private final BiomeCache biomeCache = new BiomeCache(this);
    private final List<Biome> biomesToSpawnIn = new ArrayList<Biome>();
    public Biome[] biomes;

    protected BiomeSource() {
        this.biomesToSpawnIn.add(Biome.RAINFOREST);
        this.biomesToSpawnIn.add(Biome.FOREST);
        this.biomesToSpawnIn.add(Biome.SWAMPLAND);
        this.biomesToSpawnIn.add(Biome.SNOWY_TAIGA);
        this.biomesToSpawnIn.add(Biome.TAIGA);
        this.biomesToSpawnIn.add(Biome.SNOWY_WOODS);
        this.biomesToSpawnIn.add(Biome.WOODS);
        this.biomesToSpawnIn.add(Biome.OLD_GROWTH_PLAINS);
    }

    public BiomeSource(cn cn2) {
        this(cn2.u);
    }

    public BiomeSource(long l2) {
        this();
        Layer[] layerArray = Layer.initializeAllBiomeGenerators(l2);
        this.genBiomes = layerArray[0];
        this.biomeIndexLayer = layerArray[1];
    }

    public List<Biome> getBiomesToSpawnIn() {
        return this.biomesToSpawnIn;
    }

    public Biome getBiomeGenAtChunkCoord(ol ol2) {
        return this.getBiomeGenAt(ol2.a << 4, ol2.b << 4);
    }

    public Biome getBiomeGenAt(int n2, int n3) {
        return this.biomeCache.getBiomeGenAt(n2, n3);
    }

    public Biome[] getBiomesForGeneration(Biome[] biomeArray, int n2, int n3, int n4, int n5) {
        IntCache.resetIntCache();
        if (biomeArray == null || biomeArray.length < n4 * n5) {
            biomeArray = new Biome[n4 * n5];
        }
        int[] nArray = this.genBiomes.getInts(n2, n3, n4, n5);
        for (int i2 = 0; i2 < n4 * n5; ++i2) {
            biomeArray[i2] = Biome.biomes[nArray[i2]];
        }
        return biomeArray;
    }

    public Biome[] getBiomeGenAt(int n2, int n3, int n4, int n5) {
        if (n4 == 16 && n5 == 16 && (n2 & 0xF) == 0 && (n3 & 0xF) == 0) {
            return this.biomeCache.getCachedBiomes(n2, n3);
        }
        this.biomes = this.loadBlockGeneratorData(this.biomes, n2, n3, n4, n5);
        return this.biomes;
    }

    public float[] getRainfall(float[] fArray, int n2, int n3, int n4, int n5) {
        IntCache.resetIntCache();
        if (fArray == null || fArray.length < n4 * n5) {
            fArray = new float[n4 * n5];
        }
        int[] nArray = this.biomeIndexLayer.getInts(n2, n3, n4, n5);
        for (int i2 = 0; i2 < n4 * n5; ++i2) {
            float f2 = (float)Biome.biomes[nArray[i2]].getIntRainfall() / 65536.0f;
            if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            fArray[i2] = f2;
        }
        return fArray;
    }

    public float[] getTemperatures(float[] fArray, int n2, int n3, int n4, int n5) {
        IntCache.resetIntCache();
        if (fArray == null || fArray.length < n4 * n5) {
            fArray = new float[n4 * n5];
        }
        int[] nArray = this.biomeIndexLayer.getInts(n2, n3, n4, n5);
        for (int i2 = 0; i2 < n4 * n5; ++i2) {
            float f2 = (float)Biome.biomes[nArray[i2]].getIntTemperature() / 65536.0f;
            if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            fArray[i2] = f2;
        }
        return fArray;
    }

    public Biome[] loadBlockGeneratorData(Biome[] biomeArray, int n2, int n3, int n4, int n5) {
        return this.getBiomeGenAt(biomeArray, n2, n3, n4, n5, true);
    }

    public Biome[] getBiomeGenAt(Biome[] biomeArray, int n2, int n3, int n4, int n5, boolean bl2) {
        IntCache.resetIntCache();
        if (biomeArray == null || biomeArray.length < n4 * n5) {
            biomeArray = new Biome[n4 * n5];
        }
        if (bl2 && n4 == 16 && n5 == 16 && (n2 & 0xF) == 0 && (n3 & 0xF) == 0) {
            Biome[] biomeArray2 = this.biomeCache.getCachedBiomes(n2, n3);
            System.arraycopy(biomeArray2, 0, biomeArray, 0, n4 * n5);
            return biomeArray;
        }
        int[] nArray = this.biomeIndexLayer.getInts(n2, n3, n4, n5);
        for (int i2 = 0; i2 < n4 * n5; ++i2) {
            biomeArray[i2] = Biome.biomes[nArray[i2]];
        }
        return biomeArray;
    }

    public boolean areBiomesViable(int n2, int n3, int n4, List<Biome> list) {
        int n5 = n2 - n4 >> 2;
        int n6 = n3 - n4 >> 2;
        int n7 = n2 + n4 >> 2;
        int n8 = n3 + n4 >> 2;
        int n9 = n7 - n5 + 1;
        int n10 = n8 - n6 + 1;
        int[] nArray = this.genBiomes.getInts(n5, n6, n9, n10);
        for (int i2 = 0; i2 < n9 * n10; ++i2) {
            Biome biome = Biome.biomes[nArray[i2]];
            if (list.contains(biome)) continue;
            return false;
        }
        return true;
    }

    public mt findBiomePosition(int n2, int n3, int n4, List<Biome> list, Random random) {
        int n5 = n2 - n4 >> 2;
        int n6 = n3 - n4 >> 2;
        int n7 = n2 + n4 >> 2;
        int n8 = n3 + n4 >> 2;
        int n9 = n7 - n5 + 1;
        int n10 = n8 - n6 + 1;
        int[] nArray = this.genBiomes.getInts(n5, n6, n9, n10);
        mt mt2 = null;
        int n11 = 0;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n12 = n5 + i2 % n9 << 2;
            int n13 = n6 + i2 / n9 << 2;
            Biome biome = Biome.biomes[nArray[i2]];
            if (!list.contains(biome) || mt2 != null && random.nextInt(n11 + 1) != 0) continue;
            mt2 = new mt(n12, 0, n13);
            ++n11;
        }
        return mt2;
    }

    public void cleanupCache() {
        this.biomeCache.cleanupCache();
    }
}

