/*
 * Decompiled with CFR 0.152.
 */
public abstract class Layer {
    private long worldGenSeed;
    protected Layer parent;
    private long chunkSeed;
    private long baseSeed;

    public static Layer[] initializeAllBiomeGenerators(long l2) {
        LayerIslandInit layerIslandInit = new LayerIslandInit(1L);
        LayerZoomFuzzy layerZoomFuzzy = new LayerZoomFuzzy(2000L, layerIslandInit);
        LayerIsland layerIsland = new LayerIsland(1L, layerZoomFuzzy);
        LayerZoom layerZoom = new LayerZoom(2001L, layerIsland);
        layerIsland = new LayerIsland(2L, layerZoom);
        layerZoom = new LayerZoom(2002L, layerIsland);
        layerIsland = new LayerIsland(3L, layerZoom);
        LayerSnow layerSnow = new LayerSnow(2L, layerIsland);
        layerZoom = new LayerZoom(2003L, layerSnow);
        layerIsland = new LayerIsland(3L, layerZoom);
        layerZoom = new LayerZoom(2004L, layerIsland);
        layerIsland = new LayerIsland(3L, layerZoom);
        int n2 = 4;
        Layer layer = LayerZoom.magnify(1000L, layerIsland, 0);
        LayerInitRiver layerInitRiver = new LayerInitRiver(100L, layer);
        layer = LayerZoom.magnify(1000L, layerInitRiver, n2 + 1);
        LayerComputeRiver layerComputeRiver = new LayerComputeRiver(1L, layer);
        layer = LayerZoom.magnify(1000L + (long)n2 + 2L, layerComputeRiver, 1);
        LayerSmooth layerSmooth = new LayerSmooth(1000L, layer);
        Layer layer2 = LayerZoom.magnify(1000L, layerIsland, 0);
        LayerApplyBiomes layerApplyBiomes = new LayerApplyBiomes(200L, layer2);
        Layer layer3 = LayerZoom.magnify(1000L, layerApplyBiomes, 2);
        for (int i2 = 0; i2 < n2; ++i2) {
            layer3 = new LayerZoom(1000 + i2, layer3);
            if (i2 != 0) continue;
            layer3 = new LayerIsland(3L, layer3);
        }
        LayerSmooth layerSmooth2 = new LayerSmooth(1000L, layer3);
        LayerMixRiver layerMixRiver = new LayerMixRiver(100L, layerSmooth2, layerSmooth);
        LayerZoomVoronoi layerZoomVoronoi = new LayerZoomVoronoi(10L, layerMixRiver);
        layerMixRiver.initWorldGenSeed(l2);
        layerZoomVoronoi.initWorldGenSeed(l2);
        return new Layer[]{layerMixRiver, layerZoomVoronoi};
    }

    public Layer(long l2) {
        this.baseSeed = l2;
        this.baseSeed *= this.baseSeed * 6364136223846793005L + 1442695040888963407L;
        this.baseSeed += l2;
        this.baseSeed *= this.baseSeed * 6364136223846793005L + 1442695040888963407L;
        this.baseSeed += l2;
        this.baseSeed *= this.baseSeed * 6364136223846793005L + 1442695040888963407L;
        this.baseSeed += l2;
    }

    public void initWorldGenSeed(long l2) {
        this.worldGenSeed = l2;
        if (this.parent != null) {
            this.parent.initWorldGenSeed(l2);
        }
        this.worldGenSeed *= this.worldGenSeed * 6364136223846793005L + 1442695040888963407L;
        this.worldGenSeed += this.baseSeed;
        this.worldGenSeed *= this.worldGenSeed * 6364136223846793005L + 1442695040888963407L;
        this.worldGenSeed += this.baseSeed;
        this.worldGenSeed *= this.worldGenSeed * 6364136223846793005L + 1442695040888963407L;
        this.worldGenSeed += this.baseSeed;
    }

    public void initChunkSeed(long l2, long l3) {
        this.chunkSeed = this.worldGenSeed;
        this.chunkSeed *= this.chunkSeed * 6364136223846793005L + 1442695040888963407L;
        this.chunkSeed += l2;
        this.chunkSeed *= this.chunkSeed * 6364136223846793005L + 1442695040888963407L;
        this.chunkSeed += l3;
        this.chunkSeed *= this.chunkSeed * 6364136223846793005L + 1442695040888963407L;
        this.chunkSeed += l2;
        this.chunkSeed *= this.chunkSeed * 6364136223846793005L + 1442695040888963407L;
        this.chunkSeed += l3;
    }

    protected int nextInt(int n2) {
        int n3 = (int)((this.chunkSeed >> 24) % (long)n2);
        if (n3 < 0) {
            n3 += n2;
        }
        this.chunkSeed *= this.chunkSeed * 6364136223846793005L + 1442695040888963407L;
        this.chunkSeed += this.worldGenSeed;
        return n3;
    }

    public abstract int[] getInts(int var1, int var2, int var3, int var4);
}

