/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Random;

public class LayerApplyBiomes
extends Layer {
    private static final Biome[] ALL_BIOMES = new Biome[]{Biome.DESERT, Biome.FOREST, Biome.EXTREME_HILLS, Biome.SWAMPLAND, Biome.PLAINS, Biome.TAIGA, Biome.OASIS, Biome.RAINFOREST, Biome.WINDSWEPT_WOODS, Biome.HILLY_SWAMP, Biome.OLD_GROWTH_PLAINS, Biome.HIGHLANDS};
    private static final Biome[] ALL_SNOWY_BIOMES = new Biome[]{Biome.ICE_DESERT, Biome.SNOWY_WOODS, Biome.ICE_MOUNTAINS, Biome.ICE_PLAINS, Biome.OLD_GROWTH_ICE_PLAINS, Biome.SNOWY_TAIGA};
    private Biome[] allowedBiomes;
    private Biome[] snowyBiomes;

    public LayerApplyBiomes(long l2, Layer layer) {
        super(l2);
        this.parent = layer;
    }

    @Override
    public void initWorldGenSeed(long l2) {
        super.initWorldGenSeed(l2);
        Random random = new Random(l2);
        float f2 = random.nextFloat();
        ArrayList<Biome> arrayList = new ArrayList<Biome>();
        for (Biome biome : ALL_BIOMES) {
            if (!biome.awesomeness.isAwesomeEnough(f2, random)) {
                biome = biome.boringVariant;
            }
            if (biome == null) continue;
            arrayList.add(biome);
        }
        Object object = new ArrayList();
        for (Biome biome : ALL_SNOWY_BIOMES) {
            if (!biome.awesomeness.isAwesomeEnough(f2, random)) {
                biome = biome.boringVariant;
            }
            if (biome == null) continue;
            object.add(biome);
        }
        if (!object.contains(Biome.ICE_PLAINS)) {
            if (arrayList.contains(Biome.TAIGA) && Awesomeness.NOT_VERY_BORING.isAwesomeEnough(f2, random)) {
                arrayList.set(arrayList.indexOf(Biome.TAIGA), Biome.SNOWY_TAIGA);
                if (!Biome.SNOWY_TAIGA.awesomeness.isAwesomeEnough(f2, random)) {
                    arrayList.set(arrayList.indexOf(Biome.SNOWY_TAIGA), Biome.SNOWY_TAIGA.boringVariant);
                }
            }
            object = arrayList;
        }
        this.allowedBiomes = arrayList.toArray(new Biome[0]);
        this.snowyBiomes = object.toArray(new Biome[0]);
    }

    @Override
    public int[] getInts(int n2, int n3, int n4, int n5) {
        int[] nArray = this.parent.getInts(n2, n3, n4, n5);
        int[] nArray2 = IntCache.getIntCache(n4 * n5);
        for (int i2 = 0; i2 < n5; ++i2) {
            for (int i3 = 0; i3 < n4; ++i3) {
                this.initChunkSeed(i3 + n2, i2 + n3);
                int n6 = i3 + i2 * n4;
                Biome[] biomeArray = nArray[n6] == Biome.ICE_PLAINS.biomeID ? this.snowyBiomes : this.allowedBiomes;
                nArray2[n6] = nArray[n6] > 0 ? biomeArray[this.nextInt((int)biomeArray.length)].biomeID : 0;
            }
        }
        return nArray2;
    }
}

