/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jorbis;

class Mdct {
    int n;
    int log2n;
    float[] trig;
    int[] bitrev;
    float scale;
    float[] _x = new float[1024];
    float[] _w = new float[1024];

    Mdct() {
    }

    void init(int n2) {
        this.bitrev = new int[n2 / 4];
        this.trig = new float[n2 + n2 / 4];
        this.log2n = (int)Math.rint(Math.log(n2) / Math.log(2.0));
        this.n = n2;
        int AE = 0;
        int AO = 1;
        int BE = AE + n2 / 2;
        int BO = BE + 1;
        int CE = BE + n2 / 2;
        int CO = CE + 1;
        int i2 = 0;
        while (i2 < n2 / 4) {
            this.trig[AE + i2 * 2] = (float)Math.cos(Math.PI / (double)n2 * (double)(4 * i2));
            this.trig[AO + i2 * 2] = (float)(-Math.sin(Math.PI / (double)n2 * (double)(4 * i2)));
            this.trig[BE + i2 * 2] = (float)Math.cos(Math.PI / (double)(2 * n2) * (double)(2 * i2 + 1));
            this.trig[BO + i2 * 2] = (float)Math.sin(Math.PI / (double)(2 * n2) * (double)(2 * i2 + 1));
            ++i2;
        }
        i2 = 0;
        while (i2 < n2 / 8) {
            this.trig[CE + i2 * 2] = (float)Math.cos(Math.PI / (double)n2 * (double)(4 * i2 + 2));
            this.trig[CO + i2 * 2] = (float)(-Math.sin(Math.PI / (double)n2 * (double)(4 * i2 + 2)));
            ++i2;
        }
        int mask = (1 << this.log2n - 1) - 1;
        int msb = 1 << this.log2n - 2;
        int i3 = 0;
        while (i3 < n2 / 8) {
            int acc = 0;
            int j2 = 0;
            while (msb >>> j2 != 0) {
                if ((msb >>> j2 & i3) != 0) {
                    acc |= 1 << j2;
                }
                ++j2;
            }
            this.bitrev[i3 * 2] = ~acc & mask;
            this.bitrev[i3 * 2 + 1] = acc;
            ++i3;
        }
        this.scale = 4.0f / (float)n2;
    }

    void clear() {
    }

    void forward(float[] in, float[] out) {
    }

    synchronized void backward(float[] in, float[] out) {
        if (this._x.length < this.n / 2) {
            this._x = new float[this.n / 2];
        }
        if (this._w.length < this.n / 2) {
            this._w = new float[this.n / 2];
        }
        float[] x2 = this._x;
        float[] w2 = this._w;
        int n2 = this.n >>> 1;
        int n4 = this.n >>> 2;
        int n8 = this.n >>> 3;
        int inO = 1;
        int xO = 0;
        int A2 = n2;
        int i2 = 0;
        while (i2 < n8) {
            x2[xO++] = -in[inO + 2] * this.trig[(A2 -= 2) + 1] - in[inO] * this.trig[A2];
            x2[xO++] = in[inO] * this.trig[A2 + 1] - in[inO + 2] * this.trig[A2];
            inO += 4;
            ++i2;
        }
        inO = n2 - 4;
        i2 = 0;
        while (i2 < n8) {
            x2[xO++] = in[inO] * this.trig[(A2 -= 2) + 1] + in[inO + 2] * this.trig[A2];
            x2[xO++] = in[inO] * this.trig[A2] - in[inO + 2] * this.trig[A2 + 1];
            inO -= 4;
            ++i2;
        }
        float[] xxx = this.mdct_kernel(x2, w2, this.n, n2, n4, n8);
        int xx = 0;
        int B2 = n2;
        int o1 = n4;
        int o2 = o1 - 1;
        int o3 = n4 + n2;
        int o4 = o3 - 1;
        int i3 = 0;
        while (i3 < n4) {
            float temp1 = xxx[xx] * this.trig[B2 + 1] - xxx[xx + 1] * this.trig[B2];
            float temp2 = -(xxx[xx] * this.trig[B2] + xxx[xx + 1] * this.trig[B2 + 1]);
            out[o1] = -temp1;
            out[o2] = temp1;
            out[o3] = temp2;
            out[o4] = temp2;
            ++o1;
            --o2;
            ++o3;
            --o4;
            xx += 2;
            B2 += 2;
            ++i3;
        }
    }

    private float[] mdct_kernel(float[] x2, float[] w2, int n2, int n22, int n4, int n8) {
        int xA = n4;
        int xB = 0;
        int w22 = n4;
        int A2 = n22;
        int i2 = 0;
        while (i2 < n4) {
            float x0 = x2[xA] - x2[xB];
            w2[w22 + i2] = x2[xA++] + x2[xB++];
            float x1 = x2[xA] - x2[xB];
            w2[i2++] = x0 * this.trig[A2 -= 4] + x1 * this.trig[A2 + 1];
            w2[i2] = x1 * this.trig[A2] - x0 * this.trig[A2 + 1];
            w2[w22 + i2] = x2[xA++] + x2[xB++];
            ++i2;
        }
        i2 = 0;
        while (i2 < this.log2n - 3) {
            int k0 = n2 >>> i2 + 2;
            int k1 = 1 << i2 + 3;
            int wbase = n22 - 2;
            A2 = 0;
            int r2 = 0;
            while (r2 < k0 >>> 2) {
                int w1 = wbase;
                w22 = w1 - (k0 >> 1);
                float AEv = this.trig[A2];
                float AOv = this.trig[A2 + 1];
                wbase -= 2;
                ++k0;
                int s2 = 0;
                while (s2 < 2 << i2) {
                    float wB = w2[w1] - w2[w22];
                    x2[w1] = w2[w1] + w2[w22];
                    float wA = w2[++w1] - w2[++w22];
                    x2[w1] = w2[w1] + w2[w22];
                    x2[w22] = wA * AEv - wB * AOv;
                    x2[w22 - 1] = wB * AEv + wA * AOv;
                    w1 -= k0;
                    w22 -= k0;
                    ++s2;
                }
                --k0;
                A2 += k1;
                ++r2;
            }
            float[] temp = w2;
            w2 = x2;
            x2 = temp;
            ++i2;
        }
        int C2 = n2;
        int bit = 0;
        int x1 = 0;
        int x22 = n22 - 1;
        int i3 = 0;
        while (i3 < n8) {
            int t1 = this.bitrev[bit++];
            int t2 = this.bitrev[bit++];
            float wA = w2[t1] - w2[t2 + 1];
            float wB = w2[t1 - 1] + w2[t2];
            float wC = w2[t1] + w2[t2 + 1];
            float wD = w2[t1 - 1] - w2[t2];
            float wACE = wA * this.trig[C2];
            float wBCE = wB * this.trig[C2++];
            float wACO = wA * this.trig[C2];
            float wBCO = wB * this.trig[C2++];
            x2[x1++] = (wC + wACO + wBCE) * 0.5f;
            x2[x22--] = (-wD + wBCO - wACE) * 0.5f;
            x2[x1++] = (wD + wBCO - wACE) * 0.5f;
            x2[x22--] = (wC - wACO - wBCE) * 0.5f;
            ++i3;
        }
        return x2;
    }
}

