/*
 * Decompiled with CFR 0.152.
 */
package b100.json.element;

import b100.json.element.JsonElement;
import b100.json.element.JsonNumber;
import b100.utils.ArrayIterator;
import b100.utils.InvalidCharacterException;
import b100.utils.StringReader;
import b100.utils.StringWriter;
import b100.utils.Utils;
import b100.utils.interfaces.Condition;
import java.util.ArrayList;
import java.util.Iterator;

public class JsonArray
implements JsonElement,
Iterable<JsonElement> {
    private JsonElement[] elements;
    private boolean compact;

    public JsonArray(int length) {
        this.compact = false;
        this.elements = new JsonElement[length];
    }

    public JsonArray(JsonElement[] elements) {
        this.compact = false;
        this.elements = elements;
    }

    public JsonArray(StringReader reader) {
        ArrayList<JsonElement> elementsList;
        block4: {
            this.compact = false;
            elementsList = new ArrayList<JsonElement>();
            reader.skipWhitespace();
            reader.expectAndSkip('[');
            while (true) {
                reader.skipWhitespace();
                if (reader.get() == ']') {
                    reader.next();
                    break block4;
                }
                elementsList.add(JsonElement.readElement(reader));
                reader.skipWhitespace();
                if (reader.get() != ',') break;
                reader.next();
            }
            if (reader.get() == ']') {
                reader.next();
            } else {
                throw new InvalidCharacterException(reader);
            }
        }
        this.elements = Utils.toArray(JsonElement.class, elementsList);
    }

    public JsonElement query(Condition<JsonElement> condition) {
        for (JsonElement e2 : this.elements) {
            if (!condition.isTrue(e2)) continue;
            return e2;
        }
        return null;
    }

    public String toString() {
        return "JsonArray: " + this.elements.length + " elements";
    }

    @Override
    public void write(StringWriter writer) {
        if (this.elements.length == 0) {
            writer.write("[]");
            return;
        }
        if (this.isCompact()) {
            writer.write("[ ");
        } else {
            writer.writeln("[");
        }
        writer.addTab();
        int i2 = 0;
        for (JsonElement element : this.elements) {
            element.write(writer);
            if (i2 < this.elements.length - 1) {
                writer.write(", ");
            }
            if (!this.isCompact()) {
                writer.write('\n');
            }
            ++i2;
        }
        writer.removeTab();
        if (this.isCompact()) {
            writer.write(" ]");
        } else {
            writer.write("]");
        }
    }

    @Override
    public Iterator<JsonElement> iterator() {
        return new ArrayIterator<JsonElement>(this.elements);
    }

    public int length() {
        return this.elements.length;
    }

    public JsonElement get(int i2) {
        return this.elements[i2];
    }

    public JsonArray set(int i2, JsonElement element) {
        this.elements[i2] = element;
        return this;
    }

    public JsonArray set(int i2, Number number) {
        this.elements[i2] = new JsonNumber(number);
        return this;
    }

    public JsonArray setCompact(boolean compact) {
        this.compact = compact;
        return this;
    }

    public boolean isCompact() {
        return this.compact;
    }
}

