/*
 * Decompiled with CFR 0.152.
 */
package b100.json.element;

import b100.json.element.JsonElement;
import b100.utils.InvalidCharacterException;
import b100.utils.StringReader;
import b100.utils.StringWriter;
import b100.utils.Utils;

public class JsonNumber
implements JsonElement {
    public Number value;

    public JsonNumber(Number number) {
        this.value = Utils.requireNonNull(number);
    }

    public JsonNumber(int i2) {
        this.value = i2;
    }

    public JsonNumber(long l2) {
        this.value = l2;
    }

    public JsonNumber(double d2) {
        this.value = d2;
    }

    public JsonNumber(float f2) {
        this.value = Float.valueOf(f2);
    }

    public JsonNumber(StringReader reader) {
        StringWriter numberString = new StringWriter();
        boolean decimal = false;
        if (reader.get() == '-') {
            numberString.write(reader.get());
            reader.next();
        }
        this.readInteger(reader, numberString);
        if (reader.get() == '.') {
            this.readDecimal(reader, numberString);
            decimal = true;
        }
        if (reader.get() == 'e' || reader.get() == 'E') {
            this.readExponent(reader, numberString);
        }
        if (reader.get() == ',' || reader.get() == '}' || reader.isWhitespace(reader.get())) {
            String str = numberString.toString();
            if (decimal) {
                float floatVal = 0.0f;
                double doubleVal = 0.0;
                try {
                    floatVal = Float.parseFloat(str);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                doubleVal = Double.parseDouble(str);
                this.value = (double)floatVal == doubleVal ? (Number)Float.valueOf(floatVal) : (Number)doubleVal;
            } else {
                int intVal = 0;
                long longVal = 0L;
                try {
                    intVal = Integer.parseInt(str);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                longVal = Long.parseLong(str);
                this.value = (long)intVal == longVal ? (Number)intVal : (Number)longVal;
            }
        } else {
            throw new InvalidCharacterException(reader);
        }
    }

    private void readInteger(StringReader reader, StringWriter numberString) {
        if (reader.get() == '0') {
            numberString.write(reader.get());
            reader.next();
            return;
        }
        if (reader.get() >= '1' && reader.get() <= '9') {
            numberString.write(reader.get());
            reader.next();
            while (reader.get() >= '0' && reader.get() <= '9') {
                numberString.write(reader.get());
                reader.next();
            }
            return;
        }
    }

    private void readDecimal(StringReader reader, StringWriter numberString) {
        reader.expectAndSkip('.');
        numberString.write('.');
        while (reader.get() >= '0' && reader.get() <= '9') {
            numberString.write(reader.get());
            reader.next();
        }
    }

    private void readExponent(StringReader reader, StringWriter numberString) {
        reader.expectOne("eE");
        numberString.write(reader.get());
        reader.next();
        if (reader.get() == '+' || reader.get() == '-') {
            numberString.write(reader.get());
            reader.next();
        }
        while (reader.get() >= '0' && reader.get() <= '9') {
            numberString.write(reader.get());
            reader.next();
        }
    }

    @Override
    public void write(StringWriter writer) {
        writer.write(this.value.toString());
    }

    public int getInteger() {
        return this.value.intValue();
    }

    public double getDouble() {
        return this.value.doubleValue();
    }

    public float getFloat() {
        return this.value.floatValue();
    }

    public long getLong() {
        return this.value.longValue();
    }

    public byte getByte() {
        return this.value.byteValue();
    }

    public short getShort() {
        return this.value.shortValue();
    }

    public void set(Number n2) {
        this.value = Utils.requireNonNull(n2);
    }

    public void set(int i2) {
        this.value = i2;
    }

    public void set(long l2) {
        this.value = l2;
    }

    public void set(float f2) {
        this.value = Float.valueOf(f2);
    }

    public void set(double d2) {
        this.value = d2;
    }

    public boolean isInteger() {
        return this.value instanceof Integer;
    }

    public boolean isLong() {
        return this.value instanceof Long;
    }

    public boolean isFloat() {
        return this.value instanceof Float;
    }

    public boolean isDouble() {
        return this.value instanceof Double;
    }
}

