/*
 * Decompiled with CFR 0.152.
 */
package b100.json.element;

import b100.json.element.JsonArray;
import b100.json.element.JsonBoolean;
import b100.json.element.JsonElement;
import b100.json.element.JsonEntry;
import b100.json.element.JsonNumber;
import b100.json.element.JsonString;
import b100.utils.InvalidCharacterException;
import b100.utils.StringReader;
import b100.utils.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class JsonObject
implements JsonElement,
Iterable<JsonEntry> {
    private List<JsonEntry> entries;
    private boolean compact;

    public JsonObject() {
        this.compact = false;
        this.entries = new ArrayList<JsonEntry>();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JsonObject(StringReader reader) {
        block1: {
            this();
            reader.skipWhitespace();
            reader.expectAndSkip('{');
            while (true) {
                reader.skipWhitespace();
                if (reader.get() != '\"') break block1;
                String id2 = new JsonString((StringReader)reader).value;
                reader.skipWhitespace();
                reader.expectAndSkip(':');
                JsonElement element = JsonElement.readElement(reader);
                this.set(id2, element);
                reader.skipWhitespace();
                if (reader.get() != ',') break;
                reader.next();
            }
            if (reader.get() != '}') throw new InvalidCharacterException(reader);
            reader.next();
            return;
        }
        if (reader.get() != '}') throw new InvalidCharacterException(reader);
        reader.next();
    }

    @Override
    public void write(StringWriter writer) {
        writer.write("{");
        writer.addTab();
        int i2 = 0;
        for (JsonEntry entry : this.entries) {
            if (!this.isCompact()) {
                writer.write('\n');
            } else {
                writer.write(' ');
            }
            new JsonString(entry.name).write(writer);
            writer.write(": ");
            entry.value.write(writer);
            if (i2 < this.entries.size() - 1) {
                writer.write(',');
            }
            ++i2;
        }
        if (i2 > 0) {
            if (!this.isCompact()) {
                writer.write('\n');
            } else {
                writer.write(' ');
            }
        }
        writer.removeTab();
        writer.write("}");
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        this.write(writer);
        return writer.toString();
    }

    public JsonObject getOrCreateObject(String id2) {
        JsonObject object = this.getObject(id2);
        if (object == null) {
            object = new JsonObject();
            this.set(id2, object);
        }
        return object;
    }

    public JsonEntry getOrCreateEntry(String string) {
        JsonEntry entry = this.getEntry(string);
        if (entry == null) {
            entry = new JsonEntry(string, null);
            this.entries.add(entry);
        }
        return entry;
    }

    public JsonEntry getEntry(String string) {
        for (JsonEntry e2 : this.entries) {
            if (!e2.equalsId(string)) continue;
            return e2;
        }
        return null;
    }

    public JsonElement get(String id2) {
        JsonEntry entry = this.getEntry(id2);
        return entry != null ? entry.value : null;
    }

    public JsonObject getObject(String id2) {
        JsonElement element = this.get(id2);
        return element != null ? element.getAsObject() : null;
    }

    public JsonArray getArray(String id2) {
        JsonElement element = this.get(id2);
        return element != null ? element.getAsArray() : null;
    }

    public JsonString getJsonString(String id2) {
        return this.get(id2).getAsString();
    }

    public JsonNumber getJsonNumber(String id2) {
        return this.get(id2).getAsNumber();
    }

    public JsonBoolean getJsonBoolean(String id2) {
        return this.get(id2).getAsBoolean();
    }

    public String getString(String id2) {
        return this.get((String)id2).getAsString().value;
    }

    public Number getNumber(String id2) {
        return this.get((String)id2).getAsNumber().value;
    }

    public int getInt(String id2) {
        return this.getNumber(id2).intValue();
    }

    public long getLong(String id2) {
        return this.getNumber(id2).longValue();
    }

    public double getDouble(String id2) {
        return this.getNumber(id2).doubleValue();
    }

    public float getFloat(String id2) {
        return this.getNumber(id2).floatValue();
    }

    public byte getByte(String id2) {
        return this.getNumber(id2).byteValue();
    }

    public short getShort(String id2) {
        return this.getNumber(id2).shortValue();
    }

    public boolean getBoolean(String id2) {
        return this.get((String)id2).getAsBoolean().value;
    }

    public int getInt(String id2, int defaultValue) {
        JsonEntry entry = this.getOrCreateEntry(id2);
        if (entry.value == null || !(entry.value instanceof JsonNumber)) {
            entry.value = new JsonNumber(defaultValue);
        }
        return entry.value.getAsNumber().getInteger();
    }

    public long getLong(String id2, long defaultValue) {
        JsonEntry entry = this.getOrCreateEntry(id2);
        if (entry.value == null || !(entry.value instanceof JsonNumber)) {
            entry.value = new JsonNumber(defaultValue);
        }
        return entry.value.getAsNumber().getLong();
    }

    public float getFloat(String id2, float defaultValue) {
        JsonEntry entry = this.getOrCreateEntry(id2);
        if (entry.value == null || !(entry.value instanceof JsonNumber)) {
            entry.value = new JsonNumber(defaultValue);
        }
        return entry.value.getAsNumber().getFloat();
    }

    public double getDouble(String id2, double defaultValue) {
        JsonEntry entry = this.getOrCreateEntry(id2);
        if (entry.value == null || !(entry.value instanceof JsonNumber)) {
            entry.value = new JsonNumber(defaultValue);
        }
        return entry.value.getAsNumber().getDouble();
    }

    public short getShort(String id2, short defaultValue) {
        JsonEntry entry = this.getOrCreateEntry(id2);
        if (entry.value == null || !(entry.value instanceof JsonNumber)) {
            entry.value = new JsonNumber(defaultValue);
        }
        return entry.value.getAsNumber().getShort();
    }

    public byte getByte(String id2, byte defaultValue) {
        JsonEntry entry = this.getOrCreateEntry(id2);
        if (entry.value == null || !(entry.value instanceof JsonNumber)) {
            entry.value = new JsonNumber(defaultValue);
        }
        return entry.value.getAsNumber().getByte();
    }

    public boolean getBoolean(String id2, boolean defaultValue) {
        JsonEntry entry = this.getOrCreateEntry(id2);
        if (entry.value == null || !(entry.value instanceof JsonBoolean)) {
            entry.value = new JsonBoolean(defaultValue);
        }
        return entry.value.getAsBoolean().value;
    }

    public JsonObject set(String id2, JsonElement element) {
        this.getOrCreateEntry((String)id2).value = element;
        return this;
    }

    public JsonObject set(String id2, String s2) {
        return this.set(id2, new JsonString(s2));
    }

    public JsonObject set(String id2, int n2) {
        return this.set(id2, new JsonNumber(n2));
    }

    public JsonObject set(String id2, long n2) {
        return this.set(id2, new JsonNumber(n2));
    }

    public JsonObject set(String id2, float n2) {
        return this.set(id2, new JsonNumber(n2));
    }

    public JsonObject set(String id2, double n2) {
        return this.set(id2, new JsonNumber(n2));
    }

    public JsonObject set(String id2, short n2) {
        return this.set(id2, new JsonNumber(n2));
    }

    public JsonObject set(String id2, byte n2) {
        return this.set(id2, new JsonNumber(n2));
    }

    public JsonObject set(String id2, boolean b2) {
        return this.set(id2, new JsonBoolean(b2));
    }

    public List<JsonElement> elementList() {
        ArrayList<JsonElement> elements = new ArrayList<JsonElement>();
        for (JsonEntry entry : this.entries) {
            elements.add(entry.value);
        }
        return elements;
    }

    public List<String> idList() {
        ArrayList<String> elements = new ArrayList<String>();
        for (JsonEntry entry : this.entries) {
            elements.add(entry.name);
        }
        return elements;
    }

    public List<JsonEntry> entryList() {
        return this.entries;
    }

    public boolean has(String id2) {
        return this.getEntry(id2) != null;
    }

    public boolean has(String name, JsonElement element) {
        JsonEntry entry = this.getEntry(name);
        if (entry != null) {
            return entry.value.equals(element);
        }
        return false;
    }

    public boolean has(String name, String string) {
        JsonEntry entry = this.getEntry(name);
        if (entry != null && entry.value.isString()) {
            return entry.value.getAsString().value.equals(string);
        }
        return false;
    }

    @Override
    public Iterator<JsonEntry> iterator() {
        return this.entries.iterator();
    }

    public void setCompact(boolean b2) {
        this.compact = true;
    }

    public boolean isCompact() {
        return this.compact;
    }
}

