/*
 * Decompiled with CFR 0.152.
 */
package b100.utils;

import b100.utils.StringReader;
import b100.utils.StringWriter;
import java.io.PrintStream;
import java.util.List;

public class InvalidCharacterException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private StringReader reader;
    private int line = 1;
    private int column = 1;

    public InvalidCharacterException(StringReader stringReader) {
        this.reader = stringReader;
        String string = this.reader.string();
        for (int i2 = 0; i2 < this.reader.position(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '\n') {
                ++this.line;
                this.column = 1;
                continue;
            }
            ++this.column;
        }
    }

    public String getLinePreview() {
        StringWriter stringWriter = new StringWriter();
        stringWriter.writeln(this.getMessage());
        stringWriter.writeln();
        List<String> lines = this.reader.lines();
        int startLine = Math.max(0, this.line - 4);
        int endLine = Math.min(lines.size() - 1, this.line);
        for (int i2 = startLine; i2 < endLine; ++i2) {
            String line = lines.get(i2);
            stringWriter.writeln(line);
            if (i2 + 1 != this.line) continue;
            for (int j2 = 0; j2 < line.length(); ++j2) {
                int l2 = InvalidCharacterException.getPrintChar(line.charAt(j2), true).length();
                boolean thisChar = j2 + 1 == this.column;
                for (int k2 = 0; k2 < l2; ++k2) {
                    stringWriter.write(thisChar ? (char)'^' : ' ');
                }
            }
            stringWriter.writeln();
        }
        return stringWriter.toString();
    }

    @Override
    public String getMessage() {
        return "Invalid character \"" + InvalidCharacterException.getPrintChar(this.reader.get(), false) + "\" at line " + this.line + " column " + this.column + " (index " + this.reader.position() + ")";
    }

    public static String getPrintChar(char c2, boolean a2) {
        if (c2 == '\\') {
            return a2 ? "\\" : "\\\\";
        }
        if (c2 == '\n') {
            return a2 ? " " : "\\n";
        }
        if (c2 == '\t') {
            return a2 ? " " : "\\t";
        }
        return "" + c2;
    }

    @Override
    public void printStackTrace(PrintStream s2) {
        try {
            s2.println(this.getLinePreview());
        }
        catch (Exception e2) {
            s2.println("Could not create line preview: " + e2.getClass().getName() + ": " + e2.getMessage());
        }
        super.printStackTrace(s2);
    }
}

