/*
 * Decompiled with CFR 0.152.
 */
package b100.utils;

import b100.utils.Utils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;

public abstract class ReflectUtils {
    public static Field getField(Class<?> clazz, String ... names) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        if (names.length == 0) {
            throw new RuntimeException("No Name!");
        }
        try {
            for (String name : names) {
                try {
                    Field field = clazz.getDeclaredField(name);
                    return field;
                }
                catch (Exception field) {
                    try {
                        Field field2 = clazz.getField(name);
                        return field2;
                    }
                    catch (Exception exception) {
                    }
                }
            }
            StringBuilder allNames = new StringBuilder();
            for (int i2 = 0; i2 < names.length; ++i2) {
                if (i2 > 0) {
                    allNames.append(' ');
                }
                allNames.append(names[i2]);
            }
            throw new RuntimeException("Class " + clazz.getName() + " doesn't have any of these Fields: " + allNames.toString());
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    public static <E> E getValue(Field field, Object object, Class<E> clazz) {
        if (field == null) {
            throw new NullPointerException("Field is null!");
        }
        if (clazz == null) {
            throw new NullPointerException("Class is null!");
        }
        ReflectUtils.setFieldAccessible(field);
        Object value = ReflectUtils.getValue(field, object);
        if (value == null) {
            return null;
        }
        if (value.getClass().isAssignableFrom(clazz)) {
            return clazz.cast(value);
        }
        throw new ClassCastException(value.getClass().getName() + " cannot be cast to " + clazz.getName());
    }

    public static Object getValue(Field field, Object object) {
        if (field == null) {
            throw new NullPointerException("Field is null!");
        }
        if (!ReflectUtils.isStatic(field) && object == null) {
            throw new NullPointerException("Object is null!");
        }
        ReflectUtils.setFieldAccessible(field);
        try {
            return field.get(object);
        }
        catch (Exception e2) {
            throw new RuntimeException("Could not get value!", e2);
        }
    }

    public static void setFieldAccessible(Field field) {
        try {
            field.setAccessible(true);
        }
        catch (Exception e2) {
            throw new RuntimeException("Could not set field accessible: " + field + ": " + e2.getClass().getName() + ": " + e2.getMessage(), e2);
        }
    }

    public static float getFloatValue(Field field, Object object) {
        return ReflectUtils.getValue(field, object, Float.class).floatValue();
    }

    public static void setValue(Field field, Object object, Object value) {
        try {
            field.set(object, value);
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    public static void printAllStaticFields(Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("Class is null!");
        }
        for (Field field : Utils.combineArray(Field.class, clazz.getFields(), clazz.getDeclaredFields())) {
            if (!ReflectUtils.isStatic(field)) continue;
            ReflectUtils.printField(field, null);
        }
    }

    public static void printAllFields(Class<?> clazz, Object object) {
        if (clazz == null) {
            throw new NullPointerException("Class is null!");
        }
        if (object == null) {
            throw new NullPointerException("Object is null!");
        }
        for (Field field : Utils.combineArray(Field.class, clazz.getFields(), clazz.getDeclaredFields())) {
            if (ReflectUtils.isStatic(field)) continue;
            ReflectUtils.printField(field, object);
        }
    }

    private static void printField(Field field, Object object) {
        try {
            field.setAccessible(true);
            Object value = field.get(object);
            System.out.println(field.getType().getName() + " " + field.getName() + " = " + value);
        }
        catch (Exception e2) {
            System.out.println(field.getType().getName() + " " + field.getName() + " (Could not get Value: " + e2.getClass().getName() + ": " + e2.getMessage() + ")");
        }
    }

    public static boolean isStatic(Field field) {
        return Modifier.isStatic(field.getModifiers());
    }

    public static <F, E> E[] getAllObjects(Class<F> fromClass, Class<E> ofClass, F instance) {
        return ReflectUtils.getAllObjects(fromClass, ofClass, instance, null);
    }

    public static <F, E> E[] getAllObjects(Class<F> fromClass, Class<E> ofClass) {
        return ReflectUtils.getAllObjects(fromClass, ofClass, null);
    }

    public static <F, E> E[] getAllObjects(Class<F> fromClass, Class<E> ofClass, F instance, Condition<Field, E> condition) {
        Field[] fields;
        ArrayList<Object> list = new ArrayList<Object>();
        for (Field field : fields = fromClass.getDeclaredFields()) {
            try {
                Object e2 = field.get(instance);
                if (e2 == null || !ofClass.isAssignableFrom(e2.getClass()) || condition != null && !condition.isTrue(field, (Field)e2)) continue;
                list.add(e2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Utils.toArray(ofClass, list);
    }

    public static interface Condition<E, F> {
        public boolean isTrue(E var1, F var2);
    }
}

