/*
 * Decompiled with CFR 0.152.
 */
package b100.utils;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class StreamUtils {
    public static int cacheSize = 1024;

    public static void transferData(InputStream in2, OutputStream out) throws IOException {
        int read;
        byte[] temp = new byte[cacheSize];
        while ((read = in2.read(temp)) != -1) {
            out.write(temp, 0, read);
        }
    }

    public static void transferDataAndClose(InputStream in2, OutputStream out) throws IOException {
        StreamUtils.transferData(in2, out);
        StreamUtils.close(in2, out);
    }

    public static void close(Closeable ... closeables) {
        for (Closeable closeable : closeables) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

