/*
 * Decompiled with CFR 0.152.
 */
package b100.utils;

import b100.utils.InvalidCharacterException;
import b100.utils.Utils;
import java.util.ArrayList;
import java.util.List;

public class StringReader {
    private String string;
    private int i;

    public StringReader(String string) {
        this.string = Utils.requireNonNull(string);
    }

    public char get() {
        return this.string.charAt(this.i);
    }

    public void skipWhitespace() {
        while (this.i < this.string.length() && this.isWhitespace(this.get())) {
            ++this.i;
        }
    }

    public char getAndSkip() {
        char c2 = this.get();
        this.next();
        return c2;
    }

    public void expectAndSkip(char c2) {
        this.expect(c2);
        this.next();
    }

    public void expect(char c2) {
        this.expectOne("" + c2);
    }

    public void expectOne(String chars) {
        for (int i2 = 0; i2 < chars.length(); ++i2) {
            if (chars.charAt(i2) != this.get()) continue;
            return;
        }
        throw new InvalidCharacterException(this);
    }

    public boolean isWhitespace(char c2) {
        return c2 == ' ' || c2 == '\t' || c2 == '\n';
    }

    public void next() {
        ++this.i;
    }

    public boolean isNext(String string) {
        return this.string.substring(this.i, this.i + string.length()).equals(string);
    }

    public void skip(int i2) {
        this.i += i2;
    }

    public void expectAndSkip(String string) {
        if (!this.isNext(string)) {
            throw new InvalidCharacterException(this);
        }
        this.skip(string.length());
    }

    public int remainingCharacters() {
        return this.string.length() - this.i;
    }

    public String readUntilCharacter(char endChar) {
        char c2;
        StringBuilder builder = new StringBuilder();
        while (this.i < this.string.length() && (c2 = this.get()) != endChar) {
            builder.append(c2);
            this.next();
        }
        return builder.toString();
    }

    public String string() {
        return this.string;
    }

    public int position() {
        return this.i;
    }

    public List<String> lines() {
        ArrayList<String> lines = new ArrayList<String>();
        String line = "";
        for (int i2 = 0; i2 < this.string.length(); ++i2) {
            char c2 = this.string.charAt(i2);
            if (c2 == '\n') {
                lines.add(line);
                line = "";
                continue;
            }
            line = line + c2;
        }
        lines.add(line);
        return lines;
    }
}

