/*
 * Decompiled with CFR 0.152.
 */
package b100.utils;

import b100.utils.FileUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.List;

public abstract class StringUtils {
    public static String getFileContentAsString(String path) {
        StringUtils.validateStringNotEmpty(path);
        return StringUtils.getFileContentAsString(new File(path));
    }

    public static String getFileContentAsString(File file) {
        FileUtils.validateFileExists(file);
        try {
            return StringUtils.readInputString(new FileInputStream(file));
        }
        catch (Exception e2) {
            throw new RuntimeException("Error while reading file", e2);
        }
    }

    public static void saveStringToFile(String path, String content) {
        StringUtils.validateStringNotEmpty(path);
        StringUtils.validateStringNotEmpty(content);
        StringUtils.saveStringToFile(new File(path).getAbsoluteFile(), content);
    }

    public static void saveStringToFile(File file, String content) {
        FileUtils.createNewFile(file);
        StringUtils.validateStringNotEmpty(content);
        if (file == null) {
            throw new NullPointerException();
        }
        if (content == null) {
            throw new NullPointerException();
        }
        try {
            FileUtils.createNewFile(file);
            FileWriter fw2 = new FileWriter(file);
            fw2.write(content);
            fw2.close();
        }
        catch (Exception e2) {
            throw new RuntimeException(file.getAbsolutePath(), e2);
        }
    }

    public static String readInputString(InputStream inputStream) {
        if (inputStream == null) {
            throw new NullPointerException();
        }
        try {
            InputStreamReader reader = new InputStreamReader(inputStream);
            BufferedReader br2 = new BufferedReader(reader);
            String string = "";
            String line = null;
            boolean firstLine = true;
            while ((line = br2.readLine()) != null) {
                if (firstLine) {
                    firstLine = false;
                } else {
                    line = "\n" + line;
                }
                string = string + line;
            }
            br2.close();
            reader.close();
            return string;
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    public static String getWebsiteContentAsString(String url) {
        StringUtils.validateStringNotEmpty(url);
        URL u2 = null;
        InputStream is2 = null;
        try {
            u2 = new URL(url);
        }
        catch (Exception e2) {
            throw new RuntimeException(url, e2);
        }
        try {
            is2 = u2.openStream();
        }
        catch (Exception e3) {
            throw new RuntimeException(u2.toString(), e3);
        }
        return StringUtils.readInputString(is2);
    }

    public static boolean isStringEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static void validateStringNotEmpty(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        if (string.length() == 0) {
            throw new RuntimeException("Empty String");
        }
    }

    public static String[] toArray(List<String> list) {
        String[] array = new String[list.size()];
        for (int i2 = 0; i2 < array.length; ++i2) {
            array[i2] = list.get(i2);
        }
        return array;
    }

    public static String getResourceAsString(String string) {
        return StringUtils.readInputString(StringUtils.class.getResourceAsStream(string));
    }
}

