/*
 * Decompiled with CFR 0.152.
 */
package bta;

import b100.utils.FileUtils;
import bta.Mod;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.client.Minecraft;

public class ModLoader {
    public final Minecraft minecraft;
    private File modsFolder;
    private List<Class<?>> modClasses = new ArrayList();
    private List<Mod> mods = new ArrayList<Mod>();

    public ModLoader(Minecraft minecraft) {
        this.minecraft = minecraft;
    }

    /*
     * WARNING - void declaration
     */
    public void init() throws Throwable {
        void var4_6;
        String[] classPathEntries;
        this.modsFolder = new File(Minecraft.getMinecraftDir(), "mods");
        if (!this.modsFolder.exists()) {
            FileUtils.createFolder(this.modsFolder);
        }
        String[] stringArray = classPathEntries = System.getProperty("java.class.path").split(";");
        int n2 = stringArray.length;
        boolean bl2 = false;
        while (var4_6 < n2) {
            String classPathEntry = stringArray[var4_6];
            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
            File classPathEntryFile = new File(classPathEntry);
            if (classPathEntryFile.isDirectory()) {
                List<File> files = FileUtils.getAllFiles(classPathEntryFile);
                for (File file2 : files) {
                    if (!file2.getName().endsWith(".class")) continue;
                    String className = file2.getAbsolutePath().substring(classPathEntryFile.getAbsolutePath().length() + 1);
                    className = className.replace('\\', '.');
                    className = className.replace('/', '.');
                    className = className.substring(0, className.length() - 6);
                    this.loadClass(classLoader, className);
                }
            }
            if (classPathEntryFile.isFile() && !classPathEntryFile.getName().equals("lwjgl.jar") && !classPathEntryFile.getName().equals("lwjgl_util.jar")) {
                this.loadClassesInZipfile(classPathEntryFile);
            }
            ++var4_6;
        }
        File[] modFolderFiles = this.modsFolder.listFiles();
        for (File modFile : modFolderFiles) {
            if (!modFile.isFile()) continue;
            try {
                if (modFile.getName().endsWith(".disabled")) continue;
                System.out.println("Loading Mod File: " + modFile.getName());
                this.loadClassesInZipfile(modFile);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        for (Class clazz : this.modClasses) {
            this.loadMod(clazz);
        }
    }

    public void loadClassesInZipfile(File file) throws Exception {
        ZipFile zip = new ZipFile(file);
        URLClassLoader urlClassLoader = new URLClassLoader(ModLoader.toArray("jar:file:" + file.getAbsolutePath() + "!/"));
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (!entry.toString().endsWith(".class")) continue;
            String className = entry.toString();
            className = className.replace('\\', '.');
            className = className.replace('/', '.');
            className = className.substring(0, className.length() - 6);
            this.loadClass(urlClassLoader, className);
        }
        zip.close();
    }

    public boolean isModClass(Class<?> clazz) {
        return Mod.class.isAssignableFrom(clazz) && !clazz.isAssignableFrom(Mod.class);
    }

    public void loadClass(ClassLoader classLoader, String className) {
        try {
            Class<?> clazz = classLoader.loadClass(className);
            if (this.isModClass(clazz)) {
                this.modClasses.add(clazz);
            }
        }
        catch (Throwable ex2) {
            System.err.println("Error loading class \"" + className + "\": " + ex2.getClass().getName() + ": " + ex2.getMessage());
        }
    }

    public void loadMod(Class<?> modClass) throws Exception {
        System.out.println("Loading Mod: " + modClass.getName());
        Mod mod = (Mod)modClass.newInstance();
        mod.init(this.minecraft);
        this.mods.add(mod);
    }

    public static URL[] toArray(String ... strings) throws Exception {
        URL[] u2 = new URL[strings.length];
        for (int i2 = 0; i2 < u2.length; ++i2) {
            u2[i2] = new URL(strings[i2]);
        }
        return u2;
    }
}

