/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.AchievementList;
import net.minecraft.src.Block;
import net.minecraft.src.IStatStringFormat;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.StatBase;
import net.minecraft.src.StatStringTranslate;

public class Achievement
extends StatBase {
    public final int x;
    public final int y;
    public final Achievement parent;
    private final String description;
    private IStatStringFormat statStringFormatter;
    public final ItemStack item;
    private boolean isSpecial;

    public Achievement(int id2, String name, int x2, int y2, Item item, Achievement parent) {
        this(id2, name, x2, y2, new ItemStack(item), parent);
    }

    public Achievement(int i2, String name, int x2, int y2, Block block, Achievement parent) {
        this(i2, name, x2, y2, new ItemStack(block), parent);
    }

    public Achievement(int id2, String name, int x2, int y2, ItemStack item, Achievement parent) {
        super(0x500000 + id2, StatStringTranslate.translateToLocal("achievement." + name));
        this.item = item;
        this.description = StatStringTranslate.translateToLocal("achievement." + name + ".desc");
        this.x = x2;
        this.y = y2;
        if (x2 < AchievementList.minX) {
            AchievementList.minX = x2;
        }
        if (y2 < AchievementList.minY) {
            AchievementList.minY = y2;
        }
        if (x2 > AchievementList.maxX) {
            AchievementList.maxX = x2;
        }
        if (y2 > AchievementList.maxY) {
            AchievementList.maxY = y2;
        }
        this.parent = parent;
    }

    public Achievement setClientsideAchievement() {
        this.clientside = true;
        return this;
    }

    public Achievement setSpecial() {
        this.isSpecial = true;
        return this;
    }

    public Achievement registerAchievement() {
        super.registerStat();
        AchievementList.achievementList.add(this);
        return this;
    }

    @Override
    public boolean isAchievement() {
        return true;
    }

    public String getDescription() {
        if (this.statStringFormatter != null) {
            return this.statStringFormatter.formatString(this.description);
        }
        return this.description;
    }

    public Achievement setStatStringFormatter(IStatStringFormat istatstringformat) {
        this.statStringFormatter = istatstringformat;
        return this;
    }

    public boolean getSpecial() {
        return this.isSpecial;
    }

    @Override
    public StatBase registerStat() {
        return this.registerAchievement();
    }

    @Override
    public StatBase setClientside() {
        return this.setClientsideAchievement();
    }
}

